/*
 * Decompiled with CFR 0.152.
 */
package org.castor.cpa.persistence.sql.engine;

import java.sql.ResultSet;
import java.sql.SQLException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.castor.core.nature.PropertyHolder;
import org.castor.core.util.Messages;
import org.castor.cpa.persistence.sql.engine.CastorConnection;
import org.castor.cpa.persistence.sql.engine.CastorStatement;
import org.castor.cpa.persistence.sql.engine.info.ColumnInfo;
import org.castor.cpa.persistence.sql.engine.info.ColumnValue;
import org.castor.cpa.persistence.sql.engine.info.TableInfo;
import org.castor.cpa.persistence.sql.query.Select;
import org.castor.cpa.persistence.sql.query.Table;
import org.castor.cpa.persistence.sql.query.condition.AndCondition;
import org.castor.cpa.persistence.sql.query.condition.Condition;
import org.castor.cpa.persistence.sql.query.expression.Parameter;
import org.exolab.castor.jdo.ObjectDeletedException;
import org.exolab.castor.jdo.ObjectModifiedException;
import org.exolab.castor.jdo.PersistenceException;
import org.exolab.castor.jdo.engine.SQLEngine;
import org.exolab.castor.jdo.engine.nature.ClassDescriptorJDONature;
import org.exolab.castor.persist.spi.Identity;

public final class SQLStatementUpdateCheck {
    private static final Log LOG = LogFactory.getLog(SQLStatementUpdateCheck.class);
    private final String _type;
    private Select _select;
    private TableInfo _tableInfo;

    public SQLStatementUpdateCheck(SQLEngine engine) {
        this._type = engine.getDescriptor().getJavaClass().getName();
        this._tableInfo = engine.getTableInfo();
        this.buildStatement(new ClassDescriptorJDONature((PropertyHolder)engine.getDescriptor()).getTableName());
    }

    private void buildStatement(String mapTo) {
        Table table = new Table(mapTo);
        AndCondition condition = new AndCondition();
        for (ColumnInfo col : this._tableInfo.getPrimaryKey().getColumns()) {
            ((Condition)condition).and(table.column(col.getName()).equal(new Parameter(col.getName())));
        }
        this._select = new Select(table);
        this._select.addSelect(table.column(this._tableInfo.getPrimaryKey().getColumns().get(0).getName()));
        this._select.setCondition(condition);
    }

    public void updateFailureCheck(CastorConnection conn, Identity identity) throws PersistenceException {
        CastorStatement stmt = conn.createStatement();
        try {
            try {
                String msg;
                stmt.prepareStatement(this._select);
                for (ColumnValue value : this._tableInfo.toSQL(identity)) {
                    stmt.bindParameter(value.getName(), value.getValue(), value.getType());
                    if (!LOG.isTraceEnabled()) continue;
                    LOG.trace((Object)Messages.format((String)"jdo.bindingIdentity", (Object)value.getName(), (Object)value.getValue()));
                }
                ResultSet resultSet = stmt.executeQuery();
                if (resultSet.next()) {
                    msg = Messages.format((String)"persist.objectModified", (Object)this._type, (Object)identity);
                    throw new ObjectModifiedException(msg);
                }
                msg = Messages.format((String)"persist.objectDeleted", (Object)this._type, (Object)identity);
                throw new ObjectDeletedException(msg);
            }
            catch (SQLException except) {
                LOG.fatal((Object)Messages.format((String)"jdo.updateCheckFatal", (Object)this._type, (Object)stmt.toString()), (Throwable)except);
                throw new PersistenceException(Messages.format((String)"persist.nested", (Object)except), except);
            }
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            try {
                stmt.close();
            }
            catch (SQLException e) {
                LOG.warn((Object)"Problem closing JDBC statement", (Throwable)e);
            }
            throw throwable;
        }
    }
}

