/*
 * Decompiled with CFR 0.152.
 */
package org.castor.cpa.persistence.sql.engine.info;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.castor.core.nature.PropertyHolder;
import org.castor.cpa.persistence.sql.engine.info.ColumnInfo;
import org.castor.cpa.persistence.sql.engine.info.TableInfo;
import org.castor.cpa.persistence.sql.engine.info.TableLink;
import org.exolab.castor.jdo.engine.nature.ClassDescriptorJDONature;
import org.exolab.castor.jdo.engine.nature.FieldDescriptorJDONature;
import org.exolab.castor.mapping.ClassDescriptor;
import org.exolab.castor.mapping.FieldDescriptor;
import org.exolab.castor.mapping.MappingException;
import org.exolab.castor.mapping.TypeConvertor;
import org.exolab.castor.mapping.loader.ClassDescriptorImpl;
import org.exolab.castor.mapping.loader.FieldHandlerImpl;

public final class InfoFactory {
    private final Map<String, TableInfo> _entityMap = new HashMap<String, TableInfo>();

    public TableInfo createTableInfo(ClassDescriptor classDescriptor) throws MappingException {
        String name = classDescriptor.getJavaClass().getName();
        TableInfo table = this._entityMap.get(name);
        if (table == null) {
            if (!classDescriptor.hasNature(ClassDescriptorJDONature.class.getName())) {
                throw new MappingException("ClassDescriptor is not a JDOClassDescriptor");
            }
            ClassDescriptorJDONature classNature = new ClassDescriptorJDONature((PropertyHolder)classDescriptor);
            table = new TableInfo(classNature.getTableName());
            this._entityMap.put(name, table);
            if (classDescriptor.getExtends() != null) {
                table.setExtendedTable(this.createTableInfo(classDescriptor.getExtends()));
            }
            for (ClassDescriptor extending : classNature.getExtended()) {
                table.addExtendingTable(this.createTableInfo(extending));
            }
            this.resolvePrimaryKeys(classDescriptor, table);
            this.resolveColumns(classDescriptor, table);
        }
        return table;
    }

    private void resolvePrimaryKeys(ClassDescriptor classDescriptor, TableInfo table) throws MappingException {
        for (FieldDescriptor selfFD : ((ClassDescriptorImpl)classDescriptor).getIdentities()) {
            if (!selfFD.hasNature(FieldDescriptorJDONature.class.getName())) {
                throw new MappingException("Excepted JDOFieldDescriptor");
            }
            FieldDescriptorJDONature selfFN = new FieldDescriptorJDONature((PropertyHolder)selfFD);
            String sqlName = selfFN.getSQLName()[0];
            int selfType = selfFN.getSQLType()[0];
            TypeConvertor convFrom = ((FieldHandlerImpl)selfFD.getHandler()).getConvertFrom();
            ColumnInfo column = new ColumnInfo(sqlName, -1, selfType, convFrom, false, false);
            table.getPrimaryKey().addColumn(column);
        }
    }

    private void resolveColumns(ClassDescriptor selfCD, TableInfo table) throws MappingException {
        FieldDescriptor[] selfFDs = selfCD.getFields();
        int persIndex = 0;
        for (int fieldIndex = 0; fieldIndex < selfFDs.length; ++fieldIndex) {
            boolean isDirtyCheck;
            boolean isStore;
            FieldDescriptor selfFD = selfFDs[fieldIndex];
            if (selfFD.isTransient() || !selfFD.hasNature(FieldDescriptorJDONature.class.getName()) && selfFD.getClassDescriptor() == null) continue;
            ClassDescriptor referedCD = selfFD.getClassDescriptor();
            if (referedCD != null) {
                TableLink foreignKey;
                if (!referedCD.hasNature(ClassDescriptorJDONature.class.getName())) {
                    throw new MappingException("Related class is not a JDOClassDescriptor");
                }
                int mode = 1;
                String[] backCols = null;
                String[] referedCols = null;
                String manyTableName = null;
                isStore = false;
                isDirtyCheck = false;
                if (selfFD.hasNature(FieldDescriptorJDONature.class.getName())) {
                    FieldDescriptorJDONature selfFN = new FieldDescriptorJDONature((PropertyHolder)selfFD);
                    mode = selfFN.getManyTable() != null ? 2 : (selfFN.getSQLName() != null ? 0 : 1);
                    backCols = selfFN.getManyKey();
                    referedCols = selfFN.getSQLName();
                    manyTableName = selfFN.getManyTable();
                    isStore = table.getExtendedTable() == null && !selfFN.isReadonly();
                    isDirtyCheck = selfFN.isDirtyCheck();
                }
                FieldDescriptor[] selfIDs = ((ClassDescriptorImpl)selfCD).getIdentities();
                if (backCols == null) {
                    backCols = this.getSQLNames(selfIDs);
                } else if (backCols.length != selfIDs.length) {
                    throw new MappingException("The number of columns of foreign key does not match with primary key of current class");
                }
                FieldDescriptor[] referedIDs = ((ClassDescriptorImpl)referedCD).getIdentities();
                if (referedCols == null) {
                    referedCols = this.getSQLNames(referedIDs);
                } else if (referedCols.length != referedIDs.length) {
                    throw new MappingException("The number of columns of foreign key does not match with primary key of related class");
                }
                if (mode == 2) {
                    TableInfo manyTable = new TableInfo(manyTableName);
                    foreignKey = new TableLink(manyTable, mode, manyTable.getTableName() + "_f" + fieldIndex, table.getPrimaryKey().getColumns(), persIndex);
                    table.addForeignKey(foreignKey);
                    for (String referedCol : referedCols) {
                        manyTable.addColumn(new ColumnInfo(referedCol));
                    }
                    for (String backCol : backCols) {
                        foreignKey.addTargetCol(new ColumnInfo(backCol));
                    }
                } else if (mode == 0) {
                    ArrayList<ColumnInfo> columns = new ArrayList<ColumnInfo>();
                    for (int j = 0; j < referedIDs.length; ++j) {
                        if (!referedIDs[j].hasNature(FieldDescriptorJDONature.class.getName())) {
                            throw new MappingException("Related class identities field does not contains sql information!");
                        }
                        FieldDescriptor relId = referedIDs[j];
                        FieldHandlerImpl fh = (FieldHandlerImpl)relId.getHandler();
                        columns.add(new ColumnInfo(referedCols[j], persIndex, new FieldDescriptorJDONature((PropertyHolder)relId).getSQLType()[0], fh.getConvertFrom(), isStore, isDirtyCheck));
                    }
                    TableInfo relatedTable = this.createTableInfo(referedCD);
                    TableLink foreignKey2 = new TableLink(relatedTable, mode, relatedTable.getTableName() + "_f" + fieldIndex, columns, persIndex);
                    table.addForeignKey(foreignKey2);
                    foreignKey2.addTargetCols(relatedTable.getPrimaryKey().getColumns());
                } else {
                    TableInfo relatedTable = this.createTableInfo(referedCD);
                    foreignKey = new TableLink(relatedTable, mode, relatedTable.getTableName() + "_f" + fieldIndex, table.getPrimaryKey().getColumns(), persIndex);
                    table.addForeignKey(foreignKey);
                    foreignKey.setManyKey(Arrays.asList(backCols));
                }
            } else {
                FieldDescriptorJDONature selfFN = new FieldDescriptorJDONature((PropertyHolder)selfFD);
                String sqlName = selfFD.getFieldName();
                if (selfFN.getSQLName() != null) {
                    sqlName = selfFN.getSQLName()[0];
                }
                int selfType = selfFN.getSQLType()[0];
                TypeConvertor convFrom = ((FieldHandlerImpl)selfFD.getHandler()).getConvertFrom();
                isStore = table.getExtendedTable() == null && !selfFN.isReadonly();
                isDirtyCheck = selfFN.isDirtyCheck();
                ColumnInfo column = new ColumnInfo(sqlName, persIndex, selfType, convFrom, isStore, isDirtyCheck);
                table.addColumn(column);
            }
            ++persIndex;
        }
    }

    private String[] getSQLNames(FieldDescriptor[] fieldDesc) throws MappingException {
        String[] names = new String[fieldDesc.length];
        for (int j = 0; j < fieldDesc.length; ++j) {
            names[j] = new FieldDescriptorJDONature((PropertyHolder)fieldDesc[j]).getSQLName()[0];
            if (names[j] != null) continue;
            throw new MappingException("Related class identities field does not contain sql information!");
        }
        return names;
    }

    public void resolveForeignKeys() {
        for (TableInfo table : this._entityMap.values()) {
            this.adjustTableLinks(table);
        }
    }

    private void adjustTableLinks(TableInfo table) {
        for (TableLink foreignKey : table.getForeignKeys()) {
            if (1 != foreignKey.getRelationType()) continue;
            for (ColumnInfo col : foreignKey.getTargetTable().iterateAll()) {
                for (String key : foreignKey.getManyKey()) {
                    if (!key.equals(col.getName())) continue;
                    foreignKey.addTargetCol(col);
                }
            }
            if (foreignKey.getTargetCols().isEmpty()) {
                for (TableLink tblLink : foreignKey.getTargetTable().getForeignKeys()) {
                    if (!tblLink.getTargetTable().equals(this) || tblLink.getManyKey() == null) continue;
                    for (ColumnInfo col : tblLink.getStartCols()) {
                        for (String key : tblLink.getManyKey()) {
                            if (!key.equals(col.getName())) continue;
                            foreignKey.addTargetCols(tblLink.getStartCols());
                        }
                    }
                }
            }
            if (!foreignKey.getTargetCols().isEmpty()) continue;
            for (String key : foreignKey.getManyKey()) {
                ColumnInfo col = new ColumnInfo(key);
                foreignKey.getTargetTable().addColumn(col);
                foreignKey.addTargetCol(col);
            }
        }
    }
}

