/*
 * Decompiled with CFR 0.152.
 */
package org.castor.cpa.persistence.sql.engine.info;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.persistence.PersistenceException;
import org.castor.cpa.persistence.sql.engine.info.ColumnInfo;
import org.castor.cpa.persistence.sql.engine.info.ColumnValue;
import org.castor.cpa.persistence.sql.engine.info.PrimaryKeyInfo;
import org.castor.cpa.persistence.sql.engine.info.TableLink;
import org.exolab.castor.persist.spi.Identity;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class TableInfo {
    private final String _tableName;
    private TableInfo _extendedTable;
    private final List<TableInfo> _extendingTables = new ArrayList<TableInfo>();
    private final List<ColumnInfo> _columns = new ArrayList<ColumnInfo>();
    private final PrimaryKeyInfo _primaryKey;
    private final List<TableLink> _foreignKeys = new ArrayList<TableLink>();

    protected TableInfo(String tableName) {
        this._tableName = tableName;
        this._primaryKey = new PrimaryKeyInfo(this);
    }

    protected void setExtendedTable(TableInfo table) {
        this._extendedTable = table;
    }

    protected void addExtendingTable(TableInfo table) {
        this._extendingTables.add(table);
    }

    protected void addColumn(ColumnInfo column) {
        this._columns.add(column);
    }

    protected void addForeignKey(TableLink foreignKey) {
        this._foreignKeys.add(foreignKey);
    }

    public List<ColumnInfo> iterateAll() {
        ArrayList<ColumnInfo> columns = new ArrayList<ColumnInfo>();
        columns.addAll(this._primaryKey.getColumns());
        columns.addAll(this._columns);
        for (TableLink foreignKey : this._foreignKeys) {
            for (ColumnInfo column : foreignKey.getStartCols()) {
                if (columns.contains(column)) continue;
                columns.add(column);
            }
        }
        return columns;
    }

    public String getTableName() {
        return this._tableName;
    }

    public TableInfo getExtendedTable() {
        return this._extendedTable;
    }

    public List<TableInfo> getExtendingTables() {
        return this._extendingTables;
    }

    public List<ColumnInfo> getColumns() {
        return this._columns;
    }

    public PrimaryKeyInfo getPrimaryKey() {
        return this._primaryKey;
    }

    public List<TableLink> getForeignKeys() {
        return this._foreignKeys;
    }

    public List<ColumnValue> toSQL(Identity input) {
        ArrayList<ColumnValue> values = new ArrayList<ColumnValue>();
        List<ColumnInfo> columns = this.getPrimaryKey().getColumns();
        for (int i = 0; i < columns.size(); ++i) {
            ColumnInfo column = columns.get(i);
            values.add(new ColumnValue(column, column.getIndex(), input.get(i)));
        }
        return values;
    }

    public List<ColumnValue> toSQL(Object[] input) {
        ArrayList<ColumnValue> values = new ArrayList<ColumnValue>();
        for (ColumnInfo column : this.getColumns()) {
            values.add(new ColumnValue(column, column.getIndex(), null));
        }
        for (TableLink lnk : this._foreignKeys) {
            for (ColumnInfo column : lnk.getStartCols()) {
                if (values.contains(column)) continue;
                int index = column.getIndex();
                if (index == -1) {
                    index = lnk.getFieldIndex();
                }
                values.add(new ColumnValue(column, index, null));
            }
        }
        int size = this._columns.size() + this._foreignKeys.size();
        int counter = 0;
        for (int i = 0; i < size; ++i) {
            Object inpt = input[i];
            if (inpt == null) {
                while (counter < values.size() && i == ((ColumnValue)values.get(counter)).getIndex()) {
                    ((ColumnValue)values.get(counter)).setValue(null);
                    ++counter;
                }
                continue;
            }
            if (inpt instanceof Identity) {
                Identity identity = (Identity)inpt;
                int indx = 0;
                while (counter < values.size() && i == ((ColumnValue)values.get(counter)).getIndex()) {
                    if (identity.get(indx) != null) {
                        ((ColumnValue)values.get(counter)).setValue(identity.get(indx));
                    }
                    ++indx;
                    ++counter;
                }
                if (identity.size() == indx) continue;
                throw new PersistenceException("Size of identity field mismatch!");
            }
            while (counter < values.size() && i == ((ColumnValue)values.get(counter)).getIndex()) {
                if (!(inpt instanceof Collection)) {
                    ((ColumnValue)values.get(counter)).setValue(inpt);
                }
                ++counter;
            }
        }
        return values;
    }
}

