/*
 * Decompiled with CFR 0.152.
 */
package org.castor.cpa.persistence.sql.keygen;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.castor.core.nature.PropertyHolder;
import org.castor.core.util.AbstractProperties;
import org.castor.core.util.Messages;
import org.castor.cpa.CPAProperties;
import org.castor.cpa.persistence.sql.engine.CastorConnection;
import org.castor.cpa.persistence.sql.engine.CastorStatement;
import org.castor.cpa.persistence.sql.keygen.AbstractKeyGenerator;
import org.castor.cpa.persistence.sql.keygen.KeyGenerator;
import org.castor.cpa.persistence.sql.query.Insert;
import org.castor.cpa.persistence.sql.query.expression.Column;
import org.castor.cpa.persistence.sql.query.expression.NextVal;
import org.castor.cpa.persistence.sql.query.expression.Parameter;
import org.castor.persist.ProposedEntity;
import org.exolab.castor.core.exceptions.CastorIllegalStateException;
import org.exolab.castor.jdo.Database;
import org.exolab.castor.jdo.PersistenceException;
import org.exolab.castor.jdo.engine.SQLColumnInfo;
import org.exolab.castor.jdo.engine.SQLEngine;
import org.exolab.castor.jdo.engine.SQLFieldInfo;
import org.exolab.castor.jdo.engine.nature.ClassDescriptorJDONature;
import org.exolab.castor.mapping.ClassDescriptor;
import org.exolab.castor.persist.spi.Identity;

public abstract class AbstractAfterKeyGenerator
extends AbstractKeyGenerator {
    private static final Log LOG = LogFactory.getLog(AbstractAfterKeyGenerator.class);
    private SQLEngine _engine;
    private String _engineType = null;
    private final boolean _useJDBC30;
    private String _mapTo;
    private boolean _triggerPresent;
    private String _seqName;
    private Insert _insert;

    public AbstractAfterKeyGenerator(Properties params) {
        AbstractProperties properties = CPAProperties.getInstance();
        this._useJDBC30 = properties.getBoolean("org.castor.jdo.use.jdbc30", false);
        if (params != null) {
            this._triggerPresent = "true".equals(params.getProperty("trigger", "false"));
            this._seqName = params.getProperty("sequence", "{0}_seq");
        }
    }

    public KeyGenerator buildStatement(SQLEngine engine) {
        this._engine = engine;
        ClassDescriptor clsDesc = this._engine.getDescriptor();
        this._engineType = clsDesc.getJavaClass().getName();
        this._mapTo = new ClassDescriptorJDONature((PropertyHolder)clsDesc).getTableName();
        this._insert = new Insert(this._mapTo);
        SQLFieldInfo[] fields = this._engine.getInfo();
        for (int i = 0; i < fields.length; ++i) {
            if (!fields[i].isStore()) continue;
            SQLColumnInfo[] columns = fields[i].getColumnInfo();
            for (int j = 0; j < columns.length; ++j) {
                String name = columns[j].getName();
                this._insert.addAssignment(new Column(name), new Parameter(name));
            }
        }
        SQLColumnInfo[] ids = this._engine.getColumnInfoForIdentities();
        if (this._seqName != null && !this._triggerPresent) {
            this._insert.addAssignment(new Column(ids[0].getName()), new NextVal(this._seqName));
        }
        return this;
    }

    public Object executeStatement(Database database, CastorConnection conn, Identity identity, ProposedEntity entity) throws PersistenceException {
        Identity internalIdentity = identity;
        SQLEngine extended = this._engine.getExtends();
        CastorStatement stmt = conn.createStatement();
        try {
            ClassDescriptor extDesc;
            if (extended != null && !new ClassDescriptorJDONature((PropertyHolder)(extDesc = extended.getDescriptor())).getTableName().equals(this._mapTo)) {
                internalIdentity = extended.create(database, conn.getConnection(), entity, internalIdentity);
            }
            if (internalIdentity == null && this._useJDBC30) {
                Field field = Statement.class.getField("RETURN_GENERATED_KEYS");
                stmt.prepareStatement(this._insert);
                String statement = stmt.toString();
                Integer rgk = (Integer)field.get(statement);
                Class[] types = new Class[]{String.class, Integer.TYPE};
                Object[] args = new Object[]{statement, rgk};
                Method method = Connection.class.getMethod("prepareStatement", types);
                stmt.setStatement((PreparedStatement)method.invoke((Object)conn.getConnection(), args));
            } else {
                stmt.prepareStatement(this._insert);
            }
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)Messages.format((String)"jdo.creating", (Object)this._engineType, (Object)stmt.toString()));
            }
            this.bindFields(entity, stmt);
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)Messages.format((String)"jdo.creating", (Object)this._engineType, (Object)stmt.toString()));
            }
            stmt.executeUpdate();
            SQLColumnInfo[] ids = this._engine.getColumnInfoForIdentities();
            if (internalIdentity == null) {
                if (this._useJDBC30) {
                    Class<PreparedStatement> cls = PreparedStatement.class;
                    Method method = cls.getMethod("getGeneratedKeys", null);
                    ResultSet keySet = (ResultSet)method.invoke((Object)stmt.getStatement(), (Object[])null);
                    int i = 1;
                    ArrayList<Object> keys = new ArrayList<Object>();
                    while (keySet.next()) {
                        int sqlType = ids[i - 1].getSqlType();
                        Object temp = sqlType == 4 ? new Integer(keySet.getInt(i)) : (sqlType == 2 ? keySet.getBigDecimal(i) : keySet.getObject(i));
                        keys.add(ids[i - 1].toJava(temp));
                        ++i;
                    }
                    internalIdentity = new Identity(keys.toArray());
                    stmt.close();
                } else {
                    internalIdentity = this.generateKey(database, conn);
                    stmt.close();
                }
            }
            return internalIdentity;
        }
        catch (SQLException except) {
            LOG.fatal((Object)Messages.format((String)"jdo.storeFatal", (Object)this._engineType, (Object)stmt.toString()), (Throwable)except);
            try {
                if (stmt != null) {
                    stmt.close();
                }
            }
            catch (SQLException except2) {
                LOG.warn((Object)"Problem closing JDBC statement", (Throwable)except2);
            }
            throw new PersistenceException(Messages.format((String)"persist.nested", (Object)except), except);
        }
        catch (NoSuchMethodException ex) {
            throw new CastorIllegalStateException((Throwable)ex);
        }
        catch (NoSuchFieldException ex) {
            throw new CastorIllegalStateException((Throwable)ex);
        }
        catch (IllegalAccessException ex) {
            throw new CastorIllegalStateException((Throwable)ex);
        }
        catch (InvocationTargetException ex) {
            throw new CastorIllegalStateException((Throwable)ex);
        }
    }

    private void bindFields(ProposedEntity entity, CastorStatement stmt) throws SQLException, PersistenceException {
        SQLFieldInfo[] fields = this._engine.getInfo();
        for (int i = 0; i < fields.length; ++i) {
            SQLColumnInfo[] columns = fields[i].getColumnInfo();
            if (!fields[i].isStore()) continue;
            Object value = entity.getField(i);
            if (value == null) {
                for (int j = 0; j < columns.length; ++j) {
                    stmt.bindParameter(columns[j].getName(), null, columns[j].getSqlType());
                }
                continue;
            }
            if (value instanceof Identity) {
                Identity identity = (Identity)value;
                if (identity.size() != columns.length) {
                    throw new PersistenceException("Size of identity field mismatch!");
                }
                for (int j = 0; j < columns.length; ++j) {
                    stmt.bindParameter(columns[j].getName(), columns[j].toSQL(identity.get(j)), columns[j].getSqlType());
                }
                continue;
            }
            if (columns.length != 1) {
                throw new PersistenceException("Complex field expected!");
            }
            stmt.bindParameter(columns[0].getName(), columns[0].toSQL(value), columns[0].getSqlType());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Identity generateKey(Database database, CastorConnection conn) throws PersistenceException {
        Object object;
        SQLColumnInfo id = this._engine.getColumnInfoForIdentities()[0];
        Connection connection = conn.getConnection();
        if (!this.isInSameConnection()) {
            connection = this.getSeparateConnection(database);
        }
        try {
            Object identity;
            object = connection;
            synchronized (object) {
                identity = this.generateKey(connection, this._mapTo, id.getName());
            }
            if (identity == null) {
                throw new PersistenceException(Messages.format((String)"persist.noIdentity", (Object)this._engineType));
            }
            object = new Identity(id.toJava(identity));
            Object var9_8 = null;
        }
        catch (Throwable throwable) {
            block8: {
                Object var9_9 = null;
                if (this.isInSameConnection()) break block8;
                this.closeSeparateConnection(connection);
            }
            throw throwable;
        }
        if (!this.isInSameConnection()) {
            this.closeSeparateConnection(connection);
        }
        return object;
    }
}

