/*
 * Decompiled with CFR 0.152.
 */
package org.castor.cpa.persistence.sql.keygen;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.castor.core.util.Messages;
import org.castor.cpa.persistence.sql.keygen.AbstractBeforeKeyGenerator;
import org.castor.cpa.persistence.sql.keygen.HighLowValueHandler;
import org.castor.cpa.persistence.sql.keygen.typehandler.KeyGeneratorTypeHandler;
import org.castor.cpa.persistence.sql.keygen.typehandler.KeyGeneratorTypeHandlerBigDecimal;
import org.castor.cpa.persistence.sql.keygen.typehandler.KeyGeneratorTypeHandlerInteger;
import org.castor.cpa.persistence.sql.keygen.typehandler.KeyGeneratorTypeHandlerLong;
import org.exolab.castor.jdo.PersistenceException;
import org.exolab.castor.mapping.MappingException;
import org.exolab.castor.persist.spi.PersistenceFactory;
import org.exolab.castor.persist.spi.QueryExpression;

public final class HighLowKeyGenerator
extends AbstractBeforeKeyGenerator {
    private static final Log LOG = LogFactory.getLog(HighLowKeyGenerator.class);
    private static final String SEQ_TABLE = "table";
    private static final String SEQ_KEY = "key-column";
    private static final String SEQ_VALUE = "value-column";
    private static final String GRAB_SIZE = "grab-size";
    private static final String SAME_CONNECTION = "same-connection";
    private static final String GLOBAL = "global";
    private static final int UPDATE_PARAM_MAX = 1;
    private static final int UPDATE_PARAM_TABLE = 2;
    private static final int UPDATE_PARAM_LAST = 3;
    private static final int INSERT_PARAM_TABLE = 1;
    private static final int INSERT_PARAM_MAX = 2;
    private static final int LOCK_TRIALS = 7;
    private final Map<String, HighLowValueHandler<? extends Object>> _handlers = new HashMap<String, HighLowValueHandler<? extends Object>>();
    private final PersistenceFactory _factory;
    private final int _sqlType;
    private String _seqTable;
    private String _seqKey;
    private String _seqValue;
    private int _grabSize;
    private boolean _sameConnection;
    private boolean _global;

    public HighLowKeyGenerator(PersistenceFactory factory, Properties params, int sqlType) throws MappingException {
        super(factory);
        this._factory = factory;
        this._sqlType = sqlType;
        if (sqlType != 4 && sqlType != -5 && sqlType != 2 && sqlType != 3) {
            String msg = Messages.format((String)"mapping.keyGenSQLType", (Object)this.getClass().getName(), (Object)new Integer(sqlType));
            throw new MappingException(msg);
        }
        this.initFromParameters(params);
    }

    public void initFromParameters(Properties params) throws MappingException {
        this._seqTable = params.getProperty(SEQ_TABLE);
        if (this._seqTable == null) {
            throw new MappingException(Messages.format((String)"mapping.KeyGenParamNotSet", (Object)SEQ_TABLE, (Object)this.getClass().getName()));
        }
        this._seqKey = params.getProperty(SEQ_KEY);
        if (this._seqKey == null) {
            throw new MappingException(Messages.format((String)"mapping.KeyGenParamNotSet", (Object)SEQ_KEY, (Object)this.getClass().getName()));
        }
        this._seqValue = params.getProperty(SEQ_VALUE);
        if (this._seqValue == null) {
            throw new MappingException(Messages.format((String)"mapping.KeyGenParamNotSet", (Object)SEQ_VALUE, (Object)this.getClass().getName()));
        }
        String grabSize = params.getProperty(GRAB_SIZE, "10");
        try {
            this._grabSize = Integer.parseInt(grabSize);
        }
        catch (NumberFormatException except) {
            this._grabSize = 0;
        }
        if (this._grabSize <= 0) {
            throw new MappingException(Messages.format((String)"mapping.wrongKeyGenParam", (Object)grabSize, (Object)GRAB_SIZE, (Object)this.getClass().getName()));
        }
        this._sameConnection = "true".equals(params.getProperty(SAME_CONNECTION));
        this._global = "true".equals(params.getProperty(GLOBAL));
    }

    /*
     * Loose catch block
     */
    public synchronized Object generateKey(Connection conn, String tableName, String primKeyName) throws PersistenceException {
        HighLowValueHandler<? extends Object> handler;
        block27: {
            String intTableName = tableName;
            if (this._global) {
                intTableName = "<GLOBAL>";
            }
            if ((handler = this._handlers.get(intTableName)) == null) {
                KeyGeneratorTypeHandler<Integer> typeHandler;
                if (this._sqlType == 4) {
                    typeHandler = new KeyGeneratorTypeHandlerInteger(false);
                    handler = new HighLowValueHandler<Integer>(intTableName, this._grabSize, typeHandler);
                } else if (this._sqlType == -5) {
                    typeHandler = new KeyGeneratorTypeHandlerLong(false);
                    handler = new HighLowValueHandler<Integer>(intTableName, this._grabSize, typeHandler);
                } else {
                    typeHandler = new KeyGeneratorTypeHandlerBigDecimal(false);
                    handler = new HighLowValueHandler<Integer>(intTableName, this._grabSize, typeHandler);
                }
                this._handlers.put(intTableName, handler);
            }
            if (!handler.hasNext()) {
                QueryExpression query = this._factory.getQueryExpression();
                query.addColumn(this._seqTable, this._seqValue);
                query.addCondition(this._seqTable, this._seqKey, "=", "?");
                String lockSQL = query.getStatement(true);
                String updateSQL = "UPDATE " + this._seqTable + " SET " + this._seqValue + "=" + "?" + " WHERE " + this._seqKey + "=" + "?" + " AND " + this._seqValue + "=" + "?";
                String maxSQL = "SELECT MAX(" + primKeyName + ") " + "FROM " + intTableName;
                String insertSQL = "INSERT INTO " + this._seqTable + " (" + this._seqKey + "," + this._seqValue + ") VALUES (?, ?)";
                Statement stmt = null;
                if (!this._sameConnection) {
                    conn.rollback();
                }
                boolean success = false;
                for (int i = 0; !success && i < 7; ++i) {
                    stmt = conn.prepareStatement(lockSQL);
                    handler.bindTable((PreparedStatement)stmt, 1);
                    ResultSet rs = stmt.executeQuery();
                    handler.init(rs);
                    boolean found = rs.isFirst();
                    stmt.close();
                    if (found) {
                        stmt = conn.prepareStatement(updateSQL);
                        handler.bindMax((PreparedStatement)stmt, 1);
                        handler.bindTable((PreparedStatement)stmt, 2);
                        handler.bindLast((PreparedStatement)stmt, 3);
                        success = stmt.executeUpdate() == 1;
                        stmt.close();
                        continue;
                    }
                    if (!this._global) {
                        stmt = conn.prepareStatement(maxSQL);
                        rs = stmt.executeQuery();
                        handler.init(rs);
                        stmt.close();
                    }
                    stmt = conn.prepareStatement(insertSQL);
                    handler.bindTable((PreparedStatement)stmt, 1);
                    handler.bindMax((PreparedStatement)stmt, 2);
                    success = stmt.executeUpdate() == 1;
                    stmt.close();
                }
                if (success) {
                    if (!this._sameConnection) {
                        conn.commit();
                    }
                } else {
                    if (!this._sameConnection) {
                        conn.rollback();
                    }
                    throw new PersistenceException(Messages.format((String)"persist.keyGenFailed", (Object)this.getClass().getName()));
                }
                Object var17_18 = null;
                try {
                    if (stmt != null) {
                        stmt.close();
                    }
                    break block27;
                }
                catch (SQLException ex) {
                    LOG.warn((Object)Messages.message((String)"persist.stClosingFailed"), (Throwable)ex);
                }
                break block27;
                {
                    catch (SQLException ex) {
                        try {
                            if (!this._sameConnection) {
                                conn.rollback();
                            }
                        }
                        catch (SQLException ex2) {
                            LOG.warn((Object)"Problem rolling back JDBC transaction.", (Throwable)ex2);
                        }
                        throw new PersistenceException(Messages.format((String)"persist.keyGenSQL", (Object)this.getClass().getName(), (Object)ex.toString()), ex);
                    }
                }
                catch (Throwable throwable) {
                    Object var17_19 = null;
                    try {
                        if (stmt != null) {
                            stmt.close();
                        }
                    }
                    catch (SQLException ex) {
                        LOG.warn((Object)Messages.message((String)"persist.stClosingFailed"), (Throwable)ex);
                    }
                    throw throwable;
                }
            }
        }
        return handler.next();
    }

    public boolean isInSameConnection() {
        return this._sameConnection;
    }
}

