/*
 * Decompiled with CFR 0.152.
 */
package org.castor.cpa.persistence.sql.keygen;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.castor.core.util.Messages;
import org.castor.cpa.jpa.info.JPATableGeneratorDescriptor;
import org.castor.cpa.persistence.sql.keygen.AbstractBeforeKeyGenerator;
import org.castor.cpa.persistence.sql.keygen.typehandler.KeyGeneratorTypeHandler;
import org.castor.cpa.persistence.sql.keygen.typehandler.KeyGeneratorTypeHandlerFactory;
import org.exolab.castor.jdo.PersistenceException;
import org.exolab.castor.mapping.MappingException;
import org.exolab.castor.persist.spi.PersistenceFactory;

public class TableKeyGenerator
extends AbstractBeforeKeyGenerator {
    private static final Log LOG = LogFactory.getLog(TableKeyGenerator.class);
    public static final String DESCRIPTOR_KEY = "descriptor";
    public static final String DEFAULT_TABLE_NAME = "GENERATOR_TABLE";
    public static final int DEFAULT_ALLOCATION_SIZE = 50;
    public static final int DEFAULT_INITIAL_VALUE = 0;
    public static final String DEFAULT_PK_COLUMN_NAME = "ID_NAME";
    public static final String DEFAULT_VALUE_COLUMN_NAME = "ID_VALUE";
    public static final String DEFAULT_PK_COLUMN_VALUE = "ID_GEN";
    private PersistenceFactory factory;
    private JPATableGeneratorDescriptor descriptor;
    private int sqlType;

    public TableKeyGenerator(PersistenceFactory factory, Properties params, int sqlType) throws MappingException {
        super(factory);
        this.factory = factory;
        this.sqlType = sqlType;
        this.descriptor = (JPATableGeneratorDescriptor)params.get(DESCRIPTOR_KEY);
        this.initializeDescriptor();
        this.assertNumericSqlType(sqlType);
    }

    private void assertNumericSqlType(int sqlType) throws MappingException {
        switch (sqlType) {
            case -5: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                break;
            }
            default: {
                String msg = Messages.format((String)"mapping.keyGenSQLType", (Object)this.getClass().getName(), (Object)sqlType);
                throw new MappingException(msg);
            }
        }
    }

    private void initializeDescriptor() {
        if (this.descriptor == null) {
            this.descriptor = new JPATableGeneratorDescriptor();
        }
        if (this.descriptor.getTable() == null || "".equals(this.descriptor.getTable())) {
            this.descriptor.setTable(DEFAULT_TABLE_NAME);
        }
        if (this.descriptor.getAllocationSize() < 1) {
            this.descriptor.setAllocationSize(50);
        }
        if (this.descriptor.getInitialValue() < 0) {
            this.descriptor.setInitialValue(0);
        }
        if (this.descriptor.getPkColumnName() == null || "".equals(this.descriptor.getPkColumnName())) {
            this.descriptor.setPkColumnName(DEFAULT_PK_COLUMN_NAME);
        }
        if (this.descriptor.getValueColumnName() == null || "".equals(this.descriptor.getValueColumnName())) {
            this.descriptor.setValueColumnName(DEFAULT_VALUE_COLUMN_NAME);
        }
        if (this.descriptor.getPkColumnValue() == null || "".equals(this.descriptor.getPkColumnValue())) {
            this.descriptor.setPkColumnValue(DEFAULT_PK_COLUMN_VALUE);
        }
    }

    public Object generateKey(Connection connection, String tableName, String primKeyName) throws PersistenceException {
        Object key;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Generating table-based primary key " + primKeyName + " for table " + tableName));
        }
        String sql = "SELECT " + this.descriptor.getValueColumnName() + " FROM " + this.descriptor.getTable() + " WHERE " + this.descriptor.getPkColumnName() + "='" + this.descriptor.getPkColumnValue() + "'";
        try {
            PreparedStatement statement = connection.prepareStatement(sql);
            ResultSet result = statement.executeQuery();
            KeyGeneratorTypeHandler<?> handler = KeyGeneratorTypeHandlerFactory.getTypeHandler(this.sqlType, this.descriptor.getAllocationSize());
            key = handler.getNextValue(result);
            sql = "UPDATE " + this.descriptor.getTable() + " SET " + this.descriptor.getValueColumnName() + "=" + key + " WHERE " + this.descriptor.getPkColumnName() + "='" + this.descriptor.getPkColumnValue() + "'";
            statement = connection.prepareStatement(sql);
            statement.executeUpdate();
        }
        catch (SQLException e) {
            throw new PersistenceException(e.getMessage());
        }
        catch (MappingException e) {
            throw new PersistenceException(e.getMessage());
        }
        return key;
    }

    public boolean isInSameConnection() {
        return true;
    }

    public PersistenceFactory getFactory() {
        return this.factory;
    }

    public JPATableGeneratorDescriptor getDescriptor() {
        return this.descriptor;
    }
}

