/*
 * Decompiled with CFR 0.152.
 */
package org.castor.cpa.persistence.sql.keygen.typehandler;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.castor.core.util.Messages;
import org.castor.cpa.persistence.sql.keygen.typehandler.KeyGeneratorTypeHandler;
import org.exolab.castor.jdo.PersistenceException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class KeyGeneratorTypeHandlerInteger
implements KeyGeneratorTypeHandler<Integer> {
    private static final Integer ZERO = new Integer(0);
    private final boolean _fail;
    private int allocationSize;

    public KeyGeneratorTypeHandlerInteger(boolean fail) {
        this._fail = fail;
        this.allocationSize = 1;
    }

    public KeyGeneratorTypeHandlerInteger(boolean fail, int allocationSize) {
        this(fail);
        this.allocationSize = allocationSize;
    }

    @Override
    public Integer getNextValue(ResultSet rs) throws PersistenceException, SQLException {
        return this.increment(this.getValue(rs));
    }

    @Override
    public Integer getValue(ResultSet rs) throws PersistenceException, SQLException {
        if (rs.next()) {
            return new Integer(rs.getInt(1));
        }
        if (!this._fail) {
            return ZERO;
        }
        String msg = Messages.format((String)"persist.keyGenFailed", (Object)"");
        throw new PersistenceException(msg);
    }

    @Override
    public Integer increment(Integer value) {
        return new Integer(value + this.allocationSize);
    }

    @Override
    public Integer add(Integer value, int offset) {
        return new Integer(value + offset);
    }

    @Override
    public void bindValue(PreparedStatement stmt, int index, Integer value) throws SQLException {
        stmt.setInt(index, value);
    }
}

