/*
 * Decompiled with CFR 0.152.
 */
package org.castor.cpa.persistence.sql.keygen.typehandler;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.castor.core.util.Messages;
import org.castor.cpa.persistence.sql.keygen.typehandler.KeyGeneratorTypeHandler;
import org.exolab.castor.jdo.PersistenceException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class KeyGeneratorTypeHandlerLong
implements KeyGeneratorTypeHandler<Long> {
    private static final Long ZERO = new Long(0L);
    private final boolean _fail;
    private Long allocationSize;

    public KeyGeneratorTypeHandlerLong(boolean fail) {
        this._fail = fail;
        this.allocationSize = 1L;
    }

    public KeyGeneratorTypeHandlerLong(boolean fail, int allocationSize) {
        this(fail);
        this.allocationSize = new Long(allocationSize);
    }

    @Override
    public Long getNextValue(ResultSet rs) throws PersistenceException, SQLException {
        return this.increment(this.getValue(rs));
    }

    @Override
    public Long getValue(ResultSet rs) throws PersistenceException, SQLException {
        if (rs.next()) {
            return new Long(rs.getLong(1));
        }
        if (!this._fail) {
            return ZERO;
        }
        String msg = Messages.format((String)"persist.keyGenFailed", (Object)"");
        throw new PersistenceException(msg);
    }

    @Override
    public Long increment(Long value) {
        return new Long(value + this.allocationSize);
    }

    @Override
    public Long add(Long value, int offset) {
        return new Long(value + (long)offset);
    }

    @Override
    public void bindValue(PreparedStatement stmt, int index, Long value) throws SQLException {
        stmt.setLong(index, value);
    }
}

