/*
 * Decompiled with CFR 0.152.
 */
package org.castor.cpa.persistence.sql.query;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.castor.cpa.persistence.sql.query.Assignment;
import org.castor.cpa.persistence.sql.query.Qualifier;
import org.castor.cpa.persistence.sql.query.QueryObject;
import org.castor.cpa.persistence.sql.query.Table;
import org.castor.cpa.persistence.sql.query.Visitor;
import org.castor.cpa.persistence.sql.query.expression.Column;
import org.castor.cpa.persistence.sql.query.expression.Expression;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Insert
implements QueryObject {
    private final Qualifier _qualifier;
    private final List<Assignment> _assignment = new ArrayList<Assignment>();

    public Insert(String name) {
        this._qualifier = new Table(name);
    }

    public Qualifier getQualifier() {
        return this._qualifier;
    }

    public List<Assignment> getAssignment() {
        return this._assignment;
    }

    public void addAssignment(Assignment assignment) {
        this._assignment.add(assignment);
    }

    public void addAssignment(Column column, Expression value) {
        this.addAssignment(new Assignment(column, value));
    }

    @Override
    public void accept(Visitor visitor) {
        visitor.visit(this);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("INSERT");
        sb.append(' ');
        sb.append("INTO");
        sb.append(' ');
        sb.append(this._qualifier.toString());
        sb.append(' ');
        sb.append('(');
        Iterator<Assignment> iter = this._assignment.iterator();
        while (iter.hasNext()) {
            sb.append(iter.next().leftExpression().toString());
            if (!iter.hasNext()) continue;
            sb.append(',');
            sb.append(' ');
        }
        sb.append(')');
        sb.append(' ');
        sb.append("VALUES");
        sb.append(' ');
        sb.append('(');
        iter = this._assignment.iterator();
        while (iter.hasNext()) {
            sb.append(iter.next().rightExpression().toString());
            if (!iter.hasNext()) continue;
            sb.append(',');
            sb.append(' ');
        }
        sb.append(')');
        return sb.toString();
    }
}

