/*
 * Decompiled with CFR 0.152.
 */
package org.castor.cpa.persistence.sql.query;

import org.castor.cpa.persistence.sql.query.JoinOperator;
import org.castor.cpa.persistence.sql.query.Qualifier;
import org.castor.cpa.persistence.sql.query.QueryObject;
import org.castor.cpa.persistence.sql.query.TableAlias;
import org.castor.cpa.persistence.sql.query.Visitor;
import org.castor.cpa.persistence.sql.query.condition.Condition;

public final class Join
implements QueryObject {
    private final JoinOperator _operator;
    private final Qualifier _join;
    private final Condition _condition;

    public Join(JoinOperator oper, Qualifier join) {
        this(oper, join, null);
    }

    public Join(JoinOperator oper, Qualifier join, Condition cond) {
        this._operator = oper;
        this._join = join;
        this._condition = cond;
    }

    public JoinOperator getOperator() {
        return this._operator;
    }

    public Qualifier getJoin() {
        return this._join;
    }

    public Condition getCondition() {
        return this._condition;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(this._operator.toString());
        sb.append(' ');
        sb.append("JOIN");
        sb.append(' ');
        if (!this._join.hasJoin()) {
            if (this._join instanceof TableAlias) {
                sb.append(((TableAlias)this._join).getTable().toString());
                sb.append(' ');
            }
            sb.append(this._join.toString());
        } else {
            int i;
            for (i = 0; i < this._join.getJoins().size(); ++i) {
                sb.append('(');
            }
            for (i = 0; i < this._join.getJoins().size(); ++i) {
                Join join = this._join.getJoins().get(i);
                if (i == 0) {
                    if (this._join instanceof TableAlias) {
                        sb.append(((TableAlias)this._join).getTable().toString());
                        sb.append(' ');
                    }
                    sb.append(this._join.toString());
                }
                sb.append(' ');
                sb.append(join.toString());
                sb.append(')');
            }
        }
        if (this._condition != null) {
            sb.append(' ');
            sb.append("ON");
            sb.append(' ');
            sb.append(this._condition.toString());
        }
        return sb.toString();
    }

    public void accept(Visitor visitor) {
        visitor.visit(this);
    }
}

