/*
 * Decompiled with CFR 0.152.
 */
package org.castor.cpa.persistence.sql.query;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.castor.cpa.persistence.sql.query.Join;
import org.castor.cpa.persistence.sql.query.Qualifier;
import org.castor.cpa.persistence.sql.query.QueryObject;
import org.castor.cpa.persistence.sql.query.Table;
import org.castor.cpa.persistence.sql.query.TableAlias;
import org.castor.cpa.persistence.sql.query.Visitor;
import org.castor.cpa.persistence.sql.query.condition.Condition;
import org.castor.cpa.persistence.sql.query.expression.Column;
import org.castor.cpa.persistence.sql.query.expression.Expression;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Select
implements QueryObject {
    private final List<Expression> _select = new ArrayList<Expression>();
    private final List<Qualifier> _from = new ArrayList<Qualifier>();
    private Condition _condition;
    private boolean _locked = false;

    public Select(String name) {
        this(new Table(name));
    }

    public Select(Qualifier qualifier) {
        if (qualifier == null) {
            throw new NullPointerException();
        }
        this._from.add(qualifier);
    }

    public void addSelect(Column name) {
        this._select.add(name);
    }

    public void addFrom(Qualifier qualifier) {
        this._from.add(qualifier);
    }

    public List<Expression> getSelect() {
        return this._select;
    }

    public List<Qualifier> getFrom() {
        return this._from;
    }

    public Condition getCondition() {
        return this._condition;
    }

    public void setCondition(Condition condition) {
        this._condition = condition;
    }

    public boolean isLocked() {
        return this._locked;
    }

    public void setLocked(boolean locked) {
        this._locked = locked;
    }

    public boolean hasFrom() {
        return !this._from.isEmpty();
    }

    public String toString() {
        Iterator<QueryObject> iter;
        StringBuffer sb = new StringBuffer();
        sb.append("SELECT");
        sb.append(' ');
        if (this._select.isEmpty()) {
            sb.append('*');
        } else {
            iter = this._select.iterator();
            while (iter.hasNext()) {
                sb.append(iter.next().toString());
                if (!iter.hasNext()) continue;
                sb.append(',');
                sb.append(' ');
            }
        }
        sb.append(' ');
        sb.append("FROM");
        sb.append(' ');
        iter = this._from.iterator();
        while (iter.hasNext()) {
            Qualifier qualifier = (Qualifier)iter.next();
            if (!qualifier.hasJoin()) {
                if (qualifier instanceof TableAlias) {
                    sb.append(((TableAlias)qualifier).getTable().toString());
                    sb.append(' ');
                }
                sb.append(qualifier.toString());
            } else {
                int i;
                for (i = 0; i < qualifier.getJoins().size(); ++i) {
                    sb.append('(');
                }
                for (i = 0; i < qualifier.getJoins().size(); ++i) {
                    Join join = qualifier.getJoins().get(i);
                    if (i == 0) {
                        if (qualifier instanceof TableAlias) {
                            sb.append(((TableAlias)qualifier).getTable().toString());
                            sb.append(' ');
                        }
                        sb.append(qualifier.toString());
                    }
                    sb.append(' ');
                    sb.append(join.toString());
                    sb.append(')');
                }
            }
            if (!iter.hasNext()) continue;
            sb.append(',');
            sb.append(' ');
        }
        if (this._condition != null) {
            sb.append(' ');
            sb.append("WHERE");
            sb.append(' ');
            sb.append(this._condition.toString());
        }
        return sb.toString();
    }

    @Override
    public void accept(Visitor visitor) {
        visitor.visit(this);
    }
}

