/*
 * Decompiled with CFR 0.152.
 */
package org.castor.cpa.persistence.sql.query.condition;

import java.util.Iterator;
import org.castor.cpa.persistence.sql.query.Visitor;
import org.castor.cpa.persistence.sql.query.condition.CompoundCondition;
import org.castor.cpa.persistence.sql.query.condition.Condition;
import org.castor.cpa.persistence.sql.query.condition.OrCondition;

public final class AndCondition
extends CompoundCondition {
    public AndCondition() {
    }

    public AndCondition(Condition condition1, Condition condition2) {
        this();
        this.append(condition1);
        this.append(condition2);
    }

    public AndCondition(AndCondition condition) {
        super(condition);
    }

    protected void append(Condition condition) {
        if (condition instanceof AndCondition) {
            AndCondition and = (AndCondition)condition;
            Iterator<Condition> iter = and.iterator();
            while (iter.hasNext()) {
                super.append(iter.next());
            }
        } else {
            super.append(condition);
        }
    }

    public Condition and(Condition condition) {
        this.append(condition);
        return this;
    }

    public Condition not() {
        OrCondition condition = new OrCondition();
        Iterator<Condition> iter = this.iterator();
        while (iter.hasNext()) {
            ((Condition)condition).or(iter.next().not());
        }
        return condition;
    }

    public void accept(Visitor visitor) {
        visitor.visit(this);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        Iterator<Condition> iter = this.iterator();
        while (iter.hasNext()) {
            Condition condition = iter.next();
            if (condition instanceof CompoundCondition) {
                sb.append('(');
                sb.append(condition.toString());
                sb.append(')');
            } else {
                sb.append(condition.toString());
            }
            if (!iter.hasNext()) continue;
            sb.append(' ');
            sb.append("AND");
            sb.append(' ');
        }
        return sb.toString();
    }
}

