/*
 * Decompiled with CFR 0.152.
 */
package org.castor.cpa.query.object;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.castor.cpa.query.Field;
import org.castor.cpa.query.Order;
import org.castor.cpa.query.OrderDirection;
import org.castor.cpa.query.object.AbstractQueryObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class OrderImpl
extends AbstractQueryObject
implements Order {
    private final List<Item> _items = new ArrayList<Item>();

    @Override
    public void add(Field field) {
        if (field == null) {
            throw new NullPointerException();
        }
        this._items.add(new Item(field));
    }

    @Override
    public void add(Field field, OrderDirection direction) {
        if (field == null) {
            throw new NullPointerException();
        }
        if (direction == null) {
            throw new NullPointerException();
        }
        this._items.add(new Item(field, direction));
    }

    public List<Item> getItems() {
        return this._items;
    }

    @Override
    public StringBuilder toString(StringBuilder sb) {
        Iterator<Item> iter = this._items.iterator();
        while (iter.hasNext()) {
            Item item = iter.next();
            if (item.getField() != null) {
                item.getField().toString(sb);
            }
            if (item.getDirection() == OrderDirection.ASCENDING) {
                sb.append(" ASC");
            } else {
                sb.append(" DESC");
            }
            if (!iter.hasNext()) continue;
            sb.append(", ");
        }
        return sb;
    }

    public static final class Item {
        private Field _field;
        private OrderDirection _direction;

        public Item(Field field) {
            this(field, OrderDirection.ASCENDING);
        }

        public Item(Field field, OrderDirection direction) {
            this._field = field;
            this._direction = direction;
        }

        public Field getField() {
            return this._field;
        }

        public OrderDirection getDirection() {
            return this._direction;
        }
    }
}

