/*
 * Decompiled with CFR 0.152.
 */
package org.castor.cpa.query.object.literal;

import java.util.Calendar;
import java.util.Date;
import org.castor.cpa.query.TemporalType;
import org.castor.cpa.query.object.literal.AbstractLiteral;
import org.castor.cpa.query.object.literal.DateLiteral;
import org.castor.cpa.query.object.literal.TimeLiteral;
import org.castor.cpa.query.object.literal.TimestampLiteral;

public abstract class AbstractTemporalLiteral
extends AbstractLiteral {
    private final Date _value;

    public static AbstractTemporalLiteral createInstance(TemporalType temporalType, Date value) {
        switch (temporalType) {
            case DATE: {
                return new DateLiteral(value);
            }
            case TIME: {
                return new TimeLiteral(value);
            }
            case TIMESTAMP: {
                return new TimestampLiteral(value);
            }
        }
        throw new IllegalArgumentException();
    }

    public static AbstractTemporalLiteral createInstance(TemporalType temporalType, Calendar value) {
        switch (temporalType) {
            case DATE: {
                return new DateLiteral(value);
            }
            case TIME: {
                return new TimeLiteral(value);
            }
            case TIMESTAMP: {
                return new TimestampLiteral(value);
            }
        }
        throw new IllegalArgumentException();
    }

    protected AbstractTemporalLiteral(Date value) {
        if (value == null) {
            throw new NullPointerException();
        }
        this._value = value;
    }

    protected AbstractTemporalLiteral(Calendar value) {
        if (value == null) {
            throw new NullPointerException();
        }
        this._value = value.getTime();
    }

    public final Date getValue() {
        return this._value;
    }
}

