/*
 * Decompiled with CFR 0.152.
 */
package org.castor.cpa.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.castor.cpa.util.JDOClassDescriptorResolver;
import org.castor.cpa.util.classresolution.command.ClassDescriptorResolutionCommand;
import org.castor.cpa.util.classresolution.command.ClassResolutionByAnnotations;
import org.castor.cpa.util.classresolution.command.ClassResolutionByCDR;
import org.castor.cpa.util.classresolution.command.ClassResolutionByFile;
import org.castor.cpa.util.classresolution.command.ClassResolutionByMappingLoader;
import org.castor.cpa.util.classresolution.nature.ClassLoaderNature;
import org.castor.cpa.util.classresolution.nature.MappingLoaderNature;
import org.castor.cpa.util.classresolution.nature.PackageBasedCDRResolutionNature;
import org.exolab.castor.mapping.ClassDescriptor;
import org.exolab.castor.mapping.MappingLoader;
import org.exolab.castor.xml.ResolverException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JDOClassDescriptorResolverImpl
implements JDOClassDescriptorResolver {
    private Map<Class<?>, ClassDescriptor> _classDescriptorCache = new ConcurrentHashMap();
    private MappingLoader _mappingLoader;
    protected List<Class<?>> _classes = new LinkedList();
    protected List<String> _packages = new LinkedList<String>();
    private Map<String, ClassDescriptorResolutionCommand> _commands = new HashMap<String, ClassDescriptorResolutionCommand>();

    public JDOClassDescriptorResolverImpl() {
        this.registerCommand(new ClassResolutionByMappingLoader());
        this.registerCommand(new ClassResolutionByFile());
        this.registerCommand(new ClassResolutionByCDR());
        this.registerCommand(new ClassResolutionByAnnotations());
    }

    private void registerCommand(ClassDescriptorResolutionCommand command) {
        command.setClassDescriptorResolver(this);
        this._commands.put(command.getClass().getName(), command);
    }

    @Override
    public ClassDescriptor resolve(String type) throws ResolverException {
        try {
            if (this.getMappingLoader().getClassLoader() != null) {
                return this.resolve(this.getMappingLoader().getClassLoader().loadClass(type));
            }
            return this.resolve(Class.forName(type));
        }
        catch (ClassNotFoundException e) {
            throw new ResolverException("Problem loading class " + type);
        }
    }

    public ClassDescriptor resolve(Class<?> type) throws ResolverException {
        if (type == null) {
            return null;
        }
        ClassDescriptor classDesc = null;
        classDesc = this.resolveByCache(type);
        if (classDesc != null) {
            return classDesc;
        }
        classDesc = this.lookup(ClassResolutionByAnnotations.class.getName()).resolve(type);
        if (classDesc != null) {
            this.registerDescriptor(type, classDesc);
            return classDesc;
        }
        classDesc = this.lookup(ClassResolutionByMappingLoader.class.getName()).resolve(type);
        if (classDesc != null) {
            this.registerDescriptor(type, classDesc);
            return classDesc;
        }
        classDesc = this.lookup(ClassResolutionByFile.class.getName()).resolve(type);
        if (classDesc != null) {
            this.registerDescriptor(type, classDesc);
            return classDesc;
        }
        classDesc = this.lookup(ClassResolutionByCDR.class.getName()).resolve(type);
        if (classDesc != null) {
            this.registerDescriptor(type, classDesc);
            return classDesc;
        }
        return classDesc;
    }

    private ClassDescriptorResolutionCommand lookup(String commandName) {
        return this._commands.get(commandName);
    }

    private ClassDescriptor resolveByCache(Class<?> type) {
        return this._classDescriptorCache.get(type);
    }

    @Override
    public void registerDescriptor(Class<?> type, ClassDescriptor classDescriptor) {
        this._classDescriptorCache.put(type, classDescriptor);
    }

    public MappingLoader getMappingLoader() {
        return this._mappingLoader;
    }

    public void setMappingLoader(MappingLoader mappingLoader) {
        this._mappingLoader = mappingLoader;
        for (ClassDescriptorResolutionCommand command : this._commands.values()) {
            if (command.hasNature(MappingLoaderNature.class.getName())) {
                new MappingLoaderNature(command).setMappingLoader(mappingLoader);
            }
            if (!command.hasNature(ClassLoaderNature.class.getName())) continue;
            new ClassLoaderNature(command).setClassLoader(this._mappingLoader.getClassLoader());
        }
    }

    @Override
    public void addClass(Class<?> domainClass) {
        this._classes.add(domainClass);
    }

    @Override
    public void addPackage(String packageName) {
        this._packages.add(packageName);
        for (ClassDescriptorResolutionCommand command : this._commands.values()) {
            if (!command.hasNature(PackageBasedCDRResolutionNature.class.getName())) continue;
            new PackageBasedCDRResolutionNature(command).addPackageName(packageName);
        }
    }

    @Override
    public Iterator<ClassDescriptor> descriptorIterator() {
        ArrayList<ClassDescriptor> allDescriptors = new ArrayList<ClassDescriptor>();
        allDescriptors.addAll(this._mappingLoader.getDescriptors());
        for (Class<?> aClass : this._classes) {
            ClassDescriptor resolve = this.lookup(ClassResolutionByFile.class.getName()).resolve(aClass);
            if (resolve != null) {
                allDescriptors.add(resolve);
                continue;
            }
            resolve = this.lookup(ClassResolutionByAnnotations.class.getName()).resolve(aClass);
            if (resolve == null) continue;
            allDescriptors.add(resolve);
        }
        ClassResolutionByCDR cdrNature = (ClassResolutionByCDR)this.lookup(ClassResolutionByCDR.class.getName());
        for (String packageName : this._packages) {
            Map<String, ClassDescriptor> descriptors = cdrNature.getDescriptors(packageName);
            for (Map.Entry<String, ClassDescriptor> entry : descriptors.entrySet()) {
                allDescriptors.add(entry.getValue());
            }
        }
        return allDescriptors.iterator();
    }

    @Override
    public ClassLoader getClassLoader() {
        return this._mappingLoader.getClassLoader();
    }
}

