/*
 * Decompiled with CFR 0.152.
 */
package org.castor.jdo.conf;

import java.io.IOException;
import java.io.Reader;
import java.io.Serializable;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import org.castor.jdo.conf.ClassMapping;
import org.castor.jdo.conf.DatabaseChoice;
import org.castor.jdo.conf.Mapping;
import org.castor.jdo.conf.PackageMapping;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.Marshaller;
import org.exolab.castor.xml.Unmarshaller;
import org.exolab.castor.xml.ValidationException;
import org.exolab.castor.xml.Validator;
import org.xml.sax.ContentHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Database
implements Serializable {
    private String _name;
    private String _engine = "generic";
    private DatabaseChoice _databaseChoice;
    private List<Mapping> _mappingList;
    private List<PackageMapping> _packageMappingList;
    private List<ClassMapping> _classMappingList;

    public Database() {
        this.setEngine("generic");
        this._mappingList = new ArrayList<Mapping>();
        this._packageMappingList = new ArrayList<PackageMapping>();
        this._classMappingList = new ArrayList<ClassMapping>();
    }

    public void addClassMapping(ClassMapping vClassMapping) throws IndexOutOfBoundsException {
        this._classMappingList.add(vClassMapping);
    }

    public void addClassMapping(int index, ClassMapping vClassMapping) throws IndexOutOfBoundsException {
        this._classMappingList.add(index, vClassMapping);
    }

    public void addMapping(Mapping vMapping) throws IndexOutOfBoundsException {
        this._mappingList.add(vMapping);
    }

    public void addMapping(int index, Mapping vMapping) throws IndexOutOfBoundsException {
        this._mappingList.add(index, vMapping);
    }

    public void addPackageMapping(PackageMapping vPackageMapping) throws IndexOutOfBoundsException {
        this._packageMappingList.add(vPackageMapping);
    }

    public void addPackageMapping(int index, PackageMapping vPackageMapping) throws IndexOutOfBoundsException {
        this._packageMappingList.add(index, vPackageMapping);
    }

    public Enumeration<? extends ClassMapping> enumerateClassMapping() {
        return Collections.enumeration(this._classMappingList);
    }

    public Enumeration<? extends Mapping> enumerateMapping() {
        return Collections.enumeration(this._mappingList);
    }

    public Enumeration<? extends PackageMapping> enumeratePackageMapping() {
        return Collections.enumeration(this._packageMappingList);
    }

    public ClassMapping getClassMapping(int index) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this._classMappingList.size()) {
            throw new IndexOutOfBoundsException("getClassMapping: Index value '" + index + "' not in range [0.." + (this._classMappingList.size() - 1) + "]");
        }
        return this._classMappingList.get(index);
    }

    public ClassMapping[] getClassMapping() {
        ClassMapping[] array = new ClassMapping[]{};
        return this._classMappingList.toArray(array);
    }

    public int getClassMappingCount() {
        return this._classMappingList.size();
    }

    public DatabaseChoice getDatabaseChoice() {
        return this._databaseChoice;
    }

    public String getEngine() {
        return this._engine;
    }

    public Mapping getMapping(int index) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this._mappingList.size()) {
            throw new IndexOutOfBoundsException("getMapping: Index value '" + index + "' not in range [0.." + (this._mappingList.size() - 1) + "]");
        }
        return this._mappingList.get(index);
    }

    public Mapping[] getMapping() {
        Mapping[] array = new Mapping[]{};
        return this._mappingList.toArray(array);
    }

    public int getMappingCount() {
        return this._mappingList.size();
    }

    public String getName() {
        return this._name;
    }

    public PackageMapping getPackageMapping(int index) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this._packageMappingList.size()) {
            throw new IndexOutOfBoundsException("getPackageMapping: Index value '" + index + "' not in range [0.." + (this._packageMappingList.size() - 1) + "]");
        }
        return this._packageMappingList.get(index);
    }

    public PackageMapping[] getPackageMapping() {
        PackageMapping[] array = new PackageMapping[]{};
        return this._packageMappingList.toArray(array);
    }

    public int getPackageMappingCount() {
        return this._packageMappingList.size();
    }

    public boolean isValid() {
        try {
            this.validate();
        }
        catch (ValidationException vex) {
            return false;
        }
        return true;
    }

    public Iterator<? extends ClassMapping> iterateClassMapping() {
        return this._classMappingList.iterator();
    }

    public Iterator<? extends Mapping> iterateMapping() {
        return this._mappingList.iterator();
    }

    public Iterator<? extends PackageMapping> iteratePackageMapping() {
        return this._packageMappingList.iterator();
    }

    public void marshal(Writer out) throws MarshalException, ValidationException {
        Marshaller.marshal((Object)this, (Writer)out);
    }

    public void marshal(ContentHandler handler) throws IOException, MarshalException, ValidationException {
        Marshaller.marshal((Object)this, (ContentHandler)handler);
    }

    public void removeAllClassMapping() {
        this._classMappingList.clear();
    }

    public void removeAllMapping() {
        this._mappingList.clear();
    }

    public void removeAllPackageMapping() {
        this._packageMappingList.clear();
    }

    public boolean removeClassMapping(ClassMapping vClassMapping) {
        boolean removed = this._classMappingList.remove(vClassMapping);
        return removed;
    }

    public ClassMapping removeClassMappingAt(int index) {
        ClassMapping obj = this._classMappingList.remove(index);
        return obj;
    }

    public boolean removeMapping(Mapping vMapping) {
        boolean removed = this._mappingList.remove(vMapping);
        return removed;
    }

    public Mapping removeMappingAt(int index) {
        Mapping obj = this._mappingList.remove(index);
        return obj;
    }

    public boolean removePackageMapping(PackageMapping vPackageMapping) {
        boolean removed = this._packageMappingList.remove(vPackageMapping);
        return removed;
    }

    public PackageMapping removePackageMappingAt(int index) {
        PackageMapping obj = this._packageMappingList.remove(index);
        return obj;
    }

    public void setClassMapping(int index, ClassMapping vClassMapping) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this._classMappingList.size()) {
            throw new IndexOutOfBoundsException("setClassMapping: Index value '" + index + "' not in range [0.." + (this._classMappingList.size() - 1) + "]");
        }
        this._classMappingList.set(index, vClassMapping);
    }

    public void setClassMapping(ClassMapping[] vClassMappingArray) {
        this._classMappingList.clear();
        for (int i = 0; i < vClassMappingArray.length; ++i) {
            this._classMappingList.add(vClassMappingArray[i]);
        }
    }

    public void setDatabaseChoice(DatabaseChoice databaseChoice) {
        this._databaseChoice = databaseChoice;
    }

    public void setEngine(String engine) {
        this._engine = engine;
    }

    public void setMapping(int index, Mapping vMapping) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this._mappingList.size()) {
            throw new IndexOutOfBoundsException("setMapping: Index value '" + index + "' not in range [0.." + (this._mappingList.size() - 1) + "]");
        }
        this._mappingList.set(index, vMapping);
    }

    public void setMapping(Mapping[] vMappingArray) {
        this._mappingList.clear();
        for (int i = 0; i < vMappingArray.length; ++i) {
            this._mappingList.add(vMappingArray[i]);
        }
    }

    public void setName(String name) {
        this._name = name;
    }

    public void setPackageMapping(int index, PackageMapping vPackageMapping) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this._packageMappingList.size()) {
            throw new IndexOutOfBoundsException("setPackageMapping: Index value '" + index + "' not in range [0.." + (this._packageMappingList.size() - 1) + "]");
        }
        this._packageMappingList.set(index, vPackageMapping);
    }

    public void setPackageMapping(PackageMapping[] vPackageMappingArray) {
        this._packageMappingList.clear();
        for (int i = 0; i < vPackageMappingArray.length; ++i) {
            this._packageMappingList.add(vPackageMappingArray[i]);
        }
    }

    public static Database unmarshal(Reader reader) throws MarshalException, ValidationException {
        return (Database)Unmarshaller.unmarshal(Database.class, (Reader)reader);
    }

    public void validate() throws ValidationException {
        Validator validator = new Validator();
        validator.validate((Object)this);
    }
}

