/*
 * Decompiled with CFR 0.152.
 */
package org.castor.jdo.engine;

import java.util.Hashtable;
import javax.sql.DataSource;
import javax.transaction.TransactionManager;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.castor.core.util.AbstractProperties;
import org.castor.core.util.Messages;
import org.castor.cpa.CPAProperties;
import org.castor.cpa.persistence.sql.connection.ConnectionFactory;
import org.castor.cpa.persistence.sql.connection.DataSourceConnectionFactory;
import org.castor.cpa.persistence.sql.connection.DriverConnectionFactory;
import org.castor.cpa.persistence.sql.connection.JNDIConnectionFactory;
import org.castor.cpa.util.JDOClassDescriptorResolver;
import org.castor.jdo.conf.Database;
import org.castor.jdo.conf.DatabaseChoice;
import org.castor.jdo.conf.JdoConf;
import org.castor.jdo.engine.DatabaseContext;
import org.castor.jdo.util.JDOConfFactory;
import org.exolab.castor.mapping.Mapping;
import org.exolab.castor.mapping.MappingException;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;

public final class DatabaseRegistry {
    private static final Log LOG = LogFactory.getLog(DatabaseRegistry.class);
    private static final Hashtable CONTEXTS = new Hashtable();

    public static synchronized void loadDatabase(String name, String engine, DataSource datasource, Mapping mapping, TransactionManager txManager) throws MappingException {
        boolean useProxies = CPAProperties.getInstance().getBoolean("org.castor.cpa.persistence.sql.connection.proxies", true);
        DataSourceConnectionFactory cf = new DataSourceConnectionFactory(datasource, useProxies);
        DatabaseContext context = new DatabaseContext(name, engine, mapping, txManager, cf);
        if (CONTEXTS.put(name, context) != null) {
            LOG.warn((Object)Messages.format((String)"jdo.configLoadedTwice", (Object)name));
        }
    }

    public static synchronized void loadDatabase(InputSource source, EntityResolver resolver, ClassLoader loader) throws MappingException {
        DatabaseRegistry.loadDatabase(source, resolver, loader, null);
    }

    public static synchronized void loadDatabase(InputSource source, EntityResolver resolver, ClassLoader loader, JDOClassDescriptorResolver classDescriptorResolver) throws MappingException {
        JdoConf jdoConf = null;
        jdoConf = JDOConfFactory.createJdoConf(source, resolver, loader);
        LOG.debug((Object)"Loaded jdo conf successfully");
        DatabaseRegistry.loadDatabase(jdoConf, resolver, loader, source.getSystemId(), classDescriptorResolver);
    }

    public static synchronized void loadDatabase(JdoConf jdoConf, EntityResolver resolver, ClassLoader loader, String baseURI) throws MappingException {
        DatabaseRegistry.loadDatabase(jdoConf, resolver, loader, baseURI, null);
    }

    public static synchronized void loadDatabase(JdoConf jdoConf, EntityResolver resolver, ClassLoader loader, String baseURI, JDOClassDescriptorResolver classDescriptorResolver) throws MappingException {
        AbstractProperties properties = CPAProperties.getInstance();
        boolean init = properties.getBoolean("org.exolab.castor.jdo.DatabaseInitializeAtLoad", true);
        Database[] databases = jdoConf.getDatabase();
        for (int i = 0; i < databases.length; ++i) {
            String name;
            Mapping mapping = new Mapping(loader);
            if (resolver != null) {
                mapping.setEntityResolver(resolver);
            }
            if (baseURI != null) {
                mapping.setBaseURL(baseURI);
            }
            DatabaseContext context = DatabaseRegistry.createDatabaseContext(jdoConf, i, mapping);
            context.setClassDescriptorResolver(classDescriptorResolver);
            if (init) {
                context.initialize();
            }
            if (CONTEXTS.put(name = databases[i].getName(), context) == null) continue;
            LOG.warn((Object)Messages.format((String)"jdo.configLoadedTwice", (Object)name));
        }
    }

    private static DatabaseContext createDatabaseContext(JdoConf jdoConf, int index, Mapping mapping) throws MappingException {
        ConnectionFactory factory;
        boolean useProxies = CPAProperties.getInstance().getBoolean("org.castor.cpa.persistence.sql.connection.proxies", true);
        DatabaseChoice choice = jdoConf.getDatabase(index).getDatabaseChoice();
        if (choice == null) {
            String name = jdoConf.getDatabase(index).getName();
            String msg = Messages.format((String)"jdo.missingDataSource", (Object)name);
            LOG.error((Object)msg);
            throw new MappingException(msg);
        }
        if (choice.getDriver() != null) {
            factory = new DriverConnectionFactory(choice.getDriver(), useProxies);
        } else if (choice.getDataSource() != null) {
            ClassLoader loader = mapping.getClassLoader();
            factory = new DataSourceConnectionFactory(choice.getDataSource(), useProxies, loader);
        } else if (choice.getJndi() != null) {
            factory = new JNDIConnectionFactory(choice.getJndi(), useProxies);
        } else {
            String name = jdoConf.getDatabase(index).getName();
            String msg = Messages.format((String)"jdo.missingDataSource", (Object)name);
            LOG.error((Object)msg);
            throw new MappingException(msg);
        }
        return new DatabaseContext(jdoConf, index, mapping, factory);
    }

    public static boolean hasDatabaseRegistries() {
        return !CONTEXTS.isEmpty();
    }

    public static boolean isDatabaseRegistred(String name) {
        return CONTEXTS.containsKey(name);
    }

    public static DatabaseContext getDatabaseContext(String name) throws MappingException {
        DatabaseContext context;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Fetching ConnectionFactory: " + name));
        }
        if ((context = (DatabaseContext)CONTEXTS.get(name)) == null) {
            String msg = Messages.format((String)"jdo.missingDataSource", (Object)name);
            LOG.error((Object)msg);
            throw new MappingException(msg);
        }
        context.initialize();
        return context;
    }

    public static void clear() {
        CONTEXTS.clear();
    }

    public static void unloadDatabase(String name) {
        CONTEXTS.remove(name);
    }

    private DatabaseRegistry() {
    }
}

