/*
 * Decompiled with CFR 0.152.
 */
package org.castor.persist.resolver;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.castor.persist.ProposedEntity;
import org.castor.persist.TransactionContext;
import org.castor.persist.UpdateFlags;
import org.castor.persist.proxy.LazyCollection;
import org.castor.persist.resolver.ManyRelationResolver;
import org.exolab.castor.jdo.PersistenceException;
import org.exolab.castor.mapping.AccessMode;
import org.exolab.castor.persist.ClassMolder;
import org.exolab.castor.persist.ClassMolderHelper;
import org.exolab.castor.persist.FieldMolder;
import org.exolab.castor.persist.OID;
import org.exolab.castor.persist.spi.Identity;

public final class ManyToManyRelationResolver
extends ManyRelationResolver {
    public ManyToManyRelationResolver(ClassMolder classMolder, FieldMolder fieldMolder, int fieldIndex) {
        super(classMolder, fieldMolder, fieldIndex);
    }

    public boolean markCreate(TransactionContext tx, OID oid, Object object) throws PersistenceException {
        boolean updateCache = false;
        ClassMolder fieldClassMolder = this._fieldMolder.getFieldClassMolder();
        Object objects = this._fieldMolder.getValue(object, tx.getClassLoader());
        if (objects != null) {
            Iterator itor = ClassMolderHelper.getIterator(objects);
            while (itor.hasNext()) {
                Object objectToCreate = itor.next();
                if (!this.isCascadingCreate(tx) || tx.isRecorded(objectToCreate)) continue;
                tx.markCreate(fieldClassMolder, objectToCreate, null);
                updateCache = true;
            }
        }
        return updateCache;
    }

    public void markDelete(TransactionContext tx, Object object, Object field) throws PersistenceException {
        ClassMolder fieldClassMolder = this._fieldMolder.getFieldClassMolder();
        if (field != null) {
            ArrayList alist = (ArrayList)field;
            for (int j = 0; j < alist.size(); ++j) {
                Identity fid = (Identity)alist.get(j);
                Object fetched = null;
                if (fid == null || (fetched = tx.fetch(fieldClassMolder, fid, null)) == null) continue;
                fieldClassMolder.removeRelation(tx, fetched, this._classMolder, object);
            }
        }
        Iterator itor = ClassMolderHelper.getIterator(this._fieldMolder.getValue(object, tx.getClassLoader()));
        while (itor.hasNext()) {
            Object fobject = itor.next();
            if (fobject == null || !tx.isPersistent(fobject)) continue;
            fieldClassMolder.removeRelation(tx, fobject, this._classMolder, object);
        }
    }

    public UpdateFlags preStore(TransactionContext tx, OID oid, Object object, int timeout, Object field) throws PersistenceException {
        Iterator<Object> addedItor;
        Iterator<Identity> removedItor;
        ClassMolder fieldClassMolder = this._fieldMolder.getFieldClassMolder();
        Object value = this._fieldMolder.getValue(object, tx.getClassLoader());
        if (!(value instanceof LazyCollection)) {
            List orgFields = (List)field;
            List<Identity> removed = ClassMolderHelper.getRemovedIdsList(tx, orgFields, value, fieldClassMolder);
            removedItor = removed.iterator();
            Collection<Object> added = ClassMolderHelper.getAddedEntitiesList(tx, orgFields, value, fieldClassMolder);
            addedItor = added.iterator();
        } else {
            LazyCollection lazy = (LazyCollection)value;
            tx.addTxSynchronizable(lazy);
            removedItor = lazy.getRemovedIdsList().iterator();
            addedItor = lazy.getAddedEntitiesList().iterator();
        }
        UpdateFlags flags = new UpdateFlags();
        if (removedItor.hasNext()) {
            if (this._fieldMolder.isStored() && this._fieldMolder.isCheckDirty()) {
                flags.setUpdatePersist(true);
            }
            flags.setUpdateCache(true);
            while (removedItor.hasNext()) {
                ProposedEntity proposedValue;
                Object removedEntity;
                Identity removedId = removedItor.next();
                if (tx.isDeletedByOID(new OID(fieldClassMolder, removedId)) || (removedEntity = tx.load(removedId, proposedValue = new ProposedEntity(fieldClassMolder), null)) == null || !tx.isPersistent(removedEntity)) continue;
                tx.writeLock(removedEntity, 0);
                this._fieldMolder.getRelationLoader().deleteRelation(tx.getConnection(oid.getMolder().getLockEngine()), oid.getIdentity(), removedId);
                fieldClassMolder.removeRelation(tx, removedEntity, this._classMolder, object);
            }
        }
        if (addedItor.hasNext()) {
            if (this._fieldMolder.isStored() && this._fieldMolder.isCheckDirty()) {
                flags.setUpdatePersist(true);
            }
            flags.setUpdateCache(true);
            while (addedItor.hasNext()) {
                Object addedEntity = addedItor.next();
                tx.markModified(addedEntity, false, true);
                if (tx.isPersistent(addedEntity)) {
                    this._fieldMolder.getRelationLoader().createRelation(tx.getConnection(oid.getMolder().getLockEngine()), oid.getIdentity(), fieldClassMolder.getIdentity(tx, addedEntity));
                    continue;
                }
                if (!this.isCascadingCreate(tx) || tx.isRecorded(addedEntity)) continue;
                tx.markCreate(fieldClassMolder, addedEntity, null);
            }
        }
        return flags;
    }

    public void update(TransactionContext tx, OID oid, Object object, AccessMode suggestedAccessMode, Object field) throws PersistenceException {
        List values = (List)field;
        ClassMolder fieldClassMolder = this._fieldMolder.getFieldClassMolder();
        if (this.isCascadingUpdate(tx)) {
            ArrayList<Identity> newSetOfIds = new ArrayList<Identity>();
            Iterator itor = ClassMolderHelper.getIterator(this._fieldMolder.getValue(object, tx.getClassLoader()));
            while (itor.hasNext()) {
                Object element = itor.next();
                Identity actualIdentity = fieldClassMolder.getActualIdentity(tx, element);
                newSetOfIds.add(actualIdentity);
                if (tx.isRecorded(element)) continue;
                tx.markUpdate(fieldClassMolder, element, null);
            }
            if (values != null) {
                for (int j = 0; j < values.size(); ++j) {
                    if (newSetOfIds.contains(values.get(j))) continue;
                    ProposedEntity proposedValue = new ProposedEntity(fieldClassMolder);
                    tx.load((Identity)values.get(j), proposedValue, suggestedAccessMode);
                }
            }
        }
    }

    public Object postCreate(TransactionContext tx, OID oid, Object object, Object field, Identity createdId) throws PersistenceException {
        ClassMolder fieldClassMolder = this._fieldMolder.getFieldClassMolder();
        Object o = this._fieldMolder.getValue(object, tx.getClassLoader());
        List<Identity> result = field;
        if (o != null) {
            result = ClassMolderHelper.getIdsList(tx, fieldClassMolder, o);
            Iterator itor = ClassMolderHelper.getIterator(o);
            while (itor.hasNext()) {
                Object oo = itor.next();
                if (!tx.isPersistent(oo)) continue;
                this._fieldMolder.getRelationLoader().createRelation(tx.getConnection(oid.getMolder().getLockEngine()), createdId, fieldClassMolder.getIdentity(tx, oo));
            }
        }
        return result;
    }

    public boolean updateWhenNoTimestampSet(TransactionContext tx, OID oid, Object object, AccessMode suggestedAccessMode) throws PersistenceException {
        boolean updateCache = false;
        ClassMolder fieldClassMolder = this._fieldMolder.getFieldClassMolder();
        Object value = this._fieldMolder.getValue(object, tx.getClassLoader());
        if (value != null) {
            Iterator itor = ClassMolderHelper.getIterator(value);
            while (itor.hasNext()) {
                Object oo = itor.next();
                if (!this.isCascadingUpdate(tx) || tx.isRecorded(oo) || !tx.markUpdate(fieldClassMolder, oo, null)) continue;
                updateCache = true;
            }
        }
        return updateCache;
    }
}

