/*
 * Decompiled with CFR 0.152.
 */
package org.castor.persist.resolver;

import org.castor.persist.resolver.BaseRelationResolver;
import org.castor.persist.resolver.ManyToManyRelationResolver;
import org.castor.persist.resolver.OneToManyRelationResolver;
import org.castor.persist.resolver.PersistanceCapableRelationResolver;
import org.castor.persist.resolver.PrimitiveResolver;
import org.castor.persist.resolver.ResolverStrategy;
import org.castor.persist.resolver.SerializableResolver;
import org.exolab.castor.persist.ClassMolder;
import org.exolab.castor.persist.FieldMolder;
import org.exolab.castor.persist.FieldPersistenceType;

public final class ResolverFactory {
    private ResolverFactory() {
    }

    public static ResolverStrategy createRelationResolver(FieldMolder fieldMolder, ClassMolder classMolder, int fieldIndex) {
        BaseRelationResolver relationResolver = null;
        FieldPersistenceType fieldType = fieldMolder.getFieldPertsistenceType();
        switch (fieldType) {
            case PRIMITIVE: {
                relationResolver = new PrimitiveResolver(classMolder, fieldMolder, fieldIndex);
                break;
            }
            case SERIALIZABLE: {
                relationResolver = new SerializableResolver(classMolder, fieldMolder, fieldIndex);
                break;
            }
            case PERSISTANCECAPABLE: {
                relationResolver = new PersistanceCapableRelationResolver(classMolder, fieldMolder, fieldIndex);
                break;
            }
            case ONE_TO_MANY: {
                relationResolver = new OneToManyRelationResolver(classMolder, fieldMolder, fieldIndex);
                break;
            }
            case MANY_TO_MANY: {
                relationResolver = new ManyToManyRelationResolver(classMolder, fieldMolder, fieldIndex);
                break;
            }
        }
        return relationResolver;
    }
}

