/*
 * Decompiled with CFR 0.152.
 */
package org.castor.transactionmanager;

import java.lang.reflect.Method;
import java.util.Properties;
import javax.transaction.TransactionManager;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.castor.transactionmanager.TransactionManagerAcquireException;
import org.castor.transactionmanager.TransactionManagerFactory;

public final class JOTMTransactionManagerFactory
implements TransactionManagerFactory {
    private static final Log LOG = LogFactory.getLog(JOTMTransactionManagerFactory.class);
    public static final String FACTORY_CLASS_NAME = "org.objectweb.jotm.Jotm";
    public static final String NAME = "jotm";

    public String getName() {
        return NAME;
    }

    public TransactionManager getTransactionManager(Properties properties) throws TransactionManagerAcquireException {
        return this.getTransactionManager(FACTORY_CLASS_NAME, properties);
    }

    public TransactionManager getTransactionManager(String factoryClassName, Properties properties) throws TransactionManagerAcquireException {
        TransactionManager transactionManager = null;
        try {
            Class<?> factory = Class.forName(factoryClassName);
            Class[] types = new Class[]{Boolean.TYPE, Boolean.TYPE};
            Object[] params = new Object[]{Boolean.TRUE, Boolean.FALSE};
            Object jotm = factory.getConstructor(types).newInstance(params);
            Method method = factory.getMethod("getTransactionManager", new Class[0]);
            Object obj = method.invoke(jotm, (Object[])null);
            transactionManager = (TransactionManager)obj;
        }
        catch (Exception ex) {
            String msg = "Unable to acquire instance of javax.transaction.TransactionManager: jotm";
            LOG.error((Object)msg);
            throw new TransactionManagerAcquireException(msg, ex);
        }
        if (transactionManager == null) {
            String msg = "Unable to acquire instance of javax.transaction.TransactionManager: jotm";
            LOG.error((Object)msg);
            throw new TransactionManagerAcquireException(msg);
        }
        return transactionManager;
    }
}

