/*
 * Decompiled with CFR 0.152.
 */
package org.castor.transactionmanager;

import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.transaction.TransactionManager;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.castor.core.util.AbstractProperties;
import org.castor.transactionmanager.TransactionManagerAcquireException;
import org.castor.transactionmanager.TransactionManagerFactory;
import org.castor.transactionmanager.TransactionManagerFactoryRegistry;

public final class TransactionManagerRegistry {
    private static final Log LOG = LogFactory.getLog(TransactionManagerRegistry.class);
    private TransactionManagerFactoryRegistry _registry;
    private boolean _initializationAtRegistration;
    private Map<String, Loader> _managers = new HashMap<String, Loader>();

    public TransactionManagerRegistry(AbstractProperties properties) {
        this._registry = new TransactionManagerFactoryRegistry(properties);
        this._initializationAtRegistration = properties.getBoolean("org.castor.transactionmanager.InitializeAtRegistration", false);
    }

    public void registerTransactionManager(String managerName, String factoryName, Properties properties) throws TransactionManagerAcquireException {
        Loader loader = new Loader(factoryName, properties);
        this.registerTransactionManager(managerName, loader);
        if (this._initializationAtRegistration) {
            loader.initialize();
        }
    }

    public void registerTransactionManager(String managerName, TransactionManager managerInstance) throws TransactionManagerAcquireException {
        Loader loader = new Loader(managerInstance);
        this.registerTransactionManager(managerName, loader);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void registerTransactionManager(String managerName, Loader loader) throws TransactionManagerAcquireException {
        Map<String, Loader> map = this._managers;
        synchronized (map) {
            if (this._managers.containsKey(managerName)) {
                String msg = "A TransactionManager with the name '" + managerName + "' " + "has already been registered.";
                LOG.error((Object)msg);
                throw new TransactionManagerAcquireException(msg);
            }
            this._managers.put(managerName, loader);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deregisterTransactionManager(String managerName) {
        Map<String, Loader> map = this._managers;
        synchronized (map) {
            this._managers.remove(managerName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getTransactionManagerNames() {
        Map<String, Loader> map = this._managers;
        synchronized (map) {
            String[] names = new String[this._managers.size()];
            return this._managers.keySet().toArray(names);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TransactionManager getTransactionManager(String managerName) throws TransactionManagerAcquireException {
        Loader loader = null;
        Map<String, Loader> map = this._managers;
        synchronized (map) {
            loader = this._managers.get(managerName);
        }
        if (loader == null) {
            String msg = "A TransactionManager with the name '" + managerName + "' " + "has not been registered.";
            LOG.error((Object)msg);
            throw new TransactionManagerAcquireException(msg);
        }
        return loader.getManagerInstance();
    }

    private class Loader {
        private TransactionManagerFactory _factory;
        private Properties _properties;
        private TransactionManager _managerInstance;

        public Loader(String factoryName, Properties properties) throws TransactionManagerAcquireException {
            this._factory = TransactionManagerRegistry.this._registry.getTransactionManagerFactory(factoryName);
            this._properties = properties;
            this._managerInstance = null;
        }

        public Loader(TransactionManager managerInstance) {
            this._factory = null;
            this._properties = null;
            this._managerInstance = managerInstance;
        }

        public TransactionManager getManagerInstance() throws TransactionManagerAcquireException {
            this.initialize();
            return this._managerInstance;
        }

        public synchronized void initialize() throws TransactionManagerAcquireException {
            if (this._managerInstance == null) {
                this._managerInstance = this._factory.getTransactionManager(this._properties);
            }
        }
    }
}

