/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.castor.jdo;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class DbMetaInfo {
    private static Log _log = LogFactory.getFactory().getInstance(DbMetaInfo.class);
    private static final String RELEASE = "Release ";
    private static final int RELEASE_LENGTH = "Release ".length();
    private DatabaseMetaData _connInfo;
    private Connection _conn = null;
    private String _dbVersion = null;

    public DbMetaInfo(Connection conn) {
        this._conn = conn;
    }

    private void init() {
        if (this._connInfo == null) {
            try {
                this._connInfo = this._conn.getMetaData();
                String dbProdVer = this._connInfo.getDatabaseProductVersion();
                String word = null;
                int idx = dbProdVer.indexOf(RELEASE);
                if (idx != -1) {
                    int n = dbProdVer.indexOf(32, idx += RELEASE_LENGTH);
                    String string = word = n != -1 ? dbProdVer.substring(idx, n) : dbProdVer.substring(idx);
                    if (Character.isDigit(word.charAt(0))) {
                        this._dbVersion = word;
                    }
                }
                if (this._dbVersion == null) {
                    int i = 0;
                    while (true) {
                        int n;
                        String string = word = (n = dbProdVer.indexOf(32, i)) != -1 ? dbProdVer.substring(i, n) : dbProdVer.substring(i);
                        if (Character.isDigit(word.charAt(0))) {
                            this._dbVersion = word;
                        } else if (n != -1) {
                            i = n + 1;
                            continue;
                        }
                        break;
                    }
                }
            }
            catch (SQLException e) {
                this._dbVersion = "";
                _log.error((Object)e);
            }
        }
    }

    public String getDbVersion() {
        this.init();
        return this._dbVersion;
    }

    public int compareDbVersion(String version) {
        this.init();
        return DbMetaInfo.compareVersionStrings(this._dbVersion, version);
    }

    static int compareVersionStrings(String v1, String v2) {
        int p1 = 0;
        int p2 = 0;
        while (true) {
            int x2;
            int n1 = v1.indexOf(46, p1);
            int n2 = v2.indexOf(46, p2);
            String s1 = n1 != -1 ? v1.substring(p1, n1) : v1.substring(p1);
            String s2 = n2 != -1 ? v2.substring(p2, n2) : v2.substring(p2);
            int x1 = s1.length() > 0 ? Integer.parseInt(s1) : 0;
            int n = x2 = s2.length() > 0 ? Integer.parseInt(s2) : 0;
            if (x1 < x2) {
                return -1;
            }
            if (x1 > x2) {
                return 1;
            }
            if (n1 == -1 && n2 == -1) {
                return 0;
            }
            p1 = n1 != -1 ? n1 + 1 : v1.length();
            p2 = n2 != -1 ? n2 + 1 : v2.length();
        }
    }
}

