/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.castor.jdo.engine;

import java.sql.Connection;
import java.util.Stack;
import java.util.Vector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.castor.core.nature.PropertyHolder;
import org.castor.core.util.Messages;
import org.castor.cpa.persistence.sql.engine.CastorConnection;
import org.castor.cpa.persistence.sql.engine.SQLStatementDelete;
import org.castor.cpa.persistence.sql.engine.SQLStatementInsert;
import org.castor.cpa.persistence.sql.engine.SQLStatementUpdate;
import org.castor.cpa.persistence.sql.engine.info.InfoFactory;
import org.castor.cpa.persistence.sql.engine.info.TableInfo;
import org.castor.persist.ProposedEntity;
import org.exolab.castor.jdo.Database;
import org.exolab.castor.jdo.PersistenceException;
import org.exolab.castor.jdo.QueryException;
import org.exolab.castor.jdo.engine.SQLColumnInfo;
import org.exolab.castor.jdo.engine.SQLFieldInfo;
import org.exolab.castor.jdo.engine.SQLQuery;
import org.exolab.castor.jdo.engine.SQLStatementLoad;
import org.exolab.castor.jdo.engine.SQLStatementQuery;
import org.exolab.castor.jdo.engine.nature.ClassDescriptorJDONature;
import org.exolab.castor.jdo.engine.nature.FieldDescriptorJDONature;
import org.exolab.castor.mapping.AccessMode;
import org.exolab.castor.mapping.ClassDescriptor;
import org.exolab.castor.mapping.FieldDescriptor;
import org.exolab.castor.mapping.MappingException;
import org.exolab.castor.mapping.TypeConvertor;
import org.exolab.castor.mapping.loader.ClassDescriptorImpl;
import org.exolab.castor.mapping.loader.FieldHandlerImpl;
import org.exolab.castor.persist.SQLRelationLoader;
import org.exolab.castor.persist.spi.Identity;
import org.exolab.castor.persist.spi.Persistence;
import org.exolab.castor.persist.spi.PersistenceFactory;
import org.exolab.castor.persist.spi.PersistenceQuery;
import org.exolab.castor.persist.spi.QueryExpression;

public final class SQLEngine
implements Persistence {
    private static final Log LOG = LogFactory.getLog(SQLEngine.class);
    private static final String JDO_FIELD_NATURE = FieldDescriptorJDONature.class.getName();
    private final SQLFieldInfo[] _fields;
    private final SQLColumnInfo[] _ids;
    private SQLEngine _extends;
    private final PersistenceFactory _factory;
    private final ClassDescriptor _clsDesc;
    private final SQLStatementQuery _queryStatement;
    private final SQLStatementLoad _loadStatement;
    private final SQLStatementInsert _createStatement;
    private final SQLStatementDelete _removeStatement;
    private final SQLStatementUpdate _storeStatement;
    private final TableInfo _tableInfo;

    public SQLEngine(ClassDescriptor clsDesc, PersistenceFactory factory) throws MappingException {
        this._clsDesc = clsDesc;
        this._factory = factory;
        Vector<SQLColumnInfo> idsInfo = new Vector<SQLColumnInfo>();
        Vector<SQLFieldInfo> fieldsInfo = new Vector<SQLFieldInfo>();
        ClassDescriptor base = clsDesc;
        base = clsDesc;
        Stack<ClassDescriptor> stack = new Stack<ClassDescriptor>();
        stack.push(base);
        while (base.getExtends() != null) {
            base = base.getExtends();
            stack.push(base);
        }
        FieldDescriptor[] baseIdDescriptors = ((ClassDescriptorImpl)base).getIdentities();
        FieldDescriptor[] idDescriptors = ((ClassDescriptorImpl)clsDesc).getIdentities();
        for (int i = 0; i < baseIdDescriptors.length; ++i) {
            FieldHandlerImpl fh;
            int[] sqlType;
            String[] sqlName;
            if (baseIdDescriptors[i].hasNature(FieldDescriptorJDONature.class.getName())) {
                String name = baseIdDescriptors[i].getFieldName();
                sqlName = new FieldDescriptorJDONature((PropertyHolder)baseIdDescriptors[i]).getSQLName();
                sqlType = new FieldDescriptorJDONature((PropertyHolder)baseIdDescriptors[i]).getSQLType();
                fh = (FieldHandlerImpl)baseIdDescriptors[i].getHandler();
                for (int j = 0; j < idDescriptors.length; ++j) {
                    if (!name.equals(idDescriptors[j].getFieldName()) || !idDescriptors[j].hasNature(JDO_FIELD_NATURE)) continue;
                    sqlName = new FieldDescriptorJDONature((PropertyHolder)idDescriptors[j]).getSQLName();
                    break;
                }
            } else {
                throw new MappingException("Except JDOFieldDescriptor");
            }
            idsInfo.add(new SQLColumnInfo(sqlName[0], sqlType[0], fh.getConvertTo(), fh.getConvertFrom()));
        }
        while (!stack.empty()) {
            base = (ClassDescriptor)stack.pop();
            FieldDescriptor[] fieldDescriptors = base.getFields();
            for (int i = 0; i < fieldDescriptors.length; ++i) {
                if (fieldDescriptors[i].isTransient() || !fieldDescriptors[i].hasNature(FieldDescriptorJDONature.class.getName()) && fieldDescriptors[i].getClassDescriptor() == null) continue;
                SQLFieldInfo inf = new SQLFieldInfo(clsDesc, fieldDescriptors[i], new ClassDescriptorJDONature((PropertyHolder)base).getTableName(), !stack.empty());
                fieldsInfo.add(inf);
                if (inf.isJoined()) {
                    String alias = inf.getTableName() + "_f" + i;
                    inf.setTableAlias(alias);
                    continue;
                }
                inf.setTableAlias(inf.getTableName());
            }
        }
        InfoFactory infoFactory = new InfoFactory();
        this._tableInfo = infoFactory.createTableInfo(clsDesc);
        infoFactory.resolveForeignKeys();
        this._ids = new SQLColumnInfo[idsInfo.size()];
        idsInfo.copyInto(this._ids);
        this._fields = new SQLFieldInfo[fieldsInfo.size()];
        fieldsInfo.copyInto(this._fields);
        this._queryStatement = new SQLStatementQuery(this, factory);
        this._loadStatement = new SQLStatementLoad(this, factory);
        this._createStatement = new SQLStatementInsert(this, factory);
        this._removeStatement = new SQLStatementDelete(this);
        this._storeStatement = new SQLStatementUpdate(this);
    }

    public SQLRelationLoader createSQLRelationLoader(String manyTable, String[] idSQL, int[] idType, TypeConvertor[] idTo, TypeConvertor[] idFrom, String[] relatedIdSQL, int[] relatedIdType, TypeConvertor[] ridTo, TypeConvertor[] ridFrom) {
        return new SQLRelationLoader(manyTable, idSQL, idType, idTo, idFrom, relatedIdSQL, relatedIdType, ridTo, ridFrom, this._factory);
    }

    public SQLColumnInfo[] getColumnInfoForIdentities() {
        return this._ids;
    }

    public SQLFieldInfo[] getInfo() {
        return this._fields;
    }

    public void setExtends(SQLEngine engine) {
        this._extends = engine;
    }

    public SQLEngine getExtends() {
        return this._extends;
    }

    public ClassDescriptor getDescriptor() {
        return this._clsDesc;
    }

    public PersistenceQuery createQuery(QueryExpression query, Class[] types, AccessMode accessMode) throws QueryException {
        AccessMode mode = accessMode != null ? accessMode : new ClassDescriptorJDONature((PropertyHolder)this._clsDesc).getAccessMode();
        String sql = query.getStatement(mode == AccessMode.DbLocked);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)Messages.format((String)"jdo.createSql", (Object)sql));
        }
        return new SQLQuery(this, this._factory, sql, types, false);
    }

    public PersistenceQuery createCall(String spCall, Class[] types) {
        if (spCall.startsWith("SQL")) {
            String sql = spCall.substring(4);
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)Messages.format((String)"jdo.directSQL", (Object)sql));
            }
            return new SQLQuery(this, this._factory, sql, types, true);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)Messages.format((String)"jdo.spCall", (Object)spCall));
        }
        FieldDescriptor[] fields = this._clsDesc.getFields();
        String[] jdoFields0 = new String[fields.length + 1];
        int[] sqlTypes0 = new int[fields.length + 1];
        int count = 1;
        jdoFields0[0] = this._clsDesc.getIdentity().getFieldName();
        sqlTypes0[0] = new FieldDescriptorJDONature((PropertyHolder)this._clsDesc.getIdentity()).getSQLType()[0];
        for (int i = 0; i < fields.length; ++i) {
            if (!fields[i].hasNature(FieldDescriptorJDONature.class.getName())) continue;
            jdoFields0[count] = new FieldDescriptorJDONature((PropertyHolder)fields[i]).getSQLName()[0];
            sqlTypes0[count] = new FieldDescriptorJDONature((PropertyHolder)fields[i]).getSQLType()[0];
            ++count;
        }
        String[] jdoFields = new String[count];
        int[] sqlTypes = new int[count];
        System.arraycopy(jdoFields0, 0, jdoFields, 0, count);
        System.arraycopy(sqlTypes0, 0, sqlTypes, 0, count);
        return this._factory.getCallQuery(spCall, types, this._clsDesc.getJavaClass(), jdoFields, sqlTypes);
    }

    public QueryExpression getQueryExpression() {
        return this._factory.getQueryExpression();
    }

    public QueryExpression getFinder() {
        return this._queryStatement.getQueryExpression();
    }

    public TableInfo getTableInfo() {
        return this._tableInfo;
    }

    protected Object idToJava(int index, Object object) {
        if (object == null || this._ids[index].getConvertTo() == null) {
            return object;
        }
        return this._ids[index].getConvertTo().convert(object);
    }

    protected Object toJava(int field, int column, Object object) {
        SQLColumnInfo col = this._fields[field].getColumnInfo()[column];
        if (object == null || col.getConvertTo() == null) {
            return object;
        }
        return col.getConvertTo().convert(object);
    }

    public Identity create(Database database, Object conn, ProposedEntity entity, Identity identity) throws PersistenceException {
        CastorConnection castorConn = new CastorConnection((Connection)conn, this._factory);
        return (Identity)this._createStatement.executeStatement(database, castorConn, identity, entity);
    }

    public void store(Object conn, Identity identity, ProposedEntity newentity, ProposedEntity oldentity) throws PersistenceException {
        if (identity.size() != this._ids.length) {
            throw new PersistenceException("Size of identity field mismatched!");
        }
        CastorConnection castorConn = new CastorConnection((Connection)conn, this._factory);
        this._storeStatement.executeStatement(castorConn, identity, newentity, oldentity);
    }

    public void delete(Object conn, Identity identity) throws PersistenceException {
        if (identity.size() != this._ids.length) {
            throw new PersistenceException("Size of identity field mismatched!");
        }
        CastorConnection castorConn = new CastorConnection((Connection)conn, this._factory);
        this._removeStatement.executeStatement(castorConn, identity);
    }

    public void load(Object conn, ProposedEntity entity, Identity identity, AccessMode accessMode) throws PersistenceException {
        if (identity.size() != this._ids.length) {
            throw new PersistenceException("Size of identity field mismatched!");
        }
        CastorConnection castorConn = new CastorConnection((Connection)conn, this._factory);
        this._loadStatement.executeStatement(castorConn, identity, entity, accessMode);
    }

    public String toString() {
        return this._clsDesc.toString();
    }
}

