/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.castor.jdo.engine;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.castor.core.nature.PropertyHolder;
import org.castor.core.util.Messages;
import org.castor.cpa.persistence.sql.engine.CastorConnection;
import org.castor.cpa.persistence.sql.engine.CastorStatement;
import org.castor.cpa.persistence.sql.engine.info.ColumnInfo;
import org.castor.cpa.persistence.sql.engine.info.ColumnValue;
import org.castor.cpa.persistence.sql.engine.info.TableInfo;
import org.castor.cpa.persistence.sql.engine.info.TableLink;
import org.castor.cpa.persistence.sql.query.Qualifier;
import org.castor.cpa.persistence.sql.query.Select;
import org.castor.cpa.persistence.sql.query.Table;
import org.castor.cpa.persistence.sql.query.TableAlias;
import org.castor.cpa.persistence.sql.query.condition.AndCondition;
import org.castor.cpa.persistence.sql.query.condition.Compare;
import org.castor.cpa.persistence.sql.query.condition.CompareOperator;
import org.castor.cpa.persistence.sql.query.condition.Condition;
import org.castor.cpa.persistence.sql.query.expression.Parameter;
import org.castor.cpa.persistence.sql.query.visitor.UncoupleVisitor;
import org.castor.jdo.engine.SQLTypeInfos;
import org.castor.jdo.util.JDOUtils;
import org.castor.persist.ProposedEntity;
import org.exolab.castor.jdo.ObjectNotFoundException;
import org.exolab.castor.jdo.PersistenceException;
import org.exolab.castor.jdo.engine.SQLColumnInfo;
import org.exolab.castor.jdo.engine.SQLEngine;
import org.exolab.castor.jdo.engine.SQLFieldInfo;
import org.exolab.castor.jdo.engine.SQLHelper;
import org.exolab.castor.jdo.engine.nature.ClassDescriptorJDONature;
import org.exolab.castor.mapping.AccessMode;
import org.exolab.castor.mapping.ClassDescriptor;
import org.exolab.castor.mapping.MappingException;
import org.exolab.castor.persist.spi.Identity;
import org.exolab.castor.persist.spi.PersistenceFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SQLStatementLoad {
    private static final Log LOG = LogFactory.getLog(SQLStatementLoad.class);
    private final String _type;
    private final String _mapTo;
    private Map<String, Integer> _resultColumnMap;
    private final int _numberOfExtendLevels;
    private final Collection<ClassDescriptor> _extendingClassDescriptors;
    private Select _select;
    private SQLEngine _engine;
    private TableInfo _mainTableInfo;

    public SQLStatementLoad(SQLEngine engine, PersistenceFactory factory) throws MappingException {
        ClassDescriptor desc = engine.getDescriptor();
        this._type = desc.getJavaClass().getName();
        this._mapTo = new ClassDescriptorJDONature((PropertyHolder)desc).getTableName();
        this._engine = engine;
        this._mainTableInfo = engine.getTableInfo();
        this._numberOfExtendLevels = SQLHelper.numberOfExtendingClassDescriptors(desc);
        this._extendingClassDescriptors = new ClassDescriptorJDONature((PropertyHolder)desc).getExtended();
        this.buildStatement();
    }

    private void buildStatement() throws MappingException {
        ArrayList<TableInfo> joinTableInfos = new ArrayList<TableInfo>();
        Table mainTbl = new Table(this._mapTo);
        this._select = new Select(mainTbl);
        TableInfo currentTblInf = this._mainTableInfo;
        Table walkTbl = mainTbl;
        while (currentTblInf.getExtendedTable() != null) {
            TableInfo extendedTable = currentTblInf.getExtendedTable();
            Table tempTbl = new Table(extendedTable.getTableName());
            AndCondition cond = this.constructCondition(walkTbl, currentTblInf.getPrimaryKey().getColumns(), CompareOperator.EQ, tempTbl, extendedTable.getPrimaryKey().getColumns());
            walkTbl.addInnerJoin(tempTbl, cond);
            joinTableInfos.add(extendedTable);
            this.addCols(extendedTable, joinTableInfos, mainTbl, true);
            walkTbl = tempTbl;
            currentTblInf = extendedTable;
        }
        this.addCols(this._mainTableInfo, joinTableInfos, mainTbl, true);
        this.addExtendingTables(this._mainTableInfo, mainTbl, joinTableInfos);
        AndCondition condition = new AndCondition();
        for (ColumnInfo col : this._mainTableInfo.getPrimaryKey().getColumns()) {
            String name = col.getName();
            ((Condition)condition).and(mainTbl.column(name).equal(new Parameter(name)));
        }
        this._select.setCondition(condition);
    }

    private void addExtendingTables(TableInfo info, Table mainTbl, List<TableInfo> joinTableInfos) {
        for (TableInfo tbl : info.getExtendingTables()) {
            Table t = new Table(tbl.getTableName());
            mainTbl.addLeftJoin(t, this.constructCondition(mainTbl, this._mainTableInfo.getPrimaryKey().getColumns(), CompareOperator.EQ, t, tbl.getPrimaryKey().getColumns()));
            this.addCols(tbl, joinTableInfos, mainTbl, false);
            this.addExtendingTables(tbl, t, joinTableInfos);
        }
    }

    private void addCols(TableInfo tblInfo, List<TableInfo> joinTables, Table mainTbl, boolean addJoin) {
        Table table = new Table(tblInfo.getTableName());
        this.addColumns(table, tblInfo.getPrimaryKey().getColumns());
        this.addColumns(table, tblInfo.getColumns());
        for (TableLink tblLnk : tblInfo.getForeignKeys()) {
            if (0 != tblLnk.getRelationType()) {
                TableInfo joinTableInfo = tblLnk.getTargetTable();
                Qualifier joinTable = new Table(joinTableInfo.getTableName());
                if (!addJoin) continue;
                if (joinTables.contains(tblLnk.getTargetTable()) || this._mapTo.equals(tblLnk.getTargetTable().getTableName())) {
                    joinTable = new TableAlias((Table)joinTable, tblLnk.getTableAlias());
                    mainTbl.addLeftJoin(joinTable, this.constructCondition(table, tblLnk.getStartCols(), CompareOperator.EQ, joinTable, tblLnk.getTargetCols()));
                } else {
                    mainTbl.addLeftJoin(joinTable, this.constructCondition(table, tblLnk.getStartCols(), CompareOperator.EQ, joinTable, tblLnk.getTargetCols()));
                    joinTables.add(tblLnk.getTargetTable());
                }
                if (1 == tblLnk.getRelationType()) {
                    this.addColumns(joinTable, joinTableInfo.getPrimaryKey().getColumns());
                    continue;
                }
                if (2 != tblLnk.getRelationType()) continue;
                this.addColumns(joinTable, joinTableInfo.getColumns());
                continue;
            }
            this.addColumns(table, tblLnk.getStartCols());
        }
    }

    private void addColumns(Qualifier table, List<ColumnInfo> columns) {
        for (ColumnInfo col : columns) {
            this._select.addSelect(table.column(col.getName()));
        }
    }

    private AndCondition constructCondition(Qualifier leftTbl, List<ColumnInfo> leftCols, CompareOperator compareOp, Qualifier rightTbl, List<ColumnInfo> rightCols) {
        if (leftCols.size() != rightCols.size()) {
            System.out.println("Error while constructing condition! Size of leftCols and rightCols is not equal!");
        }
        AndCondition cond = new AndCondition();
        for (int i = 0; i < leftCols.size(); ++i) {
            cond.and(new Compare(leftTbl.column(leftCols.get(i).getName()), compareOp, rightTbl.column(rightCols.get(i).getName())));
        }
        return cond;
    }

    /*
     * Loose catch block
     */
    public void executeStatement(CastorConnection conn, Identity identity, ProposedEntity entity, AccessMode accessMode) throws PersistenceException {
        block25: {
            Object[] id;
            ArrayList res;
            String tableName;
            SQLColumnInfo[] columns;
            SQLFieldInfo field;
            int i;
            SQLFieldInfo[] fields;
            CastorStatement stmt;
            ResultSet rs;
            block24: {
                rs = null;
                TableInfo info = this._engine.getTableInfo();
                UncoupleVisitor uncle = new UncoupleVisitor();
                uncle.visit(this._select);
                this._resultColumnMap = uncle.getResultColumnMap();
                stmt = conn.createStatement();
                SQLColumnInfo[] ids = this._engine.getColumnInfoForIdentities();
                fields = this._engine.getInfo();
                boolean locked = accessMode == AccessMode.DbLocked;
                this._select.setLocked(locked);
                stmt.prepareStatement(this._select);
                if (LOG.isTraceEnabled()) {
                    LOG.trace((Object)Messages.format((String)"jdo.loading", (Object)this._type, (Object)stmt.toString()));
                }
                for (ColumnValue value : info.toSQL(identity)) {
                    stmt.bindParameter(value.getName(), value.getValue(), value.getType());
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)Messages.format((String)"jdo.loading", (Object)this._type, (Object)stmt.toString()));
                }
                if (!(rs = stmt.executeQuery()).next()) {
                    throw new ObjectNotFoundException(Messages.format((String)"persist.objectNotFound", (Object)this._type, (Object)identity));
                }
                if (this._extendingClassDescriptors.size() <= 0) break block24;
                Object[] returnValues = SQLHelper.calculateNumberOfFields(this._extendingClassDescriptors, ids.length, fields.length, this._numberOfExtendLevels, rs);
                ClassDescriptor potentialLeafDescriptor = (ClassDescriptor)returnValues[0];
                if (potentialLeafDescriptor != null && !potentialLeafDescriptor.getJavaClass().getName().equals(this._type)) {
                    entity.initializeFields(potentialLeafDescriptor.getFields().length);
                    entity.setActualEntityClass(potentialLeafDescriptor.getJavaClass());
                    entity.setExpanded(true);
                }
                if (potentialLeafDescriptor == null) break block24;
                JDOUtils.closeResultSet(rs);
                try {
                    stmt.close();
                }
                catch (SQLException e) {
                    LOG.warn((Object)"Problem closing JDBC statement", (Throwable)e);
                }
                return;
            }
            for (i = 0; i < fields.length; ++i) {
                field = fields[i];
                columns = field.getColumnInfo();
                tableName = field.getTableAlias();
                if (!this._resultColumnMap.containsKey(tableName + "." + field.getColumnInfo()[0].getName())) {
                    tableName = field.getTableName();
                }
                if (!field.isJoined() && field.getJoinFields() == null) {
                    entity.setField(this.getColValue(columns[0], rs, tableName), i);
                    continue;
                }
                if (!field.isMulti()) {
                    Object[] id2 = this.fillObjectArray(columns, rs, tableName);
                    entity.setField(id2 != null ? new Identity(id2) : null, i);
                    continue;
                }
                res = new ArrayList();
                id = this.fillObjectArray(columns, rs, tableName);
                if (id != null) {
                    res.add(new Identity(id));
                }
                entity.setField(res, i);
            }
            while (rs.next()) {
                for (i = 0; i < fields.length; ++i) {
                    Identity com;
                    field = fields[i];
                    columns = field.getColumnInfo();
                    tableName = field.getTableAlias();
                    if (!this._resultColumnMap.containsKey(tableName + "." + field.getColumnInfo()[0].getName())) {
                        tableName = field.getTableName();
                    }
                    if (!field.isMulti()) continue;
                    res = (ArrayList)entity.getField(i);
                    id = this.fillObjectArray(columns, rs, tableName);
                    if (id == null || res.contains(com = new Identity(id))) continue;
                    res.add(com);
                }
            }
            JDOUtils.closeResultSet(rs);
            try {
                stmt.close();
            }
            catch (SQLException e) {
                LOG.warn((Object)"Problem closing JDBC statement", (Throwable)e);
            }
            break block25;
            catch (SQLException except) {
                try {
                    LOG.fatal((Object)Messages.format((String)"jdo.loadFatal", (Object)this._type, (Object)this._select.toString()), (Throwable)except);
                    throw new PersistenceException(Messages.format((String)"persist.nested", (Object)except), except);
                }
                catch (Throwable throwable) {
                    JDOUtils.closeResultSet(rs);
                    try {
                        stmt.close();
                    }
                    catch (SQLException e) {
                        LOG.warn((Object)"Problem closing JDBC statement", (Throwable)e);
                    }
                    throw throwable;
                }
            }
        }
    }

    private Object[] fillObjectArray(SQLColumnInfo[] columns, ResultSet rs, String tableName) throws SQLException {
        int colsLength = columns.length;
        boolean notNull = false;
        Object[] id = new Object[colsLength];
        for (int j = 0; j < colsLength; ++j) {
            id[j] = this.getColValue(columns[j], rs, tableName);
            if (id[j] == null) continue;
            notNull = true;
        }
        if (notNull) {
            return id;
        }
        return null;
    }

    private Object getColValue(SQLColumnInfo col, ResultSet rs, String tblName) throws SQLException {
        return col.toJava(SQLTypeInfos.getValue(rs, this._resultColumnMap.get(tblName + "." + col.getName()), col.getSqlType()));
    }
}

