/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.castor.jdo.engine;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.Vector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.castor.core.nature.PropertyHolder;
import org.castor.core.util.Messages;
import org.exolab.castor.jdo.QueryException;
import org.exolab.castor.jdo.engine.SQLColumnInfo;
import org.exolab.castor.jdo.engine.SQLEngine;
import org.exolab.castor.jdo.engine.SQLFieldInfo;
import org.exolab.castor.jdo.engine.SQLHelper;
import org.exolab.castor.jdo.engine.nature.ClassDescriptorJDONature;
import org.exolab.castor.mapping.ClassDescriptor;
import org.exolab.castor.mapping.MappingException;
import org.exolab.castor.persist.spi.Persistence;
import org.exolab.castor.persist.spi.PersistenceFactory;
import org.exolab.castor.persist.spi.QueryExpression;

public final class SQLStatementQuery {
    private static final Log LOG = LogFactory.getLog(SQLStatementQuery.class);
    private final SQLEngine _engine;
    private final PersistenceFactory _factory;
    private final String _type;
    private final String _mapTo;
    private QueryExpression _queryExpression;

    public SQLStatementQuery(SQLEngine engine, PersistenceFactory factory) throws MappingException {
        this._engine = engine;
        this._factory = factory;
        this._type = engine.getDescriptor().getJavaClass().getName();
        this._mapTo = new ClassDescriptorJDONature((PropertyHolder)engine.getDescriptor()).getTableName();
        this.buildStatement();
    }

    private void buildStatement() throws MappingException {
        try {
            QueryExpression expr = this._factory.getQueryExpression();
            HashMap<String, Boolean> identitiesUsedForTable = new HashMap<String, Boolean>();
            Vector<String> joinTables = new Vector<String>();
            ClassDescriptor curDesc = this._engine.getDescriptor();
            while (curDesc.getExtends() != null) {
                ClassDescriptor baseDesc = curDesc.getExtends();
                String[] curDescIdNames = SQLHelper.getIdentitySQLNames(curDesc);
                String[] baseDescIdNames = SQLHelper.getIdentitySQLNames(baseDesc);
                expr.addInnerJoin(new ClassDescriptorJDONature((PropertyHolder)curDesc).getTableName(), curDescIdNames, new ClassDescriptorJDONature((PropertyHolder)curDesc).getTableName(), new ClassDescriptorJDONature((PropertyHolder)baseDesc).getTableName(), baseDescIdNames, new ClassDescriptorJDONature((PropertyHolder)baseDesc).getTableName());
                joinTables.add(new ClassDescriptorJDONature((PropertyHolder)baseDesc).getTableName());
                curDesc = baseDesc;
            }
            SQLColumnInfo[] ids = this._engine.getColumnInfoForIdentities();
            SQLFieldInfo[] fields = this._engine.getInfo();
            String aliasOld = null;
            String alias = null;
            for (int i = 0; i < fields.length; ++i) {
                int j;
                ClassDescriptor classDescriptor;
                boolean isTableNameAlreadyAdded;
                SQLFieldInfo field = fields[i];
                if (i > 0) {
                    aliasOld = alias;
                }
                alias = field.getTableName();
                if (i == 0 && field.isJoined()) {
                    String[] identities = SQLHelper.getIdentitySQLNames(this._engine.getDescriptor());
                    for (int j2 = 0; j2 < identities.length; ++j2) {
                        expr.addColumn(new ClassDescriptorJDONature((PropertyHolder)curDesc).getTableName(), identities[j2]);
                    }
                    identitiesUsedForTable.put(new ClassDescriptorJDONature((PropertyHolder)curDesc).getTableName(), Boolean.TRUE);
                }
                if (!(alias.equals(aliasOld) || field.isJoined() || (isTableNameAlreadyAdded = identitiesUsedForTable.containsKey(new ClassDescriptorJDONature((PropertyHolder)(classDescriptor = field.getFieldDescriptor().getContainingClassDescriptor())).getTableName())))) {
                    String[] identities = SQLHelper.getIdentitySQLNames(classDescriptor);
                    for (j = 0; j < identities.length; ++j) {
                        expr.addColumn(alias, identities[j]);
                    }
                    identitiesUsedForTable.put(new ClassDescriptorJDONature((PropertyHolder)classDescriptor).getTableName(), Boolean.TRUE);
                }
                if (field.isJoined()) {
                    int offset = 0;
                    String[] rightCol = field.getJoinFields();
                    String[] leftCol = new String[ids.length - offset];
                    for (j = 0; j < leftCol.length; ++j) {
                        leftCol[j] = ids[j + offset].getName();
                    }
                    ClassDescriptor clsDescriptor = this._engine.getDescriptor();
                    ClassDescriptorJDONature nature = new ClassDescriptorJDONature((PropertyHolder)clsDescriptor);
                    if (joinTables.contains(field.getTableName()) || nature.getTableName().equals(field.getTableName())) {
                        alias = alias.replace('.', '_') + "_f" + i;
                        expr.addOuterJoin(this._mapTo, leftCol, field.getTableName(), rightCol, alias);
                    } else {
                        expr.addOuterJoin(this._mapTo, leftCol, field.getTableName(), rightCol, field.getTableName());
                        joinTables.add(field.getTableName());
                    }
                }
                for (int j3 = 0; j3 < field.getColumnInfo().length; ++j3) {
                    expr.addColumn(alias, field.getColumnInfo()[j3].getName());
                }
                expr.addTable(field.getTableName(), alias);
            }
            LinkedList<ClassDescriptor> classDescriptorsToAdd = new LinkedList<ClassDescriptor>();
            ClassDescriptor classDescriptor2 = null;
            SQLHelper.addExtendingClassDescriptors(classDescriptorsToAdd, new ClassDescriptorJDONature((PropertyHolder)this._engine.getDescriptor()).getExtended());
            if (classDescriptorsToAdd.size() > 0) {
                for (ClassDescriptor classDescriptor2 : classDescriptorsToAdd) {
                    Persistence persistenceEngine;
                    ClassDescriptorJDONature clsDescNature = new ClassDescriptorJDONature((PropertyHolder)classDescriptor2);
                    if (LOG.isTraceEnabled()) {
                        LOG.trace((Object)("Adding outer left join for " + classDescriptor2.getJavaClass().getName() + " on table " + clsDescNature.getTableName()));
                    }
                    String[] engDescIdNames = SQLHelper.getIdentitySQLNames(this._engine.getDescriptor());
                    String[] clsDescIdNames = SQLHelper.getIdentitySQLNames(classDescriptor2);
                    expr.addOuterJoin(this._mapTo, engDescIdNames, clsDescNature.getTableName(), clsDescIdNames, clsDescNature.getTableName());
                    try {
                        persistenceEngine = this._factory.getPersistence(classDescriptor2);
                    }
                    catch (MappingException e) {
                        throw new QueryException("Problem obtaining persistence engine for ClassDescriptor " + classDescriptor2.getJavaClass().getName(), e);
                    }
                    SQLEngine engine = (SQLEngine)persistenceEngine;
                    SQLColumnInfo[] idInfos = engine.getColumnInfoForIdentities();
                    for (int i = 0; i < idInfos.length; ++i) {
                        expr.addColumn(clsDescNature.getTableName(), idInfos[i].getName());
                    }
                    SQLFieldInfo[] fieldInfos = ((SQLEngine)persistenceEngine).getInfo();
                    for (int i = 0; i < fieldInfos.length; ++i) {
                        boolean hasFieldToAdd = false;
                        SQLColumnInfo[] columnInfos = fieldInfos[i].getColumnInfo();
                        if (clsDescNature.getTableName().equals(fieldInfos[i].getTableName())) {
                            for (int j = 0; j < columnInfos.length; ++j) {
                                expr.addColumn(clsDescNature.getTableName(), fieldInfos[i].getColumnInfo()[j].getName());
                            }
                            hasFieldToAdd = true;
                        }
                        if (!hasFieldToAdd) continue;
                        expr.addTable(clsDescNature.getTableName(), clsDescNature.getTableName());
                    }
                }
            }
            if (fields.length == 0) {
                for (int i = 0; i < ids.length; ++i) {
                    expr.addColumn(this._mapTo, ids[i].getName());
                }
            }
            this._queryExpression = expr;
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)Messages.format((String)"jdo.finding", (Object)this._type, (Object)this._queryExpression));
            }
        }
        catch (QueryException ex) {
            LOG.warn((Object)"Problem building SQL", (Throwable)((Object)ex));
            throw new MappingException((Exception)((Object)ex));
        }
    }

    public QueryExpression getQueryExpression() {
        return (QueryExpression)this._queryExpression.clone();
    }
}

