/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.castor.persist;

import java.sql.Connection;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.Vector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.castor.core.nature.PropertyHolder;
import org.castor.core.util.Messages;
import org.castor.cpa.util.JDOClassDescriptorResolver;
import org.castor.jdo.util.ClassLoadingUtils;
import org.castor.persist.ProposedEntity;
import org.castor.persist.TransactionContext;
import org.castor.persist.UpdateAndRemovedFlags;
import org.castor.persist.UpdateFlags;
import org.castor.persist.resolver.ResolverFactory;
import org.castor.persist.resolver.ResolverStrategy;
import org.exolab.castor.jdo.ObjectModifiedException;
import org.exolab.castor.jdo.ObjectNotFoundException;
import org.exolab.castor.jdo.PersistenceException;
import org.exolab.castor.jdo.Persistent;
import org.exolab.castor.jdo.TimeStampable;
import org.exolab.castor.jdo.engine.JDOCallback;
import org.exolab.castor.jdo.engine.nature.ClassDescriptorJDONature;
import org.exolab.castor.jdo.engine.nature.FieldDescriptorJDONature;
import org.exolab.castor.mapping.AccessMode;
import org.exolab.castor.mapping.ClassDescriptor;
import org.exolab.castor.mapping.FieldDescriptor;
import org.exolab.castor.mapping.FieldHandler;
import org.exolab.castor.mapping.MappingException;
import org.exolab.castor.mapping.TypeConvertor;
import org.exolab.castor.mapping.loader.ClassDescriptorHelper;
import org.exolab.castor.mapping.loader.ClassDescriptorImpl;
import org.exolab.castor.mapping.loader.FieldHandlerImpl;
import org.exolab.castor.mapping.xml.NamedNativeQuery;
import org.exolab.castor.persist.DatingService;
import org.exolab.castor.persist.DepositBox;
import org.exolab.castor.persist.FieldMolder;
import org.exolab.castor.persist.FieldPersistenceType;
import org.exolab.castor.persist.LockEngine;
import org.exolab.castor.persist.OID;
import org.exolab.castor.persist.ObjectLock;
import org.exolab.castor.persist.QueryResults;
import org.exolab.castor.persist.SQLRelationLoader;
import org.exolab.castor.persist.spi.CallbackInterceptor;
import org.exolab.castor.persist.spi.Identity;
import org.exolab.castor.persist.spi.Persistence;
import org.exolab.castor.xml.ClassDescriptorResolver;
import org.exolab.castor.xml.ResolverException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassMolder {
    private static Log _log = LogFactory.getFactory().getInstance(ClassMolder.class);
    private String _name;
    private FieldMolder[] _ids;
    private FieldMolder[] _fhs;
    private ClassMolder _extends;
    private ClassMolder _depends;
    private Vector<ClassMolder> _dependent;
    private Vector<ClassMolder> _extendent;
    private AccessMode _accessMode;
    private Persistence _persistence;
    private LockEngine _engine;
    private CallbackInterceptor _callback;
    private Properties _cacheParams;
    public boolean _isKeyGenUsed;
    private int _priority = -1;
    private boolean _resolversHaveBeenReset = false;
    private ResolverStrategy[] _resolvers;
    private final ClassDescriptor _clsDesc;

    ClassMolder(DatingService ds, ClassDescriptorResolver classDescriptorResolver, LockEngine lock, ClassDescriptor classDescriptor, Persistence persistenceEngine) throws ClassNotFoundException, MappingException {
        ClassDescriptorJDONature nature;
        this._engine = lock;
        this._persistence = persistenceEngine;
        this._clsDesc = classDescriptor;
        this._name = classDescriptor.getJavaClass().getName();
        ds.register(this._name, this);
        if (classDescriptor.hasNature(ClassDescriptorJDONature.class.getName())) {
            nature = new ClassDescriptorJDONature((PropertyHolder)classDescriptor);
            this._accessMode = nature.getAccessMode();
        }
        this.dealWithExtendsAndDepends(ds, classDescriptor);
        if (classDescriptor.hasNature(ClassDescriptorJDONature.class.getName())) {
            nature = new ClassDescriptorJDONature((PropertyHolder)classDescriptor);
            this._cacheParams = nature.getCacheParams();
            this._isKeyGenUsed = nature.getKeyGeneratorDescriptor() != null;
        }
        FieldDescriptor[] identityDescriptors = ClassDescriptorHelper.getIdFields((ClassDescriptor)classDescriptor);
        this._ids = new FieldMolder[identityDescriptors.length];
        int m = 0;
        for (FieldDescriptor identityDescriptor : identityDescriptors) {
            this._ids[m++] = new FieldMolder(ds, this, identityDescriptor);
        }
        FieldDescriptor[] fieldDescriptors = ClassDescriptorHelper.getFullFields((ClassDescriptor)classDescriptor);
        int numberOfNonTransientFieldMolders = 0;
        for (FieldDescriptor fieldDescriptor : fieldDescriptors) {
            if (this.isFieldTransient(fieldDescriptor)) continue;
            ++numberOfNonTransientFieldMolders;
        }
        this._fhs = new FieldMolder[numberOfNonTransientFieldMolders];
        this._resolvers = new ResolverStrategy[numberOfNonTransientFieldMolders];
        int fieldMolderCount = 0;
        for (FieldDescriptor fieldDescriptor : fieldDescriptors) {
            if (this.isFieldTransient(fieldDescriptor)) continue;
            if (fieldDescriptor.hasNature(FieldDescriptorJDONature.class.getName()) && new FieldDescriptorJDONature((PropertyHolder)fieldDescriptor).getManyTable() != null) {
                String[] manyName;
                String[] manyKey;
                FieldDescriptorJDONature nature2 = new FieldDescriptorJDONature((PropertyHolder)fieldDescriptor);
                String[] relatedIdSQL = null;
                int[] relatedIdType = null;
                TypeConvertor[] relatedIdConvertTo = null;
                TypeConvertor[] relatedIdConvertFrom = null;
                String manyTable = nature2.getManyTable();
                String[] idSQL = new String[identityDescriptors.length];
                int[] idType = new int[identityDescriptors.length];
                TypeConvertor[] idConvertFrom = new TypeConvertor[identityDescriptors.length];
                TypeConvertor[] idConvertTo = new TypeConvertor[identityDescriptors.length];
                FieldDescriptor[] identityFieldDescriptors = ((ClassDescriptorImpl)classDescriptor).getIdentities();
                int identityFieldCount = 0;
                for (FieldDescriptor identityFieldDescriptor : identityFieldDescriptors) {
                    if (!identityFieldDescriptor.hasNature(FieldDescriptorJDONature.class.getName())) {
                        throw new MappingException("Identity type must contains sql information: " + this._name);
                    }
                    idSQL[identityFieldCount] = new FieldDescriptorJDONature((PropertyHolder)identityFieldDescriptor).getSQLName()[0];
                    int[] type = new FieldDescriptorJDONature((PropertyHolder)identityFieldDescriptor).getSQLType();
                    idType[identityFieldCount] = type == null ? 0 : type[0];
                    FieldHandlerImpl fieldHandler = (FieldHandlerImpl)identityFieldDescriptor.getHandler();
                    idConvertTo[identityFieldCount] = fieldHandler.getConvertTo();
                    idConvertFrom[identityFieldCount] = fieldHandler.getConvertFrom();
                    ++identityFieldCount;
                }
                ClassDescriptor relatedClassDescriptor = null;
                try {
                    JDOClassDescriptorResolver jdoCDR = (JDOClassDescriptorResolver)classDescriptorResolver;
                    relatedClassDescriptor = jdoCDR.resolve(fieldDescriptor.getFieldType().getName());
                }
                catch (ResolverException e) {
                    throw new MappingException("Problem resolving class descriptor for class " + fieldDescriptor.getClass().getName(), (Exception)((Object)e));
                }
                if (relatedClassDescriptor.hasNature(ClassDescriptorJDONature.class.getName())) {
                    FieldDescriptor[] relatedIdentityDescriptors = ((ClassDescriptorImpl)relatedClassDescriptor).getIdentities();
                    relatedIdSQL = new String[relatedIdentityDescriptors.length];
                    relatedIdType = new int[relatedIdentityDescriptors.length];
                    relatedIdConvertTo = new TypeConvertor[relatedIdentityDescriptors.length];
                    relatedIdConvertFrom = new TypeConvertor[relatedIdentityDescriptors.length];
                    int relatedIdentityCount = 0;
                    for (FieldDescriptor relatedIdentityDescriptor : relatedIdentityDescriptors) {
                        if (!relatedIdentityDescriptor.hasNature(FieldDescriptorJDONature.class.getName())) {
                            throw new MappingException("Field type is not persistence-capable: " + relatedIdentityDescriptors[relatedIdentityCount].getFieldName());
                        }
                        FieldDescriptorJDONature relatedNature = new FieldDescriptorJDONature((PropertyHolder)relatedIdentityDescriptor);
                        String[] tempId = relatedNature.getSQLName();
                        relatedIdSQL[relatedIdentityCount] = tempId == null ? null : tempId[0];
                        int[] tempType = relatedNature.getSQLType();
                        relatedIdType[relatedIdentityCount] = tempType == null ? 0 : tempType[0];
                        FieldHandlerImpl fh = (FieldHandlerImpl)relatedIdentityDescriptors[relatedIdentityCount].getHandler();
                        relatedIdConvertTo[relatedIdentityCount] = fh.getConvertTo();
                        relatedIdConvertFrom[relatedIdentityCount] = fh.getConvertFrom();
                        ++relatedIdentityCount;
                    }
                }
                if ((manyKey = nature2.getManyKey()) != null && manyKey.length != 0) {
                    if (manyKey.length != idSQL.length) {
                        throw new MappingException("The number of many-keys doesn't match referred object: " + classDescriptor.getJavaClass().getName());
                    }
                    idSQL = manyKey;
                }
                if ((manyName = nature2.getSQLName()) != null && manyName.length != 0) {
                    if (manyName.length != relatedIdSQL.length) {
                        throw new MappingException("The number of many-keys doesn't match referred object: " + relatedClassDescriptor.getJavaClass().getName());
                    }
                    relatedIdSQL = manyName;
                }
                SQLRelationLoader loader = this._persistence.createSQLRelationLoader(manyTable, idSQL, idType, idConvertTo, idConvertFrom, relatedIdSQL, relatedIdType, relatedIdConvertTo, relatedIdConvertFrom);
                this._fhs[fieldMolderCount] = new FieldMolder(ds, this, fieldDescriptor, loader);
            } else {
                this._fhs[fieldMolderCount] = new FieldMolder(ds, this, fieldDescriptor);
            }
            this._resolvers[fieldMolderCount] = ResolverFactory.createRelationResolver(this._fhs[fieldMolderCount], this, fieldMolderCount);
            ++fieldMolderCount;
        }
        if (Persistent.class.isAssignableFrom(ds.resolve(this._name))) {
            this._callback = new JDOCallback();
        }
    }

    private void dealWithExtendsAndDepends(DatingService ds, ClassDescriptor classDescriptor) throws MappingException {
        ClassDescriptor dependClassDescriptor = ((ClassDescriptorImpl)classDescriptor).getDepends();
        ClassDescriptor extendsClassDescriptor = ((ClassDescriptorImpl)classDescriptor).getExtends();
        if (dependClassDescriptor != null) {
            ds.pairDepends(this, dependClassDescriptor.getJavaClass().getName());
        }
        if (extendsClassDescriptor != null) {
            ds.pairExtends(this, extendsClassDescriptor.getJavaClass().getName());
        }
    }

    public ClassDescriptor getClassDescriptor() {
        return this._clsDesc;
    }

    private boolean isFieldTransient(FieldDescriptor fieldDescriptor) {
        boolean isFieldTransient = fieldDescriptor.isTransient();
        if (fieldDescriptor.hasNature(FieldDescriptorJDONature.class.getName())) {
            FieldDescriptorJDONature nature = new FieldDescriptorJDONature((PropertyHolder)fieldDescriptor);
            isFieldTransient |= nature.isTransient();
        }
        return isFieldTransient;
    }

    public boolean removeRelation(TransactionContext tx, Object object, ClassMolder relatedMolder, Object relatedObject) {
        boolean removed = false;
        boolean updateCache = false;
        boolean updatePersist = false;
        UpdateAndRemovedFlags flags = null;
        for (int i = 0; i < this._fhs.length; ++i) {
            flags = this._resolvers[i].removeRelation(tx, object, relatedMolder, relatedObject);
            updateCache |= flags.getUpdateCache();
            updatePersist |= flags.getUpdatePersist();
            removed |= flags.getRemoved();
        }
        tx.markModified(object, updatePersist, updateCache);
        return removed;
    }

    public int getPriority() {
        if (this._priority == -2) {
            return 0;
        }
        if (this._priority < 0) {
            ClassMolder root = this;
            while (root._extends != null) {
                root = root._extends;
            }
            List<ClassMolder> molders = this.getAllExtendentMolders(root);
            for (ClassMolder molder : molders) {
                molder._priority = -2;
            }
            int maxPriority = 0;
            for (ClassMolder molder : molders) {
                FieldMolder[] fhs = molder._fhs;
                for (int i = 0; i < fhs.length; ++i) {
                    FieldMolder fh = fhs[i];
                    if (!fh.isPersistanceCapable() || !fh.isStored() || fh.getFieldClassMolder() == this) continue;
                    int refPriority = fh.getFieldClassMolder().getPriority() + 1;
                    maxPriority = Math.max(maxPriority, refPriority);
                }
            }
            for (ClassMolder molder : molders) {
                molder._priority = maxPriority;
            }
        }
        return this._priority;
    }

    private List<ClassMolder> getAllExtendentMolders(ClassMolder root) {
        ArrayList<ClassMolder> molders = new ArrayList<ClassMolder>();
        molders.add(root);
        if (root._extendent != null) {
            for (ClassMolder extendent : root._extendent) {
                molders.addAll(this.getAllExtendentMolders(extendent));
            }
        }
        return molders;
    }

    public void loadTimeStamp(TransactionContext tx, DepositBox locker, AccessMode suggestedAccessMode) throws PersistenceException {
        Object loadObject = null;
        try {
            loadObject = this.newInstance(tx.getClassLoader());
        }
        catch (Exception ex) {
            throw new PersistenceException("failed to load object", ex);
        }
        ProposedEntity proposedObject = new ProposedEntity(this);
        proposedObject.setProposedEntityClass(loadObject.getClass());
        proposedObject.setEntity(loadObject);
        OID oid = locker.getOID();
        Object[] cachedFieldValues = locker.getObject(tx);
        proposedObject.setFields(cachedFieldValues);
        AccessMode accessMode = this.getAccessMode(suggestedAccessMode);
        if (!proposedObject.isFieldsSet() || accessMode == AccessMode.DbLocked) {
            proposedObject.initializeFields(this._fhs.length);
            Connection conn = tx.getConnection(oid.getMolder().getLockEngine());
            this._persistence.load(conn, proposedObject, oid.getIdentity(), accessMode);
            oid.setDbLock(accessMode == AccessMode.DbLocked);
            locker.setObject(tx, proposedObject.getFields(), System.currentTimeMillis());
        }
        this.mold(tx, locker, proposedObject, accessMode);
    }

    public void load(TransactionContext tx, DepositBox locker, ProposedEntity proposedObject, AccessMode accessMode, QueryResults results) throws PersistenceException {
        OID oid = locker.getOID();
        if (oid.getIdentity() == null) {
            throw new PersistenceException("The identities of the object to be loaded is null");
        }
        proposedObject.initializeFields(this._fhs.length);
        if (results != null) {
            results.getQuery().fetch(proposedObject);
        } else {
            Connection conn = tx.getConnection(oid.getMolder().getLockEngine());
            this._persistence.load(conn, proposedObject, oid.getIdentity(), accessMode);
        }
        oid.setDbLock(accessMode == AccessMode.DbLocked);
        locker.setObject(tx, proposedObject.getFields(), System.currentTimeMillis());
    }

    public void mold(TransactionContext tx, DepositBox locker, ProposedEntity proposedObject, AccessMode accessMode) throws PersistenceException {
        FieldHandler fieldHandler;
        FieldDescriptor versionFieldDescriptor;
        ClassDescriptorJDONature jdoNature;
        String versionField;
        OID oid = locker.getOID();
        if (this._clsDesc.hasNature(ClassDescriptorJDONature.class.getName()) && (versionField = (jdoNature = new ClassDescriptorJDONature((PropertyHolder)this._clsDesc)).getVersionField()) != null && versionField.length() > 0) {
            versionFieldDescriptor = jdoNature.getField(versionField);
            fieldHandler = versionFieldDescriptor.getHandler();
            fieldHandler.setValue(proposedObject.getEntity(), (Object)locker.getVersion());
        }
        if (proposedObject.getEntity() instanceof TimeStampable) {
            ((TimeStampable)proposedObject.getEntity()).jdoSetTimeStamp(locker.getVersion());
        }
        this.setIdentity(tx, proposedObject.getEntity(), oid.getIdentity());
        block3: for (int i = 0; i < this._fhs.length; ++i) {
            FieldPersistenceType fieldType = this._fhs[i].getFieldPertsistenceType();
            switch (fieldType) {
                case PRIMITIVE: 
                case SERIALIZABLE: 
                case PERSISTANCECAPABLE: 
                case ONE_TO_MANY: 
                case MANY_TO_MANY: {
                    this._resolvers[i].load(tx, oid, proposedObject, accessMode);
                    continue block3;
                }
                default: {
                    throw new PersistenceException("Unexpected field type!");
                }
            }
        }
        if (this._clsDesc.hasNature(ClassDescriptorJDONature.class.getName()) && (versionField = (jdoNature = new ClassDescriptorJDONature((PropertyHolder)this._clsDesc)).getVersionField()) != null && versionField.length() > 0) {
            versionFieldDescriptor = jdoNature.getField(versionField);
            fieldHandler = versionFieldDescriptor.getHandler();
            locker.setVersion((Long)fieldHandler.getValue(proposedObject.getEntity()));
        }
        if (proposedObject.getEntity() instanceof TimeStampable) {
            locker.setVersion(((TimeStampable)proposedObject.getEntity()).jdoGetTimeStamp());
        }
    }

    public Identity create(TransactionContext tx, OID oid, DepositBox locker, Object object) throws PersistenceException {
        ClassDescriptorJDONature jdoNature;
        String versionField;
        if (this._persistence == null) {
            throw new PersistenceException("non persistence capable: " + oid.getName());
        }
        ProposedEntity entity = new ProposedEntity();
        entity.initializeFields(this._fhs.length);
        Identity ids = oid.getIdentity();
        long timeStamp = System.currentTimeMillis();
        if (this._clsDesc.hasNature(ClassDescriptorJDONature.class.getName()) && (versionField = (jdoNature = new ClassDescriptorJDONature((PropertyHolder)this._clsDesc)).getVersionField()) != null && versionField.length() > 0) {
            FieldDescriptor versionFieldDescriptor = jdoNature.getField(versionField);
            FieldHandler fieldHandler = versionFieldDescriptor.getHandler();
            fieldHandler.setValue(object, (Object)timeStamp);
        }
        if (object instanceof TimeStampable) {
            ((TimeStampable)object).jdoSetTimeStamp(timeStamp);
        }
        block3: for (int i = 0; i < this._fhs.length; ++i) {
            FieldPersistenceType fieldPersistenceType = this._fhs[i].getFieldPertsistenceType();
            switch (fieldPersistenceType) {
                case PRIMITIVE: 
                case SERIALIZABLE: 
                case PERSISTANCECAPABLE: 
                case ONE_TO_MANY: 
                case MANY_TO_MANY: {
                    entity.setField(this._resolvers[i].create(tx, object), i);
                    continue block3;
                }
                default: {
                    throw new IllegalArgumentException("Field type invalid!");
                }
            }
        }
        Identity createdId = this._persistence.create(tx.getDatabase(), tx.getConnection(oid.getMolder().getLockEngine()), entity, ids);
        if (createdId == null) {
            throw new PersistenceException("Identity can't be created!");
        }
        locker.setObject(tx, entity.getFields(), timeStamp);
        oid.setDbLock(true);
        this.setIdentity(tx, object, createdId);
        for (int i = 0; i < this._fhs.length; ++i) {
            entity.setField(this._resolvers[i].postCreate(tx, oid, object, entity.getField(i), createdId), i);
        }
        return createdId;
    }

    public void markCreate(TransactionContext tx, OID oid, DepositBox locker, Object object) throws PersistenceException {
        boolean updateCache = false;
        for (int i = 0; i < this._fhs.length; ++i) {
            updateCache |= this._resolvers[i].markCreate(tx, oid, object);
        }
        tx.markModified(object, false, updateCache);
    }

    public boolean preStore(TransactionContext tx, OID oid, DepositBox locker, Object object, int timeout) throws PersistenceException {
        if (oid.getIdentity() == null) {
            throw new PersistenceException(Messages.format((String)"persist.missingIdentityForStore", (Object)this._name));
        }
        if (!oid.getIdentity().equals(this.getIdentity(tx, object))) {
            throw new PersistenceException(Messages.format((String)"jdo.identityChanged", (Object)this._name, (Object)oid.getIdentity(), (Object)this.getIdentity(tx, object)));
        }
        Object[] fields = locker.getObject(tx);
        if (fields == null) {
            throw new PersistenceException(Messages.format((String)"persist.objectNotFound", (Object)this._name, (Object)oid));
        }
        Object[] newfields = new Object[this._fhs.length];
        boolean updateCache = false;
        boolean updatePersist = false;
        for (int i = 0; i < newfields.length; ++i) {
            UpdateFlags flags = this._resolvers[i].preStore(tx, oid, object, timeout, fields[i]);
            updateCache |= flags.getUpdateCache();
            updatePersist |= flags.getUpdatePersist();
            newfields[i] = flags.getNewField();
        }
        tx.markModified(object, updatePersist, updateCache);
        if (updateCache || updatePersist) {
            tx.writeLock(object, timeout);
        }
        return updateCache;
    }

    public void store(TransactionContext tx, OID oid, DepositBox locker, Object object) throws PersistenceException {
        ClassDescriptorJDONature jdoNature;
        String versionField;
        if (oid.getIdentity() == null) {
            throw new PersistenceException(Messages.format((String)"persist.missingIdentityForStore", (Object)this._name));
        }
        if (!oid.getIdentity().equals(this.getIdentity(tx, object))) {
            throw new PersistenceException(Messages.format((String)"jdo.identityChanged", (Object)this._name, (Object)oid.getIdentity(), (Object)this.getIdentity(tx, object)));
        }
        ProposedEntity oldentity = new ProposedEntity();
        oldentity.setFields(locker.getObject(tx));
        if (oldentity.getFields() == null) {
            throw new PersistenceException(Messages.format((String)"persist.objectNotFound", (Object)this._name, (Object)oid));
        }
        long timeStamp = System.currentTimeMillis();
        if (this._clsDesc.hasNature(ClassDescriptorJDONature.class.getName()) && (versionField = (jdoNature = new ClassDescriptorJDONature((PropertyHolder)this._clsDesc)).getVersionField()) != null && versionField.length() > 0) {
            FieldDescriptor versionFieldDescriptor = jdoNature.getField(versionField);
            FieldHandler fieldHandler = versionFieldDescriptor.getHandler();
            fieldHandler.setValue(object, (Object)timeStamp);
        }
        if (object instanceof TimeStampable) {
            ((TimeStampable)object).jdoSetTimeStamp(timeStamp);
        }
        ProposedEntity newentity = new ProposedEntity();
        newentity.initializeFields(this._fhs.length);
        for (int i = 0; i < this._fhs.length; ++i) {
            newentity.setField(this._resolvers[i].store(tx, object, oldentity.getField(i)), i);
        }
        Connection conn = tx.getConnection(oid.getMolder().getLockEngine());
        String extendingTableName = null;
        ClassMolder molder = this;
        while (molder != null) {
            String tableName = new ClassDescriptorJDONature((PropertyHolder)molder.getClassDescriptor()).getTableName();
            if (!tableName.equals(extendingTableName)) {
                molder._persistence.store(conn, oid.getIdentity(), newentity, oldentity);
            }
            extendingTableName = tableName;
            molder = molder._extends;
        }
    }

    public boolean update(TransactionContext tx, OID oid, DepositBox locker, Object object, AccessMode suggestedAccessMode) throws PersistenceException {
        String versionField;
        AccessMode accessMode = this.getAccessMode(suggestedAccessMode);
        Object[] fields = locker.getObject(tx);
        boolean timeStampable = false;
        long objectTimestamp = 1L;
        if (object instanceof TimeStampable) {
            timeStampable = true;
            objectTimestamp = ((TimeStampable)object).jdoGetTimeStamp();
        }
        ClassDescriptorJDONature jdoNature = null;
        if (this._clsDesc.hasNature(ClassDescriptorJDONature.class.getName()) && (versionField = (jdoNature = new ClassDescriptorJDONature((PropertyHolder)this._clsDesc)).getVersionField()) != null && versionField.length() > 0) {
            objectTimestamp = this.getObjectVersion(versionField, jdoNature, object);
            timeStampable = true;
        }
        if (!this.isDependent() && !timeStampable) {
            throw new IllegalArgumentException("A master object that involves in a long transaction must be a TimeStampable!");
        }
        long lockTimestamp = locker.getVersion();
        if (objectTimestamp > 0L && oid.getIdentity() != null) {
            if (timeStampable && lockTimestamp == 0L) {
                throw new PersistenceException(Messages.format((String)"persist.objectNotInCache", (Object)this._name, (Object)oid.getIdentity()));
            }
            if (timeStampable && objectTimestamp != lockTimestamp) {
                throw new ObjectModifiedException("Timestamp mismatched!");
            }
            if (!timeStampable && this.isDependent() && fields == null) {
                fields = new Object[this._fhs.length];
                Connection conn = tx.getConnection(oid.getMolder().getLockEngine());
                ProposedEntity proposedObject = new ProposedEntity(this);
                proposedObject.setProposedEntityClass(object.getClass());
                proposedObject.setEntity(object);
                proposedObject.setFields(fields);
                this._persistence.load(conn, proposedObject, oid.getIdentity(), accessMode);
                fields = proposedObject.getFields();
                oid.setDbLock(accessMode == AccessMode.DbLocked);
                locker.setObject(tx, proposedObject.getFields(), System.currentTimeMillis());
            }
            try {
                for (int i = 0; i < this._fhs.length; ++i) {
                    this._resolvers[i].update(tx, oid, object, accessMode, fields[i]);
                }
            }
            catch (ObjectNotFoundException e) {
                _log.warn((Object)e.getMessage(), (Throwable)((Object)e));
                throw new ObjectModifiedException("dependent object deleted concurrently");
            }
            return false;
        }
        if (objectTimestamp == 0L || objectTimestamp == 1L) {
            boolean updateCache = false;
            for (int i = 0; i < this._fhs.length; ++i) {
                updateCache |= this._resolvers[i].updateWhenNoTimestampSet(tx, oid, object, suggestedAccessMode);
            }
            tx.markModified(object, false, updateCache);
            return true;
        }
        if (_log.isWarnEnabled()) {
            _log.warn((Object)("object: " + object + " timestamp: " + objectTimestamp + " lockertimestamp: " + lockTimestamp));
        }
        throw new ObjectModifiedException("Invalid object timestamp detected.");
    }

    private Long getObjectVersion(String versionField, ClassDescriptorJDONature jdoNature, Object object) {
        FieldDescriptor versionFieldDescriptor = jdoNature.getField(versionField);
        return (Long)versionFieldDescriptor.getHandler().getValue(object);
    }

    public void updateCache(TransactionContext tx, OID oid, DepositBox locker, Object object) {
        ClassDescriptorJDONature jdoNature;
        String versionField;
        if (oid.getIdentity() == null) {
            throw new IllegalStateException(Messages.format((String)"persist.missingIdentityForCacheUpdate", (Object)this._name));
        }
        Object[] fields = new Object[this._fhs.length];
        block3: for (int i = 0; i < this._fhs.length; ++i) {
            FieldPersistenceType fieldPersistenceType = this._fhs[i].getFieldPertsistenceType();
            switch (fieldPersistenceType) {
                case PRIMITIVE: 
                case SERIALIZABLE: 
                case PERSISTANCECAPABLE: 
                case ONE_TO_MANY: 
                case MANY_TO_MANY: {
                    fields[i] = this._resolvers[i].updateCache(tx, oid, object);
                    continue block3;
                }
                default: {
                    throw new IllegalArgumentException("Field type invalid!");
                }
            }
        }
        Long objectVersion = null;
        if (this._clsDesc.hasNature(ClassDescriptorJDONature.class.getName()) && (versionField = (jdoNature = new ClassDescriptorJDONature((PropertyHolder)this._clsDesc)).getVersionField()) != null && versionField.length() > 0) {
            objectVersion = this.getObjectVersion(versionField, jdoNature, object);
        }
        if (object instanceof TimeStampable) {
            locker.setObject(tx, fields, ((TimeStampable)object).jdoGetTimeStamp());
        } else if (objectVersion != null) {
            locker.setObject(tx, fields, objectVersion);
        } else {
            locker.setObject(tx, fields, System.currentTimeMillis());
        }
    }

    public void delete(TransactionContext tx, OID oid) throws PersistenceException {
        Connection conn = tx.getConnection(oid.getMolder().getLockEngine());
        Identity ids = oid.getIdentity();
        for (int i = 0; i < this._fhs.length; ++i) {
            if (!this._fhs[i].isManyToMany()) continue;
            this._fhs[i].getRelationLoader().deleteRelation(conn, ids);
        }
        Vector<ClassMolder> extendPath = new Vector<ClassMolder>();
        ClassMolder molder = this;
        while (molder != null) {
            molder._persistence.delete(conn, ids);
            extendPath.add(molder);
            molder = molder._extends;
        }
        ClassMolder base = this._depends;
        while (base != null) {
            if (base._extendent != null) {
                for (int i = 0; i < base._extendent.size(); ++i) {
                    if (!extendPath.contains(base._extendent.get(i))) continue;
                }
            }
            base = base._extends;
        }
    }

    public void markDelete(TransactionContext tx, OID oid, DepositBox locker, Object object) throws PersistenceException {
        Object[] fields = locker.getObject(tx);
        block3: for (int i = 0; i < this._fhs.length; ++i) {
            FieldPersistenceType fieldType = this._fhs[i].getFieldPertsistenceType();
            switch (fieldType) {
                case PRIMITIVE: 
                case SERIALIZABLE: 
                case PERSISTANCECAPABLE: 
                case ONE_TO_MANY: 
                case MANY_TO_MANY: {
                    this._resolvers[i].markDelete(tx, object, fields[i]);
                    continue block3;
                }
                default: {
                    throw new PersistenceException("Invalid field type!");
                }
            }
        }
    }

    public void revertObject(TransactionContext tx, OID oid, DepositBox locker, Object object) throws PersistenceException {
        if (oid.getIdentity() == null) {
            throw new PersistenceException(Messages.format((String)"persist.missingIdentityForReverting", (Object)this._name));
        }
        Object[] fields = locker.getObject(tx);
        this.setIdentity(tx, object, oid.getIdentity());
        for (int i = 0; i < this._fhs.length; ++i) {
            if (fields != null) {
                this._resolvers[i].revertObject(tx, oid, object, fields[i]);
                continue;
            }
            this._resolvers[i].revertObject(tx, oid, object, null);
        }
    }

    public Object newInstance(ClassLoader loader) throws InstantiationException, IllegalAccessException, ClassNotFoundException {
        Class<?> aClass = null;
        aClass = ClassLoadingUtils.loadClass(loader, this._name);
        return aClass.newInstance();
    }

    public AccessMode getAccessMode(AccessMode txMode) {
        if (txMode == null) {
            return this._accessMode;
        }
        if (this._accessMode == AccessMode.ReadOnly || txMode == AccessMode.ReadOnly) {
            return AccessMode.ReadOnly;
        }
        if (this._accessMode == AccessMode.DbLocked || txMode == AccessMode.DbLocked) {
            return AccessMode.DbLocked;
        }
        if (this._accessMode == AccessMode.Exclusive || txMode == AccessMode.Exclusive) {
            return AccessMode.Exclusive;
        }
        return txMode;
    }

    public CallbackInterceptor getCallback() {
        return this._callback;
    }

    public boolean isDefaultIdentity(Identity identity) {
        if (identity == null) {
            return true;
        }
        for (int i = 0; i < identity.size(); ++i) {
            if (this._ids[i].isDefault(identity.get(i))) continue;
            return false;
        }
        return true;
    }

    public Identity getIdentity(TransactionContext tx, Object o) {
        if (this.isKeyGeneratorUsed() && !tx.isPersistent(o) && !tx.isReadOnly(o)) {
            return null;
        }
        return this.getActualIdentity(tx, o);
    }

    public Identity getActualIdentity(TransactionContext tx, Object o) {
        return this.getActualIdentity(tx.getClassLoader(), o);
    }

    public Identity getActualIdentity(ClassLoader loader, Object o) {
        Object[] ids = new Object[this._ids.length];
        for (int i = 0; i < ids.length; ++i) {
            ids[i] = this._ids[i].getValue(o, loader);
        }
        if (ids[0] == null) {
            return null;
        }
        return new Identity(ids);
    }

    public void setIdentity(TransactionContext tx, Object object, Identity identity) throws PersistenceException {
        if (identity.size() != this._ids.length) {
            throw new PersistenceException("Identity size mismatched!");
        }
        for (int i = 0; i < this._ids.length; ++i) {
            this._ids[i].setValue(object, identity.get(i), tx.getClassLoader());
        }
    }

    public Persistence getPersistence() {
        return this._persistence;
    }

    public Class<?> getJavaClass(ClassLoader loader) {
        Class<?> result = null;
        try {
            result = ClassLoadingUtils.loadClass(loader, this._name);
        }
        catch (ClassNotFoundException e) {
            _log.error((Object)("Unable to load base class of " + this.getName()), (Throwable)e);
        }
        return result;
    }

    public boolean isAssignableFrom(Class<?> cls) {
        ClassLoader loader = cls.getClassLoader();
        Class<?> molderClass = null;
        try {
            molderClass = ClassLoadingUtils.loadClass(loader, this._name);
        }
        catch (ClassNotFoundException e) {
            return false;
        }
        return molderClass.isAssignableFrom(cls);
    }

    public String getName() {
        return this._name;
    }

    public ClassMolder getExtends() {
        return this._extends;
    }

    public ClassMolder getDepends() {
        return this._depends;
    }

    public LockEngine getLockEngine() {
        return this._engine;
    }

    public Properties getCacheParams() {
        return this._cacheParams;
    }

    public boolean isDependent() {
        return this._depends != null;
    }

    void addExtendent(ClassMolder ext) {
        if (this._extendent == null) {
            this._extendent = new Vector();
        }
        this._extendent.add(ext);
    }

    void addDependent(ClassMolder dep) {
        if (this._dependent == null) {
            this._dependent = new Vector();
        }
        this._dependent.add(dep);
    }

    void setExtends(ClassMolder ext) {
        this._extends = ext;
        ext.addExtendent(this);
    }

    void setDepends(ClassMolder dep) {
        this._depends = dep;
        dep.addDependent(this);
    }

    public String toString() {
        return "ClassMolder " + this._name;
    }

    public boolean isKeyGenUsed() {
        return this._isKeyGenUsed;
    }

    public boolean isKeyGeneratorUsed() {
        return this._isKeyGenUsed || this._extends != null && this._extends.isKeyGeneratorUsed();
    }

    public void expireCache(TransactionContext tx, ObjectLock locker) throws PersistenceException {
        Object[] fields = locker.getObject();
        if (fields == null) {
            return;
        }
        for (int i = 0; i < this._fhs.length; ++i) {
            this._resolvers[i].expireCache(tx, fields[i]);
        }
    }

    public void resetResolvers() {
        if (!this._resolversHaveBeenReset) {
            for (int i = 0; i < this._fhs.length; ++i) {
                this._resolvers[i] = ResolverFactory.createRelationResolver(this._fhs[i], this, i);
            }
            this._resolversHaveBeenReset = true;
        }
    }

    public String getNamedQuery(String name) {
        return new ClassDescriptorJDONature((PropertyHolder)this._clsDesc).getNamedQueries().get(name);
    }

    public NamedNativeQuery getNamedNativeQuery(String name) {
        return new ClassDescriptorJDONature((PropertyHolder)this._clsDesc).getNamedNativeQueries().get(name);
    }
}

