/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.castor.persist;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.castor.core.util.Messages;
import org.castor.persist.TransactionContext;
import org.exolab.castor.jdo.LockNotGrantedException;
import org.exolab.castor.persist.DepositBox;
import org.exolab.castor.persist.OID;
import org.exolab.castor.persist.ObjectDeletedWaitingForLockException;

public final class ObjectLock
implements DepositBox {
    private static final Log LOG = LogFactory.getFactory().getInstance(ObjectLock.class);
    protected static final short ACTION_READ = 1;
    protected static final short ACTION_WRITE = 2;
    protected static final short ACTION_CREATE = 3;
    protected static final short ACTION_UPDATE = 4;
    private static final int[] LOCK = new int[0];
    private static int _idcount = 0;
    private int _id;
    private Object[] _object;
    private OID _oid;
    private TransactionContext _writeLock;
    private LinkedTx _readLock;
    private LinkedTx _readWaiting;
    private int _waitCount;
    private LinkedTx _writeWaiting;
    private TransactionContext _confirmWaiting;
    private short _confirmWaitingAction;
    private int _gateCount;
    private long _version;
    private boolean _deleted;
    private boolean _invalidated;
    private boolean _isExpired;
    private Object[] _expiredObject;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ObjectLock(OID oid) {
        this._oid = oid;
        int[] nArray = LOCK;
        synchronized (LOCK) {
            this._id = _idcount++;
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    public ObjectLock(OID oid, Object[] object, long version) {
        this(oid);
        this._object = object;
        this._version = version;
    }

    public OID getOID() {
        return this._oid;
    }

    void setOID(OID oid) {
        this._oid = oid;
    }

    void enter() {
        ++this._gateCount;
    }

    void leave() {
        --this._gateCount;
    }

    boolean isEntered() {
        return this._gateCount != 0;
    }

    boolean isDisposable() {
        return this._gateCount == 0 && this.isFree() && this._waitCount == 0;
    }

    boolean hasLock(TransactionContext tx, boolean write) {
        if (this._writeLock == tx) {
            return true;
        }
        if (this._confirmWaiting == tx) {
            if (this._confirmWaitingAction == 2 || this._confirmWaitingAction == 3) {
                return true;
            }
            return !write && this._confirmWaitingAction == 1;
        }
        if (write) {
            return false;
        }
        LinkedTx read = this._readLock;
        while (read != null) {
            if (read._tx == tx) {
                return true;
            }
            read = read._next;
        }
        return false;
    }

    boolean isFree() {
        return this._writeLock == null && this._readLock == null && this._writeWaiting == null && this._readWaiting == null && this._confirmWaiting == null && this._waitCount == 0;
    }

    boolean isExclusivelyOwned(TransactionContext tx) {
        if (this._writeLock == null && this._readLock == null) {
            return false;
        }
        if (this._writeLock == null && this._readLock._tx == tx && this._readLock._next._tx == null) {
            return true;
        }
        return this._writeLock == tx && this._readLock == null;
    }

    boolean isExpired() {
        return this._isExpired;
    }

    public Object[] getObject() {
        if (this._expiredObject != null && this._object == null) {
            return this._expiredObject;
        }
        return this._object;
    }

    public void expire() {
        this._isExpired = true;
    }

    public void expired() {
        this._isExpired = false;
        this._expiredObject = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    synchronized void acquireLoadLock(TransactionContext tx, boolean write, int timeout) throws LockNotGrantedException {
        int internalTimeout = timeout;
        long endtime = internalTimeout > 0 ? System.currentTimeMillis() + (long)(internalTimeout * 1000) : Long.MAX_VALUE;
        while (true) {
            Object var11_11;
            block27: {
                block30: {
                    block29: {
                        block28: {
                            try {
                                if (this._deleted) {
                                    throw new ObjectDeletedWaitingForLockException("Object deleted");
                                }
                                if (this._confirmWaiting != null) {
                                    Object var9_10;
                                    try {
                                        try {
                                            ++this._waitCount;
                                            this.wait();
                                        }
                                        catch (InterruptedException e) {
                                            throw new LockNotGrantedException("Thread interrupted acquiring lock!", e);
                                        }
                                        var9_10 = null;
                                        --this._waitCount;
                                        break block27;
                                    }
                                    catch (Throwable throwable) {
                                        var9_10 = null;
                                        --this._waitCount;
                                        throw throwable;
                                    }
                                }
                                if (this._writeLock == tx) {
                                    var11_11 = null;
                                    this.removeWaiting(tx);
                                    tx.setWaitOnLock(null);
                                    return;
                                }
                                if (this._readLock == null && this._writeLock == null && write) {
                                    this._confirmWaiting = tx;
                                    this._confirmWaitingAction = (short)2;
                                    break block28;
                                }
                                if (this._readLock == null && this._writeLock == null && !write) {
                                    if (this._object == null) {
                                        this._confirmWaiting = tx;
                                        this._confirmWaitingAction = 1;
                                        break block29;
                                    }
                                    this._readLock = new LinkedTx(tx, null);
                                    break block30;
                                }
                                if (this._readLock != null && !write) {
                                    LinkedTx linked = this._readLock;
                                    while (linked != null) {
                                        if (linked._tx == tx) {
                                            throw new IllegalStateException("Transaction: " + tx + " has already hold the write lock on " + this._oid + " Acquire shouldn't be called twice");
                                        }
                                        linked = linked._next;
                                    }
                                    this._readLock = new LinkedTx(tx, this._readLock);
                                    var11_11 = null;
                                    this.removeWaiting(tx);
                                    tx.setWaitOnLock(null);
                                    return;
                                }
                                if (internalTimeout == 0) {
                                    String string;
                                    if (LOG.isDebugEnabled()) {
                                        LOG.debug((Object)("Timeout on " + this.toString() + " by " + tx));
                                    }
                                    StringBuilder stringBuilder = new StringBuilder();
                                    if (write) {
                                        string = "persist.writeLockTimeout";
                                        throw new LockNotGrantedException(stringBuilder.append(string).append(this._oid).append("/").append(this._id).append(" by ").append(tx).toString());
                                    }
                                    string = "persist.readLockTimeout";
                                    throw new LockNotGrantedException(stringBuilder.append(string).append(this._oid).append("/").append(this._id).append(" by ").append(tx).toString());
                                }
                                if (LOG.isDebugEnabled()) {
                                    LOG.debug((Object)("Waiting on " + this.toString() + " by " + tx));
                                }
                                tx.setWaitOnLock(this);
                                this.detectDeadlock(tx, 10);
                                if (write) {
                                    this._writeWaiting = new LinkedTx(tx, this._writeWaiting);
                                } else {
                                    this._readWaiting = new LinkedTx(tx, this._readWaiting);
                                }
                                try {
                                    long waittime = endtime - System.currentTimeMillis();
                                    this.wait(waittime < 0L ? 0L : waittime);
                                }
                                catch (InterruptedException except) {
                                    String string;
                                    StringBuilder stringBuilder = new StringBuilder();
                                    if (write) {
                                        string = "persist.writeLockTimeout";
                                        throw new LockNotGrantedException(stringBuilder.append(string).append(this._oid).append("/").append(this._id).append(" by ").append(tx).toString(), except);
                                    }
                                    string = "persist.readLockTimeout";
                                    throw new LockNotGrantedException(stringBuilder.append(string).append(this._oid).append("/").append(this._id).append(" by ").append(tx).toString(), except);
                                }
                                if (this._deleted) {
                                    throw new ObjectDeletedWaitingForLockException("object deleted" + this._oid + "/" + this._id + " by " + tx);
                                }
                                if (System.currentTimeMillis() > endtime) {
                                    internalTimeout = 0;
                                }
                                this.removeWaiting(tx);
                                tx.setWaitOnLock(null);
                                break block27;
                            }
                            catch (Throwable throwable) {
                                var11_11 = null;
                                this.removeWaiting(tx);
                                tx.setWaitOnLock(null);
                                throw throwable;
                            }
                        }
                        var11_11 = null;
                        this.removeWaiting(tx);
                        tx.setWaitOnLock(null);
                        return;
                    }
                    var11_11 = null;
                    this.removeWaiting(tx);
                    tx.setWaitOnLock(null);
                    return;
                }
                var11_11 = null;
                this.removeWaiting(tx);
                tx.setWaitOnLock(null);
                return;
            }
            var11_11 = null;
            this.removeWaiting(tx);
            tx.setWaitOnLock(null);
        }
    }

    synchronized void acquireCreateLock(TransactionContext tx) throws LockNotGrantedException {
        while (this._deleted || this._confirmWaiting != null) {
            Object var4_2;
            try {
                try {
                    ++this._waitCount;
                    this.wait();
                    while (this._deleted) {
                        this.wait();
                    }
                    var4_2 = null;
                    --this._waitCount;
                }
                catch (InterruptedException e) {
                    throw new LockNotGrantedException("Thread interrupted acquiring lock!", e);
                }
            }
            catch (Throwable throwable) {
                var4_2 = null;
                --this._waitCount;
                throw throwable;
            }
        }
        if (this._readLock != null || this._writeLock != null) {
            throw new LockNotGrantedException("Lock already exist!");
        }
        this._confirmWaiting = tx;
        this._confirmWaitingAction = (short)3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    synchronized void acquireUpdateLock(TransactionContext tx, int timeout) throws LockNotGrantedException {
        int internalTimeout = timeout;
        long endtime = internalTimeout > 0 ? System.currentTimeMillis() + (long)(internalTimeout * 1000) : Long.MAX_VALUE;
        while (true) {
            Object var10_9;
            block17: {
                block18: {
                    try {
                        if (this._deleted || this._confirmWaiting != null) {
                            Object var8_8;
                            try {
                                try {
                                    ++this._waitCount;
                                    this.wait();
                                }
                                catch (InterruptedException e) {
                                    throw new LockNotGrantedException("Thread interrupted acquiring lock!", e);
                                }
                                var8_8 = null;
                                --this._waitCount;
                                break block17;
                            }
                            catch (Throwable throwable) {
                                var8_8 = null;
                                --this._waitCount;
                                throw throwable;
                            }
                        }
                        if (this._writeLock == tx) {
                            var10_9 = null;
                            this.removeWaiting(tx);
                            tx.setWaitOnLock(null);
                            return;
                        }
                        if (this._writeLock == null && this._readLock == null) {
                            this._confirmWaiting = tx;
                            this._confirmWaitingAction = (short)4;
                            break block18;
                        }
                        if (internalTimeout == 0) {
                            if (LOG.isDebugEnabled()) {
                                LOG.debug((Object)("Timeout on " + this.toString() + " by " + tx));
                            }
                            throw new LockNotGrantedException(Messages.message((String)"persist.writeLockTimeout"));
                        }
                        if (LOG.isDebugEnabled()) {
                            LOG.debug((Object)("Waiting on " + this.toString() + " by " + tx));
                        }
                        tx.setWaitOnLock(this);
                        this.detectDeadlock(tx, 10);
                        this._writeWaiting = new LinkedTx(tx, this._writeWaiting);
                        try {
                            long waittime = endtime - System.currentTimeMillis();
                            this.wait(waittime < 0L ? 0L : waittime);
                        }
                        catch (InterruptedException except) {
                            throw new LockNotGrantedException(Messages.message((String)"persist.writeLockTimeout") + this._oid + "/" + this._id + " by " + tx, except);
                        }
                        if (this._deleted) {
                            throw new ObjectDeletedWaitingForLockException("Object deleted " + this._oid + "/" + this._id + " by " + tx);
                        }
                        if (System.currentTimeMillis() > endtime) {
                            internalTimeout = 0;
                        }
                        this.removeWaiting(tx);
                        tx.setWaitOnLock(null);
                        break block17;
                    }
                    catch (Throwable throwable) {
                        var10_9 = null;
                        this.removeWaiting(tx);
                        tx.setWaitOnLock(null);
                        throw throwable;
                    }
                }
                var10_9 = null;
                this.removeWaiting(tx);
                tx.setWaitOnLock(null);
                return;
            }
            var10_9 = null;
            this.removeWaiting(tx);
            tx.setWaitOnLock(null);
        }
    }

    public synchronized void setObject(TransactionContext tx, Object[] object, long version) {
        this._isExpired = false;
        this._expiredObject = null;
        if (this._confirmWaiting != null && this._confirmWaiting == tx) {
            this._version = version;
            this._object = object;
            if (this._confirmWaitingAction == 1) {
                this._readLock = new LinkedTx(tx, null);
            } else {
                this._writeLock = tx;
            }
            this._confirmWaiting = null;
            this.notifyAll();
        } else if (this._writeLock != null && this._writeLock == tx) {
            this._version = version;
            this._object = object;
        } else {
            throw new IllegalArgumentException("Transaction tx does not own this lock, " + this.toString() + "!");
        }
    }

    public synchronized Object[] getObject(TransactionContext tx) {
        if (this._confirmWaiting != null && this._confirmWaiting == tx) {
            return this._object;
        }
        if (this._writeLock != null && this._writeLock == tx) {
            return this._object;
        }
        LinkedTx link = this._readLock;
        while (link != null) {
            if (link._tx == tx) {
                return this._object;
            }
            link = link._next;
        }
        throw new IllegalArgumentException("Transaction tx does not own this lock!");
    }

    public synchronized long getVersion() {
        return this._version;
    }

    public synchronized void setVersion(long version) {
        this._version = version;
    }

    synchronized void confirm(TransactionContext tx, boolean succeed) {
        if (this._confirmWaiting == tx) {
            if (succeed) {
                if (this._confirmWaitingAction == 1) {
                    if (this._readLock == null) {
                        this._readLock = new LinkedTx(tx, null);
                    }
                } else {
                    this._writeLock = tx;
                }
            }
            this._confirmWaiting = null;
            this.notifyAll();
        } else if (this._confirmWaiting == null) {
            if (!succeed) {
                if (this._writeLock != null) {
                    this._deleted = true;
                    this._object = null;
                    this._version = System.currentTimeMillis();
                    this.notifyAll();
                } else if (this._readLock != null) {
                    if (this._readLock._tx == tx) {
                        this._readLock = this._readLock._next;
                    } else {
                        LinkedTx link = this._readLock;
                        while (link != null) {
                            if (link._next != null && link._next._tx == tx) {
                                link._next = link._next._next;
                                this.notifyAll();
                                return;
                            }
                            link = link._next;
                        }
                    }
                }
            }
            this.notifyAll();
        } else {
            throw new IllegalStateException("Confirm transaction does not match the locked transaction");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    synchronized void upgrade(TransactionContext tx, int timeout) throws LockNotGrantedException {
        int internalTimeout = timeout;
        if (this._confirmWaiting != null) {
            IllegalStateException e = new IllegalStateException("Internal error: acquire when confirmWaiting is not null");
            throw e;
        }
        if (!this.hasLock(tx, false)) {
            IllegalStateException e = new IllegalStateException("Transaction didn't previously acquire this lock");
            throw e;
        }
        long endtime = internalTimeout > 0 ? System.currentTimeMillis() + (long)(internalTimeout * 1000) : Long.MAX_VALUE;
        while (true) {
            Object var9_9;
            block16: {
                block15: {
                    try {
                        if (this._writeLock == tx) {
                            var9_9 = null;
                            this.removeWaiting(tx);
                            tx.setWaitOnLock(null);
                            return;
                        }
                        if (this._writeLock == null && this._readLock._tx == tx && this._readLock._next == null) {
                            if (LOG.isDebugEnabled()) {
                                LOG.debug((Object)("Acquired on " + this.toString() + " by " + tx));
                            }
                            this._writeLock = tx;
                            this._readLock = null;
                            break block15;
                        }
                        if (internalTimeout == 0) {
                            if (LOG.isDebugEnabled()) {
                                LOG.debug((Object)("Timeout on " + this.toString() + " by " + tx));
                            }
                            throw new LockNotGrantedException("persist.writeTimeout" + this._oid + "/" + this._id + " by " + tx);
                        }
                        if (LOG.isDebugEnabled()) {
                            LOG.debug((Object)("Waiting on " + this.toString() + " by " + tx));
                        }
                        tx.setWaitOnLock(this);
                        this.detectDeadlock(tx, 10);
                        this._writeWaiting = new LinkedTx(tx, this._writeWaiting);
                        try {
                            long waittime = endtime - System.currentTimeMillis();
                            this.wait(waittime < 0L ? 0L : waittime);
                        }
                        catch (InterruptedException except) {
                            throw new LockNotGrantedException("persist.writeLockTimeout", except);
                        }
                        if (this._deleted) {
                            throw new IllegalStateException("internal error: object deleted" + this._oid + "/" + this._id + " by " + tx);
                        }
                        if (System.currentTimeMillis() > endtime) {
                            internalTimeout = 0;
                        }
                        this.removeWaiting(tx);
                        tx.setWaitOnLock(null);
                        break block16;
                    }
                    catch (Throwable throwable) {
                        var9_9 = null;
                        this.removeWaiting(tx);
                        tx.setWaitOnLock(null);
                        throw throwable;
                    }
                }
                var9_9 = null;
                this.removeWaiting(tx);
                tx.setWaitOnLock(null);
                return;
            }
            var9_9 = null;
            this.removeWaiting(tx);
            tx.setWaitOnLock(null);
        }
    }

    synchronized void release(TransactionContext tx) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Release " + this.toString() + " by " + tx));
        }
        try {
            tx.setWaitOnLock(null);
            if (this._writeLock == tx) {
                this._writeLock = null;
                if (this._invalidated || this._deleted) {
                    this._version = System.currentTimeMillis();
                    if (this._isExpired) {
                        this._expiredObject = this._object;
                    }
                    this._object = null;
                }
                this._deleted = false;
                this._invalidated = false;
            } else if (this._readLock != null) {
                if (this._readLock._tx == tx) {
                    this._readLock = this._readLock._next;
                } else {
                    LinkedTx read = this._readLock;
                    while (read != null) {
                        if (read._next != null && read._next._tx == tx) {
                            read._next = read._next._next;
                            break;
                        }
                        read = read._next;
                    }
                    if (read == null) {
                        throw new IllegalStateException(Messages.message((String)"persist.notOwnerLock") + this._oid + "/" + this._id + " by " + tx);
                    }
                }
            } else {
                throw new IllegalStateException(Messages.message((String)"persist.notOwnerLock") + this._oid + "/" + this._id + " by " + tx);
            }
            this.notifyAll();
        }
        catch (ThreadDeath death) {
            this.release(tx);
            throw death;
        }
    }

    synchronized void delete(TransactionContext tx) {
        if (tx != this._writeLock) {
            throw new IllegalStateException(Messages.message((String)"persist.notOwnerLock") + " oid:" + this._oid + "/" + this._id + " by " + tx);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Delete " + this.toString() + " by " + tx));
        }
        try {
            this._deleted = true;
            this._object = null;
            this.notifyAll();
        }
        catch (ThreadDeath death) {
            this.release(tx);
            throw death;
        }
    }

    synchronized void invalidate(TransactionContext tx) {
        if (tx != this._writeLock) {
            throw new IllegalStateException(Messages.message((String)"persist.notOwnerLock") + " oid:" + this._oid + "/" + this._id + " by " + tx);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Delete " + this.toString() + " by " + tx));
        }
        this._invalidated = true;
    }

    private void detectDeadlock(TransactionContext waitingTx, int numOfRec) throws LockNotGrantedException {
        if (numOfRec <= 0) {
            return;
        }
        if (this._writeLock != null) {
            ObjectLock waitOn = this._writeLock.getWaitOnLock();
            if (waitOn != null) {
                if (waitOn._writeLock == waitingTx) {
                    throw new LockNotGrantedException(Messages.message((String)"persist.deadlock"));
                }
                LinkedTx read = waitOn._readLock;
                while (read != null) {
                    if (read._tx == waitingTx) {
                        throw new LockNotGrantedException(Messages.message((String)"persist.deadlock"));
                    }
                    read = read._next;
                }
                waitOn.detectDeadlock(waitingTx, numOfRec - 1);
            }
        } else {
            LinkedTx lock = this._readLock;
            while (lock != null) {
                ObjectLock waitOn = lock._tx.getWaitOnLock();
                if (waitOn != null && lock._tx != waitingTx) {
                    if (waitOn._writeLock == waitingTx) {
                        throw new LockNotGrantedException(Messages.message((String)"persist.deadlock"));
                    }
                    LinkedTx read = waitOn._readLock;
                    while (read != null) {
                        if (read._tx == waitingTx) {
                            throw new LockNotGrantedException(Messages.message((String)"persist.deadlock"));
                        }
                        read = read._next;
                    }
                    waitOn.detectDeadlock(waitingTx, numOfRec - 1);
                }
                lock = lock._next;
            }
        }
    }

    private void removeWaiting(TransactionContext tx) {
        try {
            LinkedTx wait;
            if (this._writeWaiting != null) {
                if (this._writeWaiting._tx == tx) {
                    this._writeWaiting = this._writeWaiting._next;
                } else {
                    wait = this._writeWaiting;
                    while (wait._next != null) {
                        if (wait._next._tx == tx) {
                            wait._next = wait._next._next;
                            break;
                        }
                        wait = wait._next;
                    }
                }
            }
            if (this._readWaiting != null) {
                if (this._readWaiting._tx == tx) {
                    this._readWaiting = this._readWaiting._next;
                } else {
                    wait = this._readWaiting;
                    while (wait._next != null) {
                        if (wait._next._tx == tx) {
                            wait._next = wait._next._next;
                            break;
                        }
                        wait = wait._next;
                    }
                }
            }
            if (this._deleted && this._readWaiting == null && this._writeWaiting == null && this._confirmWaiting == null) {
                this._deleted = false;
            }
        }
        catch (ThreadDeath death) {
            this.removeWaiting(tx);
            throw death;
        }
    }

    public String toString() {
        return this._oid.toString() + "/" + this._id + " " + (this._readLock == null ? "-" : "R") + "/" + (this._writeLock == null ? "-" : "W");
    }

    static class LinkedTx {
        private TransactionContext _tx;
        private LinkedTx _next;

        LinkedTx(TransactionContext tx, LinkedTx next) {
            this._tx = tx;
            this._next = next;
        }
    }
}

