/*
 * Copyright 2010 Werner Guttmann
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.castor.cpa.persistence.sql.keygen;

import java.util.Properties;

import org.exolab.castor.mapping.MappingException;
import org.exolab.castor.persist.spi.PersistenceFactory;

/**
 * JPA-specific TABLE key generator factory. The short name of this key generator is "TABLE".
 * <br/>
 *
 * @see TableKeyGenerator
 * @author <a href="mailto:wguttmn AT codehaus DOT org">Werner Guttmann</a>
 * @version $Revision: 8994 $ $Date: 2011-08-02 01:40:59 +0200 (Di, 02 Aug 2011) $
 * @since 1.3.2
 */
public class TableKeyGeneratorFactory implements KeyGeneratorFactory {
    //-----------------------------------------------------------------------------------
    
    /**
     * Short name of this key generator factory. 
     */
    public static final String NAME = "TABLE";
    
    //-----------------------------------------------------------------------------------
    
    public String getKeyGeneratorName() {
        return NAME;
    }

    public KeyGenerator getKeyGenerator(final PersistenceFactory factory,
            final Properties params, final int sqlType) throws MappingException {
        return new TableKeyGenerator(factory, params, sqlType);
    }
    
    //-----------------------------------------------------------------------------------
}
