/*
 * Copyright 2008 Udai Gupta, Ralf Joachim
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.castor.cpa.query.object.literal;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;

/**
 * Final immutable class that represents a time literal.
 * 
 * @author <a href="mailto:mailtoud AT gmail DOT com">Udai Gupta</a>
 * @author <a href="mailto:ralf DOT joachim AT syscon DOT eu">Ralf Joachim</a>
 * @version $Revision: 8994 $ $Date: 2011-08-02 01:40:59 +0200 (Di, 02 Aug 2011) $
 * @since 1.3
 */
public final class TimeLiteral extends AbstractTemporalLiteral {
    //--------------------------------------------------------------------------

    /** Date format for time literal. */
    private static final DateFormat DF = new SimpleDateFormat("HH:mm:ss.SSS");
    
    //--------------------------------------------------------------------------
    
    /**
     * Construct a time literal with given date.
     * 
     * @param value Date value for the time literal.
     */
    public TimeLiteral(final Date value) {
        super(value);
    }
    
    /**
     * Construct a time literal with given calendar.
     * 
     * @param value Calendar value for the time literal.
     */
    public TimeLiteral(final Calendar value) {
        super(value);
    }

    //--------------------------------------------------------------------------
    
    /**
     * {@inheritDoc}
     */
    public StringBuilder toString(final StringBuilder sb) {
        return sb.append("TIME '").append(DF.format(getValue())).append('\'');
    }

    //--------------------------------------------------------------------------
}
