/*
 * Decompiled with CFR 0.152.
 */
package org.castor.cache;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.castor.cache.Cache;
import org.castor.cache.CacheAcquireException;
import org.castor.cache.CacheFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractCacheFactory<K, V>
implements CacheFactory<K, V> {
    private static final Log LOG = LogFactory.getLog(AbstractCacheFactory.class);
    private boolean _initialized = false;

    protected final boolean isInitialized() {
        return this._initialized;
    }

    @Override
    public final synchronized Cache<K, V> getCache(ClassLoader classLoader) throws CacheAcquireException {
        ClassLoader loader = classLoader;
        if (loader == null) {
            loader = Thread.currentThread().getContextClassLoader();
        }
        Cache cache = null;
        try {
            cache = (Cache)loader.loadClass(this.getCacheClassName()).newInstance();
        }
        catch (Exception e) {
            String msg = "Error creating cache instance of: " + this.getCacheClassName();
            LOG.error((Object)msg, (Throwable)e);
            throw new CacheAcquireException(msg, e);
        }
        this._initialized = true;
        return cache;
    }

    @Override
    public void shutdown() {
    }
}

