/*
 * Decompiled with CFR 0.152.
 */
package org.castor.cache;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.castor.cache.Cache;
import org.castor.cache.CacheAcquireException;
import org.castor.cache.CacheFactory;
import org.castor.cache.DebuggingCacheProxy;
import org.castor.core.util.AbstractProperties;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class CacheFactoryRegistry<K, V> {
    private static final Log LOG = LogFactory.getLog(CacheFactoryRegistry.class);
    private static final String PROXY_CLASSNAME = DebuggingCacheProxy.class.getName();
    private HashMap<String, CacheFactory<K, V>> _cacheFactories = new HashMap();

    public CacheFactoryRegistry(AbstractProperties properties) {
        Object[] objects = properties.getObjectArray("org.castor.cache.Factories", properties.getApplicationClassLoader());
        for (int i = 0; i < objects.length; ++i) {
            CacheFactory factory = (CacheFactory)objects[i];
            this._cacheFactories.put(factory.getCacheType(), factory);
        }
    }

    public Cache<K, V> getCache(Properties props, ClassLoader classLoader) throws CacheAcquireException {
        String cacheType = props.getProperty("type", "count-limited");
        CacheFactory<K, V> cacheFactory = this._cacheFactories.get(cacheType);
        if (cacheFactory == null) {
            LOG.error((Object)("Unknown cache type '" + cacheType + "'"));
            throw new CacheAcquireException("Unknown cache type '" + cacheType + "'");
        }
        Cache cache = cacheFactory.getCache(classLoader);
        String prop = props.getProperty("debug", "false");
        boolean objectDebug = Boolean.valueOf(prop);
        boolean cacheDebug = LogFactory.getLog(Cache.class).isDebugEnabled();
        boolean cacheTypeDebug = LogFactory.getLog(cache.getClass()).isDebugEnabled();
        if (cacheTypeDebug || cacheDebug && objectDebug) {
            try {
                ClassLoader loader = CacheFactoryRegistry.class.getClassLoader();
                Class<?> cls = loader.loadClass(PROXY_CLASSNAME);
                Class[] types = new Class[]{Cache.class};
                Object[] params = new Object[]{cache};
                cache = (Cache)cls.getConstructor(types).newInstance(params);
            }
            catch (Exception e) {
                String msg = "Error creating instance of: " + PROXY_CLASSNAME;
                LOG.error((Object)msg, (Throwable)e);
                throw new CacheAcquireException(msg, e);
            }
        }
        cache.initialize(props);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Successfully instantiated '" + cacheType + "' cache: " + props.get("name")));
        }
        return cache;
    }

    public Collection<CacheFactory<K, V>> getCacheFactories() {
        return Collections.unmodifiableCollection(this._cacheFactories.values());
    }

    public Collection<String> getCacheNames() {
        return Collections.unmodifiableCollection(this._cacheFactories.keySet());
    }
}

