/*
 * Decompiled with CFR 0.152.
 */
package org.castor.cache;

import java.util.Collection;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.castor.cache.Cache;
import org.castor.cache.CacheAcquireException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class DebuggingCacheProxy<K, V>
implements Cache<K, V> {
    private Cache<K, V> _cache;
    private Log _log;

    public DebuggingCacheProxy(Cache<K, V> cache) {
        this._cache = cache;
    }

    @Override
    public void initialize(Properties params) throws CacheAcquireException {
        this._cache.initialize(params);
        this._log = LogFactory.getLog(this._cache.getClass());
        this._log.debug((Object)(this.getType() + ".initialize() [" + this.getName() + "]"));
    }

    @Override
    public void close() {
        this._log.debug((Object)(this.getType() + ".close() [" + this.getName() + "]"));
        this._cache.close();
    }

    @Override
    public String getType() {
        return this._cache.getType();
    }

    @Override
    public String getName() {
        return this._cache.getName();
    }

    @Override
    public void expire(Object key) {
        this._log.debug((Object)(this.getType() + ".expire(" + key + ") [" + this.getName() + "]"));
        this._cache.expire(key);
    }

    @Override
    public void expireAll() {
        this._log.debug((Object)(this.getType() + ".expireAll() [" + this.getName() + "]"));
        this._cache.expireAll();
    }

    @Override
    public int size() {
        this._log.debug((Object)(this.getType() + ".size() [" + this.getName() + "]"));
        return this._cache.size();
    }

    @Override
    public boolean isEmpty() {
        this._log.debug((Object)(this.getType() + ".isEmpty() [" + this.getName() + "]"));
        return this._cache.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        this._log.debug((Object)(this.getType() + ".containsKey(" + key + ") [" + this.getName() + "]"));
        return this._cache.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        this._log.debug((Object)(this.getType() + ".containsValue(" + value + ") [" + this.getName() + "]"));
        return this._cache.containsValue(value);
    }

    @Override
    public V get(Object key) {
        this._log.debug((Object)(this.getType() + ".get(" + key + ") [" + this.getName() + "]"));
        return this._cache.get(key);
    }

    @Override
    public V put(K key, V value) {
        this._log.debug((Object)(this.getType() + ".put(" + key + ", " + value + ") [" + this.getName() + "]"));
        return this._cache.put(key, value);
    }

    @Override
    public V remove(Object key) {
        this._log.debug((Object)(this.getType() + ".remove(" + key + ") [" + this.getName() + "]"));
        return this._cache.remove(key);
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> map) {
        this._log.debug((Object)(this.getType() + ".putAll(" + map + ") [" + this.getName() + "]"));
        this._cache.putAll(map);
    }

    @Override
    public void clear() {
        this._log.debug((Object)(this.getType() + ".clear() [" + this.getName() + "]"));
        this._cache.clear();
    }

    @Override
    public Set<K> keySet() {
        this._log.debug((Object)(this.getType() + ".keySet() [" + this.getName() + "]"));
        return this._cache.keySet();
    }

    @Override
    public Collection<V> values() {
        this._log.debug((Object)(this.getType() + ".values() [" + this.getName() + "]"));
        return this._cache.values();
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        this._log.debug((Object)(this.getType() + ".entrySet() [" + this.getName() + "]"));
        return this._cache.entrySet();
    }
}

