/*
 * Decompiled with CFR 0.152.
 */
package org.castor.cache.distributed;

import java.lang.reflect.Method;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.castor.cache.AbstractCacheFactory;
import org.castor.cache.distributed.GigaspacesCache;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class GigaspacesCacheFactory<K, V>
extends AbstractCacheFactory<K, V> {
    private static final Log LOG = LogFactory.getLog(GigaspacesCacheFactory.class);

    @Override
    public String getCacheType() {
        return "gigaspaces";
    }

    @Override
    public String getCacheClassName() {
        return GigaspacesCache.class.getName();
    }

    @Override
    public void shutdown() {
        this.shutdown("com.j_spaces.map.CacheFinder");
    }

    public void shutdown(String implementation) {
        if (!this.isInitialized()) {
            return;
        }
        try {
            ClassLoader ldr = this.getClass().getClassLoader();
            Class<?> cls = ldr.loadClass(implementation);
            if (cls != null) {
                Method method = cls.getMethod("shutdown", null);
                method.invoke(null, (Object[])null);
            }
        }
        catch (Exception e) {
            LOG.error((Object)"Problem shutting down Gigaspaces cluster member", (Throwable)e);
        }
    }
}

