/*
 * Decompiled with CFR 0.152.
 */
package org.castor.cache.distributed;

import java.util.Map;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.castor.cache.CacheAcquireException;
import org.castor.cache.distributed.AbstractDistributedCache;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class JCache<K, V>
extends AbstractDistributedCache<K, V> {
    private static final Log LOG = LogFactory.getLog(JCache.class);
    public static final String TYPE = "jcache";
    public static final String IMPLEMENTATION = "javax.util.jcache.CacheAccessFactory";
    private static final Class<?>[] TYPES_GET_MAP_ACCESS = new Class[]{String.class};

    @Override
    public void initialize(Properties params) throws CacheAcquireException {
        this.initialize(IMPLEMENTATION, params);
    }

    public void initialize(String implementation, Properties params) throws CacheAcquireException {
        super.initialize(params);
        try {
            ClassLoader ldr = this.getClass().getClassLoader();
            Class<?> cls = ldr.loadClass(implementation);
            Object factory = this.invokeStaticMethod(cls, "getInstance", null, null);
            this.setCache((Map)this.invokeMethod(factory, "getMapAccess", TYPES_GET_MAP_ACCESS, new Object[]{this.getName()}));
        }
        catch (Exception e) {
            String msg = "Error creating JCache cache: " + e.getMessage();
            LOG.error((Object)msg, (Throwable)e);
            throw new CacheAcquireException(msg, e);
        }
    }

    @Override
    public String getType() {
        return TYPE;
    }
}

