/*
 * Decompiled with CFR 0.152.
 */
package org.castor.cache.distributed;

import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.castor.cache.CacheAcquireException;
import org.castor.cache.distributed.AbstractDistributedCache;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class JcsCache<K, V>
extends AbstractDistributedCache<K, V> {
    private static final Log LOG = LogFactory.getLog(JcsCache.class);
    public static final String TYPE = "jcs";
    public static final String IMPLEMENTATION = "org.apache.jcs.JCS";
    private static final Class<?>[] TYPES_GET_INSTANCE = new Class[]{String.class};
    private static final Class<?>[] TYPES_GET = new Class[]{Object.class};
    private static final Class<?>[] TYPES_PUT = new Class[]{Object.class, Object.class};
    private static final Class<?>[] TYPES_REMOVE = TYPES_GET;
    private Object _cache;
    private Method _getMethod;
    private Method _putMethod;
    private Method _removeMethod;
    private Method _clearMethod;

    @Override
    public void initialize(Properties params) throws CacheAcquireException {
        this.initialize(IMPLEMENTATION, params);
    }

    public void initialize(String implementation, Properties params) throws CacheAcquireException {
        super.initialize(params);
        try {
            ClassLoader ldr = this.getClass().getClassLoader();
            Class<?> cls = ldr.loadClass(implementation);
            Method method = cls.getMethod("getInstance", TYPES_GET_INSTANCE);
            this._cache = method.invoke(null, this.getName());
            cls = this._cache.getClass();
            this._getMethod = cls.getMethod("get", TYPES_GET);
            this._putMethod = cls.getMethod("put", TYPES_PUT);
            this._removeMethod = cls.getMethod("remove", TYPES_REMOVE);
            this._clearMethod = cls.getMethod("clear", null);
        }
        catch (Exception e) {
            String msg = "Error creating JCS cache: " + e.getMessage();
            LOG.error((Object)msg, (Throwable)e);
            throw new CacheAcquireException(msg, e);
        }
    }

    @Override
    public String getType() {
        return TYPE;
    }

    @Override
    public int size() {
        throw new UnsupportedOperationException("size()");
    }

    @Override
    public boolean isEmpty() {
        throw new UnsupportedOperationException("isEmpty()");
    }

    @Override
    public boolean containsKey(Object key) {
        return this.get(key) != null;
    }

    @Override
    public boolean containsValue(Object value) {
        throw new UnsupportedOperationException("containsValue(Object)");
    }

    @Override
    public V get(Object key) {
        return (V)this.invokeCacheMethod(this._getMethod, new Object[]{key});
    }

    @Override
    public V put(K key, V value) {
        V oldValue = this.get(key);
        this.invokeCacheMethod(this._putMethod, new Object[]{key, value});
        return oldValue;
    }

    @Override
    public V remove(Object key) {
        V oldValue = this.get(key);
        this.invokeCacheMethod(this._removeMethod, new Object[]{key});
        return oldValue;
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> map) {
        for (Map.Entry<K, V> entry : map.entrySet()) {
            Object[] params = new Object[]{entry.getKey(), entry.getValue()};
            this.invokeCacheMethod(this._putMethod, params);
        }
    }

    @Override
    public void clear() {
        this.invokeCacheMethod(this._clearMethod, null);
    }

    @Override
    public Set<K> keySet() {
        throw new UnsupportedOperationException("keySet()");
    }

    @Override
    public Collection<V> values() {
        throw new UnsupportedOperationException("values()");
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        throw new UnsupportedOperationException("entrySet()");
    }

    private Object invokeCacheMethod(Method method, Object[] arguments) {
        try {
            return method.invoke(this._cache, arguments);
        }
        catch (Exception e) {
            String msg = "Failed to call method on JCS instance: " + e.getMessage();
            LOG.error((Object)msg, (Throwable)e);
            throw new IllegalStateException(e.getMessage());
        }
    }
}

