/*
 * Decompiled with CFR 0.152.
 */
package org.castor.cache.hashbelt;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.castor.cache.AbstractBaseCache;
import org.castor.cache.CacheAcquireException;
import org.castor.cache.hashbelt.container.Container;
import org.castor.cache.hashbelt.container.MapContainer;
import org.castor.cache.hashbelt.reaper.AbstractReaper;
import org.castor.cache.hashbelt.reaper.NullReaper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractHashbelt<K, V>
extends AbstractBaseCache<K, V> {
    private static final Log LOG = LogFactory.getLog(AbstractHashbelt.class);
    public static final String PARAM_CONTAINERS = "containers";
    public static final String PARAM_CONTAINER_CLASS = "container-class";
    public static final String PARAM_REAPER_CLASS = "reaper-class";
    public static final String PARAM_CAPACITY = "capacity";
    public static final String PARAM_TTL = "ttl";
    public static final String PARAM_MONITOR = "monitor";
    public static final int DEFAULT_CONTAINERS = 10;
    public static final Class<? extends Container> DEFAULT_CONTAINER_CLASS = MapContainer.class;
    public static final Class<? extends AbstractReaper> DEFAULT_REAPER_CLASS = NullReaper.class;
    public static final int DEFAULT_CAPACITY = 0;
    public static final int DEFAULT_TTL = 60;
    public static final int DEFAULT_MONITOR = 0;
    private static final long ONE_SECOND = 1000L;
    private static final long ONE_MINUTE = 60000L;
    private final ReentrantReadWriteLock _lock = new ReentrantReadWriteLock();
    private ArrayList<Container<K, V>> _cache = new ArrayList();
    private ArrayList<Container<K, V>> _pool = new ArrayList();
    private int _poolCount;
    private int _cacheCapacity;
    private int _cacheSize = 0;
    private int _containerTarget;
    private int _containerCount = 0;
    private int _containerCapacity;
    private int _ttl;
    private AbstractReaper<K, V> _reaper;
    private int _monitor;
    private Timer _expirationTimer;
    private Timer _monitoringTimer;

    @Override
    public final void initialize(Properties params) throws CacheAcquireException {
        Class<Object> cls;
        String param;
        super.initialize(params);
        try {
            param = params.getProperty(PARAM_CONTAINERS);
            if (param != null) {
                this._containerTarget = Integer.parseInt(param);
            }
            if (this._containerTarget <= 0) {
                this._containerTarget = 10;
            }
        }
        catch (NumberFormatException ex) {
            this._containerTarget = 10;
        }
        try {
            cls = DEFAULT_CONTAINER_CLASS;
            param = params.getProperty(PARAM_CONTAINER_CLASS);
            if (param != null && !"".equals(param)) {
                cls = Class.forName(param);
            }
            this._poolCount = 2 * this._containerTarget;
            for (int i = 0; i < this._poolCount; ++i) {
                this._pool.add(cls.newInstance());
            }
        }
        catch (Exception ex) {
            String msg = "Failed to instantiate hashbelt container.";
            throw new CacheAcquireException(msg, ex);
        }
        try {
            cls = DEFAULT_REAPER_CLASS;
            param = params.getProperty(PARAM_REAPER_CLASS);
            if (param != null && !"".equals(param)) {
                cls = Class.forName(param);
            }
            this._reaper = (AbstractReaper)cls.newInstance();
            this._reaper.setCache(this);
        }
        catch (Exception ex) {
            String msg = "Failed to instantiate hashbelt reaper.";
            throw new CacheAcquireException(msg, ex);
        }
        try {
            param = params.getProperty(PARAM_CAPACITY);
            if (param != null) {
                this._cacheCapacity = Integer.parseInt(param);
            }
            if (this._cacheCapacity < 0) {
                this._cacheCapacity = 0;
            }
        }
        catch (NumberFormatException ex) {
            this._cacheCapacity = 0;
        }
        int minCapacity = 2 * this._containerTarget;
        if (this._cacheCapacity > 0 && this._cacheCapacity < minCapacity) {
            this._cacheCapacity = minCapacity;
        }
        this._containerCapacity = this._cacheCapacity / this._containerTarget;
        try {
            param = params.getProperty(PARAM_TTL);
            if (param != null) {
                this._ttl = Integer.parseInt(param);
            }
            if (this._ttl < 0) {
                this._ttl = 60;
            }
        }
        catch (NumberFormatException ex) {
            this._ttl = 60;
        }
        if (this._ttl > 0) {
            long periode = (long)this._ttl * 1000L / (long)this._containerTarget;
            this._expirationTimer = new Timer(true);
            this._expirationTimer.schedule(new ExpirationTask(this), periode, periode);
        }
        try {
            param = params.getProperty(PARAM_MONITOR);
            if (param != null) {
                this._monitor = Integer.parseInt(param);
            }
            if (this._monitor < 0) {
                this._monitor = 0;
            }
        }
        catch (NumberFormatException ex) {
            this._monitor = 0;
        }
        if (this._monitor > 0) {
            long periode = (long)this._monitor * 60000L;
            this._monitoringTimer = new Timer(true);
            this._monitoringTimer.schedule(new MonitoringTask(this), periode, periode);
        }
    }

    @Override
    public final void close() {
        if (this._monitoringTimer != null) {
            this._monitoringTimer.cancel();
            this._monitoringTimer = null;
        }
        this._monitor = 0;
        if (this._expirationTimer != null) {
            this._expirationTimer.cancel();
            this._expirationTimer = null;
        }
        this._ttl = 0;
        this.clear();
        this._containerCapacity = 0;
        this._cacheCapacity = 0;
        this._reaper = null;
        this._poolCount = 0;
        this._pool = null;
        this._containerTarget = 0;
        super.close();
    }

    public final int getCapacity() {
        return this._cacheCapacity;
    }

    public final int getTTL() {
        return this._ttl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final int size() {
        try {
            this._lock.readLock().lock();
            int n = this._cacheSize;
            Object var3_2 = null;
            this._lock.readLock().unlock();
            return n;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this._lock.readLock().unlock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final boolean isEmpty() {
        try {
            this._lock.readLock().lock();
            boolean bl = this._cacheSize == 0;
            Object var3_2 = null;
            this._lock.readLock().unlock();
            return bl;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this._lock.readLock().unlock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public final boolean containsKey(Object key) {
        boolean bl;
        if (key == null) {
            throw new NullPointerException("key");
        }
        this._lock.readLock().lock();
        try {
            for (int i = 0; i < this._containerCount; ++i) {
                if (!this._cache.get(i).containsKey(key)) continue;
                boolean bl2 = true;
                Object var5_4 = null;
                this._lock.readLock().unlock();
                return bl2;
            }
            bl = false;
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            this._lock.readLock().unlock();
            throw throwable;
        }
        Object var5_5 = null;
        this._lock.readLock().unlock();
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public final boolean containsValue(Object value) {
        boolean bl;
        if (value == null) {
            throw new NullPointerException("value");
        }
        this._lock.readLock().lock();
        try {
            for (int i = 0; i < this._containerCount; ++i) {
                if (!this._cache.get(i).containsValue(value)) continue;
                boolean bl2 = true;
                Object var5_4 = null;
                this._lock.readLock().unlock();
                return bl2;
            }
            bl = false;
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            this._lock.readLock().unlock();
            throw throwable;
        }
        Object var5_5 = null;
        this._lock.readLock().unlock();
        return bl;
    }

    @Override
    public final void clear() {
        this._lock.writeLock().lock();
        while (this._containerCount > 0) {
            this.expireCacheContainer();
        }
        this._lock.writeLock().unlock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final Set<K> keySet() {
        this._lock.readLock().lock();
        try {
            HashSet set = new HashSet(this._cacheSize);
            for (int i = 0; i < this._containerCount; ++i) {
                set.addAll(this._cache.get(i).keySet());
            }
            HashSet hashSet = set;
            Object var4_4 = null;
            this._lock.readLock().unlock();
            return hashSet;
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            this._lock.readLock().unlock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final Collection<V> values() {
        this._lock.readLock().lock();
        try {
            ArrayList col = new ArrayList(this._cacheSize);
            for (int i = 0; i < this._containerCount; ++i) {
                col.addAll(this._cache.get(i).values());
            }
            ArrayList arrayList = col;
            Object var4_4 = null;
            this._lock.readLock().unlock();
            return arrayList;
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            this._lock.readLock().unlock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final Set<Map.Entry<K, V>> entrySet() {
        this._lock.readLock().lock();
        try {
            HashMap map = new HashMap(this._cacheSize);
            for (int i = 0; i < this._containerCount; ++i) {
                map.putAll(this._cache.get(i));
            }
            Set set = map.entrySet();
            Object var4_4 = null;
            this._lock.readLock().unlock();
            return set;
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            this._lock.readLock().unlock();
            throw throwable;
        }
    }

    protected final ReentrantReadWriteLock lock() {
        return this._lock;
    }

    protected final V getObjectFromCache(Object key) {
        for (int i = 0; i < this._containerCount; ++i) {
            Object result = this._cache.get(i).get(key);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    protected final V putObjectIntoCache(K key, V value) {
        V result;
        if (this._containerCount == 0 || this._cacheCapacity > 0 && this._cache.get(0).size() >= this._containerCapacity) {
            this.addCacheContainer();
        }
        if ((result = this._cache.get(0).put(key, value)) != null) {
            return result;
        }
        for (int i = 1; i < this._containerCount && result == null; ++i) {
            result = this._cache.get(i).remove(key);
        }
        if (result != null) {
            return null;
        }
        ++this._cacheSize;
        if (this._cacheCapacity > 0) {
            while (this._cacheCapacity < this._cacheSize) {
                this.expireCacheContainer();
            }
        }
        return result;
    }

    protected final V removeObjectFromCache(Object key) {
        for (int i = 0; i < this._containerCount; ++i) {
            Object result = this._cache.get(i).remove(key);
            if (result == null) continue;
            --this._cacheSize;
            return result;
        }
        return null;
    }

    private void recalcCacheSize() {
        int size = 0;
        for (int i = 0; i < this._containerCount; ++i) {
            size += this._cache.get(i).size();
        }
        this._cacheSize = size;
    }

    private void addCacheContainer() {
        Container<K, V> temp = this._pool.get(--this._poolCount);
        this._cache.add(0, temp);
        ++this._containerCount;
    }

    private void expireCacheContainer() {
        Container<K, V> expired = this._cache.get(--this._containerCount);
        this._cache.remove(expired);
        this._cacheSize -= expired.size();
        this._reaper.handleExpiredContainer(expired);
        expired.clear();
        this._pool.set(this._poolCount++, expired);
    }

    private void timeoutCacheContainers() {
        long timeout = System.currentTimeMillis() - (long)this._ttl;
        while (this._containerCount > 0 && this._cache.get(this._containerCount - 1).getTimestamp() <= timeout) {
            this.expireCacheContainer();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class MonitoringTask<K, V>
    extends TimerTask {
        private AbstractHashbelt<K, V> _owner;

        public MonitoringTask(AbstractHashbelt<K, V> owner) {
            this._owner = owner;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                try {
                    ((AbstractHashbelt)this._owner)._lock.readLock().lockInterruptibly();
                    LOG.info((Object)("Cache '" + this._owner.getName() + "' " + "currently holds " + ((AbstractHashbelt)this._owner)._containerCount + " containers " + "with " + ((AbstractHashbelt)this._owner)._cacheSize + " objects."));
                }
                catch (ThreadDeath t) {
                    LOG.debug((Object)("Stopping monitoring thread: " + this._owner.getName()));
                    throw t;
                }
                catch (Throwable t) {
                    LOG.error((Object)("Caught exception during monitoring: " + this._owner.getName()), t);
                    if (t instanceof VirtualMachineError) {
                        throw (VirtualMachineError)t;
                    }
                    Object var3_2 = null;
                    ((AbstractHashbelt)this._owner)._lock.readLock().unlock();
                }
                Object var3_1 = null;
                ((AbstractHashbelt)this._owner)._lock.readLock().unlock();
            }
            catch (Throwable throwable) {
                Object var3_3 = null;
                ((AbstractHashbelt)this._owner)._lock.readLock().unlock();
                throw throwable;
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ExpirationTask<K, V>
    extends TimerTask {
        private AbstractHashbelt<K, V> _owner;

        public ExpirationTask(AbstractHashbelt<K, V> owner) {
            this._owner = owner;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                try {
                    ((AbstractHashbelt)this._owner)._lock.writeLock().lockInterruptibly();
                    ((AbstractHashbelt)this._owner).timeoutCacheContainers();
                    ((AbstractHashbelt)this._owner).addCacheContainer();
                    ((AbstractHashbelt)this._owner).recalcCacheSize();
                }
                catch (ThreadDeath t) {
                    LOG.debug((Object)("Stopping expiration thread: " + this._owner.getName()));
                    throw t;
                }
                catch (Throwable t) {
                    LOG.error((Object)("Caught exception during expiration: " + this._owner.getName()), t);
                    if (t instanceof VirtualMachineError) {
                        throw (VirtualMachineError)t;
                    }
                    Object var3_2 = null;
                    ((AbstractHashbelt)this._owner)._lock.writeLock().unlock();
                }
                Object var3_1 = null;
                ((AbstractHashbelt)this._owner)._lock.writeLock().unlock();
            }
            catch (Throwable throwable) {
                Object var3_3 = null;
                ((AbstractHashbelt)this._owner)._lock.writeLock().unlock();
                throw throwable;
            }
        }
    }
}

