/*
 * Decompiled with CFR 0.152.
 */
package org.castor.cache.hashbelt.container;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.castor.cache.hashbelt.container.Container;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class FastIteratingContainer<K, V>
implements Container<K, V> {
    private Map<K, V> _container = new HashMap();
    private List<K> _keys = new ArrayList<K>();
    private List<V> _values = new ArrayList<V>();
    private long _timestamp = 0L;

    @Override
    public void updateTimestamp() {
        this._timestamp = System.currentTimeMillis();
    }

    @Override
    public long getTimestamp() {
        return this._timestamp;
    }

    @Override
    public Iterator<K> keyIterator() {
        return this._keys.iterator();
    }

    @Override
    public Iterator<V> valueIterator() {
        return this._values.iterator();
    }

    @Override
    public int size() {
        return this._container.size();
    }

    @Override
    public boolean isEmpty() {
        return this._container.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        return this._container.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this._container.containsValue(value);
    }

    @Override
    public V get(Object key) {
        return this._container.get(key);
    }

    @Override
    public V put(K key, V value) {
        if (value == null) {
            throw new IllegalArgumentException();
        }
        V oldValue = this._container.put(key, value);
        if (oldValue == null) {
            this._keys.add(key);
            this._values.add(value);
        } else if (oldValue != value) {
            this._values.remove(oldValue);
            this._values.add(value);
        }
        return oldValue;
    }

    @Override
    public V remove(Object key) {
        V oldValue = this._container.remove(key);
        if (oldValue != null) {
            this._keys.remove(key);
            this._values.remove(oldValue);
        }
        return oldValue;
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> map) {
        for (Map.Entry<K, V> entry : map.entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public void clear() {
        this._container.clear();
        this._keys.clear();
        this._values.clear();
    }

    @Override
    public Set<K> keySet() {
        return this._container.keySet();
    }

    @Override
    public Collection<V> values() {
        return this._container.values();
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return this._container.entrySet();
    }
}

