/*
 * Decompiled with CFR 0.152.
 */
package org.castor.cache.hashbelt.container;

import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.castor.cache.hashbelt.container.Container;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class WeakReferenceContainer<K, V>
implements Container<K, V> {
    private HashMap<K, WeakReference<V>> _container = new HashMap();
    private final ReentrantReadWriteLock _lock = new ReentrantReadWriteLock();
    private long _timestamp = 0L;

    @Override
    public void updateTimestamp() {
        this._timestamp = System.currentTimeMillis();
    }

    @Override
    public long getTimestamp() {
        return this._timestamp;
    }

    @Override
    public Iterator<K> keyIterator() {
        return new ArrayList<K>(this.keySet()).iterator();
    }

    @Override
    public Iterator<V> valueIterator() {
        return this.values().iterator();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int size() {
        try {
            this._lock.readLock().lock();
            int n = this._container.size();
            Object var3_2 = null;
            this._lock.readLock().unlock();
            return n;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this._lock.readLock().unlock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isEmpty() {
        try {
            this._lock.readLock().lock();
            boolean bl = this._container.isEmpty();
            Object var3_2 = null;
            this._lock.readLock().unlock();
            return bl;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this._lock.readLock().unlock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean containsKey(Object key) {
        try {
            this._lock.readLock().lock();
            boolean bl = this._container.containsKey(key);
            Object var4_3 = null;
            this._lock.readLock().unlock();
            return bl;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this._lock.readLock().unlock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean containsValue(Object value) {
        boolean bl;
        try {
            this._lock.writeLock().lock();
            Iterator<Map.Entry<K, WeakReference<V>>> iter = this._container.entrySet().iterator();
            while (iter.hasNext()) {
                Map.Entry<K, WeakReference<V>> entry = iter.next();
                WeakReference<V> ref = entry.getValue();
                Object found = ref.get();
                if (found != null) {
                    if (!found.equals(value)) continue;
                    boolean bl2 = true;
                    Object var8_8 = null;
                    this._lock.writeLock().unlock();
                    return bl2;
                }
                iter.remove();
            }
            bl = false;
        }
        catch (Throwable throwable) {
            Object var8_10 = null;
            this._lock.writeLock().unlock();
            throw throwable;
        }
        Object var8_9 = null;
        this._lock.writeLock().unlock();
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V get(Object key) {
        block5: {
            WeakReference<V> ref;
            block4: {
                V v;
                try {
                    this._lock.writeLock().lock();
                    ref = this._container.get(key);
                    if (ref != null) break block4;
                    v = null;
                    Object var6_5 = null;
                    this._lock.writeLock().unlock();
                }
                catch (Throwable throwable) {
                    Object var6_8 = null;
                    this._lock.writeLock().unlock();
                    throw throwable;
                }
                return v;
            }
            Object found = ref.get();
            if (found == null) break block5;
            Object t = found;
            Object var6_6 = null;
            this._lock.writeLock().unlock();
            return (V)t;
        }
        this._container.remove(key);
        V v = null;
        Object var6_7 = null;
        this._lock.writeLock().unlock();
        return v;
    }

    @Override
    public V put(K key, V value) {
        this._lock.writeLock().lock();
        WeakReference<V> ref = this._container.put(key, new WeakReference<V>(value));
        this._lock.writeLock().unlock();
        if (ref == null) {
            return null;
        }
        Object found = ref.get();
        if (found != null) {
            return (V)found;
        }
        return null;
    }

    @Override
    public V remove(Object key) {
        this._lock.writeLock().lock();
        WeakReference<V> ref = this._container.remove(key);
        this._lock.writeLock().unlock();
        if (ref == null) {
            return null;
        }
        Object found = ref.get();
        if (found != null) {
            return (V)found;
        }
        return null;
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> map) {
        this._lock.writeLock().lock();
        for (Map.Entry<K, V> entry : map.entrySet()) {
            this._container.put(entry.getKey(), new WeakReference<V>(entry.getValue()));
        }
        this._lock.writeLock().unlock();
    }

    @Override
    public void clear() {
        this._lock.writeLock().lock();
        this._container.clear();
        this._lock.writeLock().unlock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<K> keySet() {
        try {
            this._lock.readLock().lock();
            Set<K> set = this._container.keySet();
            Object var3_2 = null;
            this._lock.readLock().unlock();
            return set;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this._lock.readLock().unlock();
            throw throwable;
        }
    }

    @Override
    public Collection<V> values() {
        ArrayList col = new ArrayList();
        this._lock.writeLock().lock();
        Iterator<Map.Entry<K, WeakReference<V>>> iter = this._container.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry<K, WeakReference<V>> entry = iter.next();
            WeakReference<V> ref = entry.getValue();
            Object found = ref.get();
            if (found != null) {
                col.add(found);
                continue;
            }
            iter.remove();
        }
        this._lock.writeLock().unlock();
        return col;
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        HashMap map = new HashMap();
        this._lock.writeLock().lock();
        Iterator<Map.Entry<K, WeakReference<V>>> iter = this._container.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry<K, WeakReference<V>> entry = iter.next();
            WeakReference<V> ref = entry.getValue();
            Object found = ref.get();
            if (found != null) {
                map.put(entry.getKey(), found);
                continue;
            }
            iter.remove();
        }
        this._lock.writeLock().unlock();
        return map.entrySet();
    }
}

