/*
 * Decompiled with CFR 0.152.
 */
package org.castor.cache.simple;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.castor.cache.AbstractBaseCache;
import org.castor.cache.CacheAcquireException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class CountLimited<K, V>
extends AbstractBaseCache<K, V> {
    public static final String TYPE = "count-limited";
    public static final String PARAM_CAPACITY = "capacity";
    public static final int DEFAULT_CAPACITY = 30;
    private static final int LRU_OLD = 0;
    private static final int LRU_NEW = 1;
    private HashMap<K, Integer> _mapKeyPos = null;
    private K[] _keys = null;
    private V[] _values = null;
    private int[] _status = null;
    private int _capacity = 30;
    private int _cur = 0;
    private final ReentrantReadWriteLock _lock = new ReentrantReadWriteLock();

    @Override
    public void initialize(Properties params) throws CacheAcquireException {
        super.initialize(params);
        String param = params.getProperty(PARAM_CAPACITY);
        try {
            if (param != null) {
                this._capacity = Integer.parseInt(param);
            }
            if (this._capacity <= 0) {
                this._capacity = 30;
            }
        }
        catch (NumberFormatException ex) {
            this._capacity = 30;
        }
        this._mapKeyPos = new HashMap(this._capacity);
        this._keys = new Object[this._capacity];
        this._values = new Object[this._capacity];
        this._status = new int[this._capacity];
    }

    @Override
    public String getType() {
        return TYPE;
    }

    public int getCapacity() {
        return this._capacity;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int size() {
        try {
            this._lock.readLock().lock();
            int n = this._mapKeyPos.size();
            Object var3_2 = null;
            this._lock.readLock().unlock();
            return n;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this._lock.readLock().unlock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isEmpty() {
        try {
            this._lock.readLock().lock();
            boolean bl = this._mapKeyPos.isEmpty();
            Object var3_2 = null;
            this._lock.readLock().unlock();
            return bl;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this._lock.readLock().unlock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean containsKey(Object key) {
        try {
            this._lock.readLock().lock();
            boolean bl = this._mapKeyPos.containsKey(key);
            Object var4_3 = null;
            this._lock.readLock().unlock();
            return bl;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this._lock.readLock().unlock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean containsValue(Object value) {
        boolean bl;
        block5: {
            boolean bl2;
            block4: {
                try {
                    this._lock.readLock().lock();
                    for (Integer pos : this._mapKeyPos.values()) {
                        if (pos == null) continue;
                        if (value == null) {
                            if (this._values[pos] != null) continue;
                            boolean bl3 = true;
                            Object var6_7 = null;
                            this._lock.readLock().unlock();
                            return bl3;
                        }
                        if (!value.equals(this._values[pos])) continue;
                        bl2 = true;
                        break block4;
                    }
                    bl = false;
                    break block5;
                }
                catch (Throwable throwable) {
                    Object var6_10 = null;
                    this._lock.readLock().unlock();
                    throw throwable;
                }
            }
            Object var6_8 = null;
            this._lock.readLock().unlock();
            return bl2;
        }
        Object var6_9 = null;
        this._lock.readLock().unlock();
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V get(Object key) {
        Integer pos;
        block3: {
            V v;
            try {
                this._lock.writeLock().lock();
                pos = this._mapKeyPos.get(key);
                if (pos != null) break block3;
                v = null;
                Object var6_5 = null;
                this._lock.writeLock().unlock();
            }
            catch (Throwable throwable) {
                Object var6_7 = null;
                this._lock.writeLock().unlock();
                throw throwable;
            }
            return v;
        }
        int intPos = pos;
        this._status[intPos] = 1;
        V v = this._values[intPos];
        Object var6_6 = null;
        this._lock.writeLock().unlock();
        return v;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V put(K key, V value) {
        V v;
        Integer pos;
        block5: {
            this._lock.writeLock().lock();
            pos = this._mapKeyPos.get(key);
            if (pos == null) break block5;
            int intPos = pos;
            V old = this._values[intPos];
            this._values[intPos] = value;
            this._status[intPos] = 1;
            V v2 = old;
            Object var8_8 = null;
            this._lock.writeLock().unlock();
            return v2;
        }
        try {
            while (this._status[this._cur] == 1) {
                this._status[this._cur] = 0;
                ++this._cur;
                if (this._cur < this._capacity) continue;
                this._cur = 0;
            }
            pos = this._keys[this._cur] != null ? this._mapKeyPos.remove(this._keys[this._cur]) : new Integer(this._cur);
            this._keys[this._cur] = key;
            this._values[this._cur] = value;
            this._status[this._cur] = 1;
            this._mapKeyPos.put(key, pos);
            ++this._cur;
            if (this._cur >= this._capacity) {
                this._cur = 0;
            }
            v = null;
            Object var8_9 = null;
            this._lock.writeLock().unlock();
        }
        catch (Throwable throwable) {
            Object var8_10 = null;
            this._lock.writeLock().unlock();
            throw throwable;
        }
        return v;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V remove(Object key) {
        Integer pos;
        block3: {
            V v;
            try {
                this._lock.writeLock().lock();
                pos = this._mapKeyPos.remove(key);
                if (pos != null) break block3;
                v = null;
                Object var7_5 = null;
                this._lock.writeLock().unlock();
            }
            catch (Throwable throwable) {
                Object var7_7 = null;
                this._lock.writeLock().unlock();
                throw throwable;
            }
            return v;
        }
        int intPos = pos;
        V old = this._values[intPos];
        this._keys[intPos] = null;
        this._values[intPos] = null;
        this._status[intPos] = 0;
        V v = old;
        Object var7_6 = null;
        this._lock.writeLock().unlock();
        return v;
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> map) {
        for (Map.Entry<K, V> entry : map.entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public void clear() {
        this._lock.writeLock().lock();
        this._mapKeyPos.clear();
        for (int intPos = 0; intPos < this._capacity; ++intPos) {
            this._keys[intPos] = null;
            this._values[intPos] = null;
            this._status[intPos] = 0;
        }
        this._lock.writeLock().unlock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<K> keySet() {
        try {
            this._lock.readLock().lock();
            Set<K> set = Collections.unmodifiableSet(this._mapKeyPos.keySet());
            Object var3_2 = null;
            this._lock.readLock().unlock();
            return set;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this._lock.readLock().unlock();
            throw throwable;
        }
    }

    @Override
    public Collection<V> values() {
        ArrayList<V> col = new ArrayList<V>();
        this._lock.readLock().lock();
        for (Integer pos : this._mapKeyPos.values()) {
            if (pos == null) continue;
            col.add(this._values[pos]);
        }
        this._lock.readLock().unlock();
        return Collections.unmodifiableCollection(col);
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        HashMap<K, V> map = new HashMap<K, V>();
        this._lock.readLock().lock();
        for (Integer pos : this._mapKeyPos.values()) {
            if (pos == null) continue;
            map.put(this._keys[pos], this._values[pos]);
        }
        this._lock.readLock().unlock();
        return Collections.unmodifiableSet(map.entrySet());
    }
}

