/*
 * Decompiled with CFR 0.152.
 */
package org.castor.cache.simple;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.castor.cache.AbstractBaseCache;
import org.castor.cache.CacheAcquireException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TimeLimited<K, V>
extends AbstractBaseCache<K, V> {
    private static final Log LOG = LogFactory.getLog(TimeLimited.class);
    public static final String TYPE = "time-limited";
    public static final String PARAM_TTL = "ttl";
    public static final int DEFAULT_TTL = 30;
    private static final int TICK_DELAY = 1;
    private static final int DEFAULT_PRECISION = 1000;
    private static final TickThread TIMER = new TickThread(1000);
    private final ConcurrentHashMap<K, QueueItem> _map = new ConcurrentHashMap();
    private int _ttl = 30;

    @Override
    public final void initialize(Properties params) throws CacheAcquireException {
        super.initialize(params);
        String param = params.getProperty(PARAM_TTL);
        try {
            if (param != null) {
                this._ttl = Integer.parseInt(param);
            }
            if (this._ttl <= 0) {
                this._ttl = 30;
            }
        }
        catch (NumberFormatException ex) {
            this._ttl = 30;
        }
        this._map.clear();
        TIMER.addTickerTask(this);
    }

    @Override
    public final String getType() {
        return TYPE;
    }

    public final int getTTL() {
        return this._ttl;
    }

    @Override
    public final int size() {
        return this._map.size();
    }

    @Override
    public final boolean isEmpty() {
        return this._map.isEmpty();
    }

    @Override
    public final boolean containsKey(Object key) {
        return this._map.containsKey(key);
    }

    @Override
    public final boolean containsValue(Object value) {
        for (QueueItem item : this._map.values()) {
            if (!(value == null ? item._value == null : value.equals(item._value))) continue;
            return true;
        }
        return false;
    }

    @Override
    public final V get(Object key) {
        QueueItem item = this._map.get(key);
        return (V)(item == null ? null : item._value);
    }

    @Override
    public final V put(K key, V value) {
        QueueItem item = this._map.putIfAbsent(key, new QueueItem(key, value, this._ttl));
        return (V)(item == null ? null : item.update(value, this._ttl));
    }

    @Override
    public V remove(Object key) {
        QueueItem item = this._map.remove(key);
        return (V)(item == null ? null : item._value);
    }

    @Override
    public final void putAll(Map<? extends K, ? extends V> map) {
        for (Map.Entry<K, V> entry : map.entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public final void clear() {
        this._map.clear();
    }

    @Override
    public final Set<K> keySet() {
        return Collections.unmodifiableSet(this._map.keySet());
    }

    @Override
    public final Collection<V> values() {
        ArrayList<Object> col = new ArrayList<Object>();
        for (QueueItem item : this._map.values()) {
            col.add(item._value);
        }
        return Collections.unmodifiableCollection(col);
    }

    @Override
    public final Set<Map.Entry<K, V>> entrySet() {
        HashMap<Object, Object> map = new HashMap<Object, Object>();
        for (QueueItem item : this._map.values()) {
            map.put(item._key, item._value);
        }
        return Collections.unmodifiableSet(map.entrySet());
    }

    private void tick() {
        for (QueueItem queueItem : this._map.values()) {
            if (queueItem._time.getAndAdd(-1) > 0) continue;
            Object key = queueItem._key;
            this._map.remove(key);
            if (!LOG.isDebugEnabled()) continue;
            LOG.trace((Object)("dispose(" + key + ")"));
        }
    }

    private static final class TickThread
    extends Thread {
        private final Set<TimeLimited> _set = new CopyOnWriteArraySet<TimeLimited>();
        private final int _tick;

        public TickThread(int tick) {
            super("Time-limited cache daemon");
            this.setDaemon(true);
            this.setPriority(1);
            this._tick = tick;
            this.start();
        }

        void addTickerTask(TimeLimited cache) {
            this._set.add(cache);
        }

        public void run() {
            try {
                long last = System.currentTimeMillis();
                block2: while (true) {
                    long diff;
                    if ((diff = System.currentTimeMillis() - last) < (long)this._tick) {
                        TickThread.sleep((long)this._tick - diff);
                    }
                    last = System.currentTimeMillis();
                    Iterator<TimeLimited> i$ = this._set.iterator();
                    while (true) {
                        if (!i$.hasNext()) continue block2;
                        TimeLimited cache = i$.next();
                        cache.tick();
                    }
                    break;
                }
            }
            catch (InterruptedException e) {
                LOG.error((Object)"Time-limited cache daemon has been interrupted", (Throwable)e);
                return;
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class QueueItem {
        private final K _key;
        private volatile V _value;
        private final AtomicInteger _time;

        private QueueItem(K key, V value, int time) {
            this._key = key;
            this._value = value;
            this._time = new AtomicInteger(time);
        }

        private V update(V value, int time) {
            Object oldValue = this._value;
            this._value = value;
            this._time.set(time);
            return oldValue;
        }
    }
}

