/*
 * Decompiled with CFR 0.152.
 */
package org.castor.cpa.jpa.info;

import java.lang.annotation.Annotation;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import javax.persistence.Entity;
import javax.persistence.MappedSuperclass;
import org.castor.core.annotationprocessing.AnnotationTargetException;
import org.castor.core.annotationprocessing.TargetAwareAnnotationProcessingService;
import org.castor.core.nature.BaseNature;
import org.castor.cpa.jpa.info.ClassInfo;
import org.castor.cpa.jpa.info.ClassInfoRegistry;
import org.castor.cpa.jpa.info.FieldInfo;
import org.castor.cpa.jpa.info.JPAClassAnnotationProcessingService;
import org.castor.cpa.jpa.info.JPAFieldAnnotationProcessingService;
import org.castor.cpa.jpa.natures.JPAClassNature;
import org.castor.cpa.jpa.natures.JPAFieldNature;
import org.castor.cpa.jpa.processors.ReflectionsHelper;
import org.exolab.castor.mapping.MappingException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ClassInfoBuilder {
    private static TargetAwareAnnotationProcessingService _classAnnotationProcessingService = new JPAClassAnnotationProcessingService();
    private static TargetAwareAnnotationProcessingService _fieldAnnotationProcessingService = new JPAFieldAnnotationProcessingService();

    private ClassInfoBuilder() {
    }

    public static ClassInfo buildClassInfo(Class<?> type) throws MappingException {
        if (type == null) {
            throw new IllegalArgumentException("Argument type must not be null");
        }
        ClassInfo classInfo = ClassInfoRegistry.getClassInfo(type);
        if (classInfo != null) {
            return classInfo;
        }
        if (!ClassInfoBuilder.isDescribable(type)) {
            return null;
        }
        classInfo = new ClassInfo(type);
        classInfo.addNature(JPAClassNature.class.getName());
        JPAClassNature jpaClassNature = new JPAClassNature(classInfo);
        try {
            _classAnnotationProcessingService.processAnnotations((BaseNature)jpaClassNature, type.getAnnotations(), type);
        }
        catch (AnnotationTargetException e) {
            throw new MappingException("Could not process class bound annotations for class " + type.getSimpleName(), (Exception)((Object)e));
        }
        for (Field field : type.getDeclaredFields()) {
            if (field.getAnnotations().length == 0 || !ClassInfoBuilder.hasJPAAnnotations(field)) continue;
            throw new MappingException("Castor does not support field access, thus annotated fields are not supported! Move annotations to the getter method of " + field.getName());
        }
        for (AccessibleObject accessibleObject : type.getDeclaredMethods()) {
            if (!ReflectionsHelper.isGetter((Method)accessibleObject)) continue;
            if (ClassInfoBuilder.isDescribable(type, (Method)accessibleObject)) {
                ClassInfoBuilder.buildFieldInfo(classInfo, (Method)accessibleObject);
                continue;
            }
            throw new MappingException("Invalid method annotated, method is not describeable!");
        }
        if (classInfo.getKeyFieldCount() > 1) {
            throw new MappingException("Castor-JPA does not support composite keys (found in " + type.getName() + ")");
        }
        ClassInfoRegistry.registerClassInfo(type, classInfo);
        return classInfo;
    }

    private static boolean hasJPAAnnotations(AnnotatedElement annotatedElement) {
        for (Annotation annotation : annotatedElement.getAnnotations()) {
            Class<? extends Annotation> annotationClass = annotation.annotationType();
            if (!annotationClass.getPackage().equals(Package.getPackage("javax.persistence"))) continue;
            return true;
        }
        return false;
    }

    private static void buildFieldInfo(ClassInfo classInfo, Method method) throws MappingException {
        if (classInfo == null) {
            throw new IllegalArgumentException("Argument classInfo must not be null.");
        }
        if (method == null) {
            throw new IllegalArgumentException("Argument method must not be null.");
        }
        String fieldName = ReflectionsHelper.getFieldnameFromGetter(method);
        if (fieldName == null) {
            throw new IllegalArgumentException("Can not resolve Fieldname from method name.");
        }
        Method setterMethod = null;
        try {
            setterMethod = ReflectionsHelper.getSetterMethodFromGetter(method);
        }
        catch (SecurityException e) {
            throw new MappingException("Setter method for field " + fieldName + " is not accessible!");
        }
        catch (NoSuchMethodException e) {
            throw new MappingException("Setter method for field " + fieldName + " does not exist!", (Exception)e);
        }
        Class<?> fieldType = method.getReturnType();
        FieldInfo fieldInfo = new FieldInfo(classInfo, fieldType, fieldName, method, setterMethod);
        fieldInfo.addNature(JPAFieldNature.class.getName());
        JPAFieldNature jpaFieldNature = new JPAFieldNature(fieldInfo);
        try {
            _fieldAnnotationProcessingService.processAnnotations((BaseNature)jpaFieldNature, method.getAnnotations(), (AnnotatedElement)method);
        }
        catch (AnnotationTargetException e) {
            throw new MappingException("Could not process annotations for method " + method.getName(), (Exception)((Object)e));
        }
        if (jpaFieldNature.isId()) {
            classInfo.addKey(fieldInfo);
        } else {
            classInfo.addFieldInfo(fieldInfo);
        }
    }

    private static boolean isDescribable(Class<?> type) {
        if (Object.class.equals(type) || Void.class.equals(type) || Class.class.equals(type)) {
            return false;
        }
        return type.getAnnotation(Entity.class) != null || type.getAnnotation(MappedSuperclass.class) != null;
    }

    private static boolean isDescribable(Class<?> type, Method method) {
        boolean isDescribeable = true;
        Class<?> declaringClass = method.getDeclaringClass();
        if (declaringClass != null && !type.equals(declaringClass) && !declaringClass.isInterface()) {
            isDescribeable = false;
        }
        if (method.isSynthetic()) {
            isDescribeable &= false;
        }
        if (Modifier.isStatic(method.getModifiers())) {
            isDescribeable &= false;
        }
        if (Modifier.isTransient(method.getModifiers())) {
            isDescribeable &= false;
        }
        return isDescribeable;
    }
}

