/*
 * Decompiled with CFR 0.152.
 */
package org.castor.cpa.jpa.info;

import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.persistence.CascadeType;
import javax.persistence.FetchType;
import javax.persistence.GenerationType;
import javax.persistence.TemporalType;
import org.castor.core.nature.PropertyHolder;
import org.castor.cpa.jpa.info.ClassInfo;
import org.castor.cpa.jpa.info.ClassInfoBuilder;
import org.castor.cpa.jpa.info.ClassInfoRegistry;
import org.castor.cpa.jpa.info.FieldInfo;
import org.castor.cpa.jpa.info.JPAKeyGeneratorManager;
import org.castor.cpa.jpa.info.JPASequenceGeneratorDescriptor;
import org.castor.cpa.jpa.info.JPATableGeneratorDescriptor;
import org.castor.cpa.jpa.info.JPAVersionManager;
import org.castor.cpa.jpa.natures.JPAClassNature;
import org.castor.cpa.jpa.natures.JPAFieldNature;
import org.castor.cpa.persistence.convertor.EnumToOrdinal;
import org.castor.cpa.persistence.convertor.EnumTypeConversionHelper;
import org.castor.cpa.persistence.convertor.EnumTypeConvertor;
import org.castor.cpa.persistence.convertor.ObjectToString;
import org.castor.jdo.engine.SQLTypeInfos;
import org.castor.persist.CascadingType;
import org.exolab.castor.jdo.engine.KeyGeneratorDescriptor;
import org.exolab.castor.jdo.engine.nature.ClassDescriptorJDONature;
import org.exolab.castor.jdo.engine.nature.FieldDescriptorJDONature;
import org.exolab.castor.mapping.ClassDescriptor;
import org.exolab.castor.mapping.FieldDescriptor;
import org.exolab.castor.mapping.FieldHandler;
import org.exolab.castor.mapping.MappingException;
import org.exolab.castor.mapping.TypeConvertor;
import org.exolab.castor.mapping.loader.ClassDescriptorImpl;
import org.exolab.castor.mapping.loader.FieldDescriptorImpl;
import org.exolab.castor.mapping.loader.FieldHandlerImpl;
import org.exolab.castor.mapping.loader.TypeInfo;
import org.exolab.castor.mapping.loader.Types;
import org.exolab.castor.mapping.xml.NamedNativeQuery;
import org.exolab.castor.mapping.xml.types.FieldMappingCollectionType;
import org.exolab.castor.xml.ClassDescriptorResolver;
import org.exolab.castor.xml.ResolverException;

public final class InfoToDescriptorConverter {
    private InfoToDescriptorConverter() {
    }

    public static void convert(ClassInfo classInfo, ClassDescriptorResolver cdr, ClassDescriptorImpl descriptor) throws MappingException {
        Map<String, String> namedNativeQueryMap;
        if (classInfo == null) {
            throw new IllegalArgumentException("ClassInfo must not be null!");
        }
        if (descriptor == null) {
            throw new IllegalArgumentException("ClassDescriptor must not be null!");
        }
        if (!classInfo.hasNature(JPAClassNature.class.getName())) {
            throw new IllegalArgumentException("ClassInfo must have JPAClassNature on it!");
        }
        if (!Types.isConstructable(classInfo.getDescribedClass(), (boolean)true)) {
            throw new MappingException("mapping.classNotConstructable", (Object)classInfo.getDescribedClass().getName());
        }
        JPAClassNature nature = new JPAClassNature(classInfo);
        descriptor.addNature(ClassDescriptorJDONature.class.getName());
        ClassDescriptorJDONature jdoNature = new ClassDescriptorJDONature((PropertyHolder)descriptor);
        descriptor.setJavaClass(classInfo.getDescribedClass());
        descriptor.setExtends(null);
        Class<?> extendedClass = classInfo.getExtendedClass();
        if (extendedClass != null && extendedClass != Object.class) {
            ClassDescriptor extendedClassDescriptor = null;
            try {
                extendedClassDescriptor = cdr.resolve(extendedClass);
                if (extendedClassDescriptor == null) {
                    throw new MappingException("Unable to resolve extended class " + extendedClass.getName() + " in " + classInfo.getDescribedClass().getName());
                }
            }
            catch (ResolverException e) {
                throw new MappingException("Unable to resolve extended class " + extendedClass.getName() + " in " + classInfo.getDescribedClass().getName(), (Exception)((Object)e));
            }
            if (new ClassDescriptorJDONature((PropertyHolder)extendedClassDescriptor).hasMappedSuperclass()) {
                ClassInfo extendedClassInfo = ClassInfoRegistry.getClassInfo(extendedClass);
                for (FieldInfo fieldInfo : extendedClassInfo.getKeyFieldInfos()) {
                    classInfo.addKey(fieldInfo);
                }
                for (FieldInfo fieldInfo : extendedClassInfo.getFieldInfos()) {
                    classInfo.addFieldInfo(fieldInfo);
                }
            } else {
                descriptor.setExtends(extendedClassDescriptor);
                if (extendedClassDescriptor.hasNature(ClassDescriptorJDONature.class.getName())) {
                    ClassDescriptorJDONature jdoClassNature = new ClassDescriptorJDONature((PropertyHolder)extendedClassDescriptor);
                    jdoClassNature.addExtended((ClassDescriptor)descriptor);
                }
            }
        }
        descriptor.setDepends(null);
        descriptor.setJavaClass(classInfo.getDescribedClass());
        String tableName = nature.getTableName();
        if (tableName == null || tableName.trim().length() == 0) {
            tableName = nature.getEntityName();
        }
        jdoNature.setTableName(tableName);
        jdoNature.addCacheParam("name", classInfo.getDescribedClass().getName());
        Properties cacheProperties = nature.getCacheProperties();
        if (cacheProperties != null) {
            for (Object propertyKey : cacheProperties.keySet()) {
                String key = (String)propertyKey;
                jdoNature.addCacheParam(key, cacheProperties.getProperty(key));
            }
        }
        jdoNature.setAccessMode(null);
        jdoNature.setAbstract(nature.hasMappedSuperclass());
        Map<String, String> namedQuery = nature.getNamedQuery();
        if (namedQuery != null && namedQuery.size() > 0) {
            for (Map.Entry<String, String> entry : namedQuery.entrySet()) {
                jdoNature.addNamedQuery(entry.getKey(), entry.getValue());
            }
        }
        if ((namedNativeQueryMap = nature.getNamedNativeQuery()) != null && namedNativeQueryMap.size() > 0) {
            for (Map.Entry<String, String> entry : namedNativeQueryMap.entrySet()) {
                NamedNativeQuery namedNativeQuery = new NamedNativeQuery();
                namedNativeQuery.setName(entry.getKey());
                namedNativeQuery.setQuery(entry.getValue());
                namedNativeQuery.setResultClass(classInfo.getDescribedClass().getName());
                jdoNature.addNamedNativeQuery(namedNativeQuery.getName(), namedNativeQuery);
            }
        }
        FieldDescriptor[] keys = new FieldDescriptor[classInfo.getKeyFieldCount()];
        int i = 0;
        for (FieldInfo fieldInfo : classInfo.getKeyFieldInfos()) {
            JPAFieldNature jpaKeyInfo = new JPAFieldNature(fieldInfo);
            if (jpaKeyInfo.getGeneratedValueStrategy() != null) {
                KeyGeneratorDescriptor generatorDescriptor = InfoToDescriptorConverter.describeKeyGenerator(fieldInfo, jpaKeyInfo);
                jdoNature.setKeyGeneratorDescriptor(generatorDescriptor);
            }
            keys[i] = InfoToDescriptorConverter.convert(descriptor, fieldInfo, cdr);
            ++i;
        }
        descriptor.setIdentities(keys);
        FieldDescriptor[] fields = new FieldDescriptor[classInfo.getFieldCount()];
        i = 0;
        for (FieldInfo fieldInfo : classInfo.getFieldInfos()) {
            fields[i] = InfoToDescriptorConverter.convert(descriptor, fieldInfo, cdr);
            ++i;
        }
        descriptor.setFields(fields);
        InfoToDescriptorConverter.defineVersionField(classInfo, jdoNature);
    }

    private static void defineVersionField(ClassInfo classInfo, ClassDescriptorJDONature jdoNature) {
        JPAVersionManager manager = JPAVersionManager.getInstance();
        String versionField = manager.get(classInfo.getDescribedClass());
        if (versionField != null) {
            jdoNature.setVersionField(versionField);
        }
    }

    private static KeyGeneratorDescriptor describeKeyGenerator(FieldInfo fieldInfo, JPAFieldNature jpaKeyInfo) {
        GenerationType strategy = jpaKeyInfo.getGeneratedValueStrategy();
        String strategyName = strategy.toString();
        Properties generatorParameters = new Properties();
        JPAKeyGeneratorManager manager = JPAKeyGeneratorManager.getInstance();
        switch (strategy) {
            case SEQUENCE: {
                String generatorName = jpaKeyInfo.getGeneratedValueGenerator();
                JPASequenceGeneratorDescriptor sequenceGeneratorDescriptor = (JPASequenceGeneratorDescriptor)manager.get(generatorName);
                String sequenceName = sequenceGeneratorDescriptor.getSequenceName();
                if ("".equals(sequenceName)) break;
                generatorParameters.put("sequence", sequenceName);
                break;
            }
            case AUTO: {
                strategyName = GenerationType.TABLE.toString();
                JPATableGeneratorDescriptor autoGeneratorDescriptor = (JPATableGeneratorDescriptor)manager.getAuto();
                autoGeneratorDescriptor.setPrimaryKeyType(fieldInfo.getFieldType());
                generatorParameters.put("descriptor", autoGeneratorDescriptor);
                break;
            }
            case TABLE: {
                String generatorName = jpaKeyInfo.getGeneratedValueGenerator();
                JPATableGeneratorDescriptor tableGeneratorDescriptor = (JPATableGeneratorDescriptor)manager.get(generatorName);
                tableGeneratorDescriptor.setPrimaryKeyType(fieldInfo.getFieldType());
                generatorParameters.put("descriptor", tableGeneratorDescriptor);
                break;
            }
            case IDENTITY: {
                strategyName = strategy.toString().toUpperCase();
                break;
            }
        }
        KeyGeneratorDescriptor generatorDescriptor = new KeyGeneratorDescriptor(strategyName, strategyName, generatorParameters);
        return generatorDescriptor;
    }

    private static FieldDescriptorImpl convert(ClassDescriptorImpl parent, FieldInfo fieldInfo, ClassDescriptorResolver cdr) throws MappingException {
        if (!fieldInfo.hasNature(JPAFieldNature.class.getName())) {
            throw new IllegalArgumentException("FieldInfo must have JPAFieldNature on it!");
        }
        JPAFieldNature jpaNature = new JPAFieldNature(fieldInfo);
        String fieldName = fieldInfo.getFieldName();
        TypeInfo typeInfo = InfoToDescriptorConverter.createTypeInfo(fieldInfo, jpaNature);
        FieldHandler handler = InfoToDescriptorConverter.createFieldHandler(fieldInfo, typeInfo);
        boolean isTransient = jpaNature.isTransient();
        FieldDescriptorImpl fieldDescriptor = new FieldDescriptorImpl(fieldName, typeInfo, handler, isTransient);
        fieldDescriptor.addNature(FieldDescriptorJDONature.class.getName());
        FieldDescriptorJDONature jdoNature = new FieldDescriptorJDONature((PropertyHolder)fieldDescriptor);
        int sqlType = InfoToDescriptorConverter.determineFieldType(jpaNature, typeInfo);
        if (jpaNature.isManyToManyInverseCopy()) {
            InfoToDescriptorConverter.defineManyToManyJoinTable(jpaNature);
        }
        fieldDescriptor.setContainingClassDescriptor((ClassDescriptor)parent);
        fieldDescriptor.setFieldType(typeInfo.getFieldType());
        fieldDescriptor.setIdentity(jpaNature.isId());
        if (InfoToDescriptorConverter.hasFieldRelation(jpaNature)) {
            if (jpaNature.getCascadeTypes() != null) {
                StringBuilder cascading = new StringBuilder();
                List<CascadeType> cascadeTypes = Arrays.asList(jpaNature.getCascadeTypes());
                if (cascadeTypes.contains(CascadeType.ALL)) {
                    cascading.append(CascadingType.CREATE.name());
                    cascading.append(" ");
                    cascading.append(CascadingType.DELETE.name());
                } else {
                    if (cascadeTypes.contains(CascadeType.PERSIST)) {
                        cascading.append(CascadingType.CREATE.name());
                        cascading.append(" ");
                    }
                    if (cascadeTypes.contains(CascadeType.REMOVE)) {
                        cascading.append(CascadingType.DELETE.name());
                    }
                }
                jdoNature.setCascading(cascading.toString());
            }
            try {
                fieldDescriptor.setClassDescriptor(cdr.resolve(jpaNature.getRelationTargetEntity()));
            }
            catch (ResolverException e) {
                throw new MappingException("Can not resolve ClassDescriptor for Class " + jpaNature.getRelationTargetEntity().getName() + " needed by " + fieldInfo.getDeclaringClassInfo().getDescribedClass().getName() + "#" + fieldName);
            }
        }
        fieldDescriptor.setRequired(InfoToDescriptorConverter.createRequired(jpaNature));
        fieldDescriptor.setMultivalued(false);
        if (jpaNature.isOneToMany() || jpaNature.isManyToMany()) {
            fieldDescriptor.setMultivalued(true);
        }
        fieldDescriptor.setImmutable(false);
        jdoNature.setSQLType(new int[]{sqlType});
        jdoNature.setSQLName(InfoToDescriptorConverter.createSQLName(fieldName, jpaNature, fieldDescriptor.getClassDescriptor()));
        jdoNature.setManyKey(InfoToDescriptorConverter.createManyKey(fieldName, jpaNature, fieldDescriptor.getClassDescriptor(), parent));
        if (jpaNature.isManyToMany()) {
            jdoNature.setManyTable(jpaNature.getJoinTableName());
        }
        jdoNature.setTypeConvertor(null);
        jdoNature.setReadOnly(false);
        jdoNature.setDirtyCheck(true);
        fieldDescriptor.setFieldName(fieldName);
        fieldDescriptor.setLazy(InfoToDescriptorConverter.createFMLazy(jpaNature));
        fieldDescriptor.setDirect(false);
        fieldDescriptor.setGetMethod(fieldInfo.getGetterMethod().getName());
        fieldDescriptor.setSetMethod(fieldInfo.getSetterMethod().getName());
        fieldDescriptor.setCollection(InfoToDescriptorConverter.createColletionType(jpaNature));
        InfoToDescriptorConverter.setJDONatureValues(fieldName, jpaNature, fieldDescriptor.getClassDescriptor(), sqlType, parent, (FieldDescriptor)fieldDescriptor);
        fieldDescriptor.setFieldType(typeInfo.getFieldType());
        return fieldDescriptor;
    }

    private static FieldHandler createFieldHandler(FieldInfo fieldInfo, TypeInfo typeInfo) throws MappingException {
        FieldHandlerImpl fieldHandler = null;
        fieldHandler = new FieldHandlerImpl(fieldInfo.getFieldName(), null, null, fieldInfo.getGetterMethod(), fieldInfo.getSetterMethod(), typeInfo);
        return fieldHandler;
    }

    private static TypeInfo createTypeInfo(FieldInfo fieldInfo, JPAFieldNature jpaNature) throws MappingException {
        Class<?> fieldType = fieldInfo.getFieldType();
        if (InfoToDescriptorConverter.hasFieldRelation(jpaNature)) {
            return new TypeInfo(jpaNature.getRelationTargetEntity());
        }
        if (fieldType.isEnum()) {
            try {
                EnumTypeConversionHelper enumTypeConversionHelper = new EnumTypeConversionHelper(fieldType);
                Method method = jpaNature.isStringEnumType() ? fieldType.getMethod("valueOf", String.class) : enumTypeConversionHelper.getClass().getMethod("getEnumConstantValueByOrdinal", Integer.TYPE);
                EnumTypeConvertor typeConvertor = new EnumTypeConvertor(jpaNature.isStringEnumType() ? String.class : Integer.TYPE, fieldType, method);
                TypeInfo typeInfo = new TypeInfo(fieldType, (TypeConvertor)typeConvertor, (TypeConvertor)(jpaNature.isStringEnumType() ? new ObjectToString() : new EnumToOrdinal()), InfoToDescriptorConverter.createRequired(jpaNature), null, null);
                Types.addEnumType(fieldType);
                Types.addConvertibleType(fieldType);
                return typeInfo;
            }
            catch (NoSuchMethodException ex) {
                throw new MappingException(String.format("Problem occurred mapping enum `%s`: %s", fieldType, ex.getMessage()), (Exception)ex);
            }
        }
        return new TypeInfo(fieldInfo.getFieldType());
    }

    private static int determineFieldType(JPAFieldNature jpaNature, TypeInfo typeInfo) {
        Class javaType = Types.typeFromPrimitive((Class)typeInfo.getFieldType());
        int sqlType = SQLTypeInfos.javaType2sqlTypeNum(javaType);
        if (jpaNature.getFieldInfo().getFieldType().isEnum()) {
            sqlType = jpaNature.isStringEnumType() ? 12 : 4;
        } else if (jpaNature.isLob()) {
            sqlType = typeInfo.getFieldType() == String.class ? 2005 : 2004;
        } else {
            TemporalType temporalType = jpaNature.getTemporalType();
            if (temporalType != null) {
                switch (temporalType) {
                    case DATE: {
                        sqlType = 91;
                        break;
                    }
                    case TIME: {
                        sqlType = 92;
                        break;
                    }
                    case TIMESTAMP: {
                        sqlType = 93;
                        break;
                    }
                }
            }
        }
        return sqlType;
    }

    private static void defineManyToManyJoinTable(JPAFieldNature jpaNature) throws MappingException {
        ClassInfo relatedClass = ClassInfoBuilder.buildClassInfo(jpaNature.getRelationTargetEntity());
        String relatedFieldName = jpaNature.getRelationMappedBy();
        FieldInfo relatedField = relatedClass.getFieldInfoByName(relatedFieldName);
        JPAFieldNature relatedFieldNature = new JPAFieldNature(relatedField);
        jpaNature.setJoinTableCatalog(relatedFieldNature.getJoinTableCatalog());
        jpaNature.setJoinTableName(relatedFieldNature.getJoinTableName());
        jpaNature.setJoinTableSchema(relatedFieldNature.getJoinTableSchema());
        jpaNature.setJoinTableInverseJoinColumns(relatedFieldNature.getJoinTableJoinColumns());
        jpaNature.setJoinTableJoinColumns(relatedFieldNature.getJoinTableInverseJoinColumns());
    }

    private static boolean createRequired(JPAFieldNature jpaNature) {
        if (jpaNature.getColumnNullable() != null) {
            return jpaNature.getColumnNullable() == false;
        }
        if (jpaNature.isId()) {
            return true;
        }
        if (jpaNature.isOneToMany()) {
            return true;
        }
        if (jpaNature.isManyToMany()) {
            return true;
        }
        if (!jpaNature.isRelationOptional()) {
            return true;
        }
        return !jpaNature.isBasicOptional();
    }

    private static FieldMappingCollectionType createColletionType(JPAFieldNature jpaNature) {
        if (jpaNature.getRelationCollectionType() != null) {
            String collectionTypeName = jpaNature.getRelationCollectionType().getSimpleName().toLowerCase();
            return FieldMappingCollectionType.fromValue((String)collectionTypeName);
        }
        return null;
    }

    private static void setJDONatureValues(String fieldName, JPAFieldNature jpaNature, ClassDescriptor fieldClassDescriptor, int sqlType, ClassDescriptorImpl parentClassDescriptor, FieldDescriptor fieldDescriptor) throws MappingException {
        if (!fieldDescriptor.hasNature(FieldDescriptorJDONature.class.getName())) {
            FieldDescriptorJDONature nature = new FieldDescriptorJDONature((PropertyHolder)fieldClassDescriptor);
            String[] sqlNames = InfoToDescriptorConverter.createSQLName(fieldName, jpaNature, fieldClassDescriptor);
            if (!InfoToDescriptorConverter.hasFieldRelation(jpaNature)) {
                nature.setSQLName(sqlNames);
                nature.setSQLType(new int[]{sqlType});
            } else if (InfoToDescriptorConverter.isXToOne(jpaNature)) {
                nature.setSQLName(sqlNames);
                nature.setManyKey(sqlNames);
            } else {
                String[] manyKeys = InfoToDescriptorConverter.createManyKey(fieldName, jpaNature, fieldClassDescriptor, parentClassDescriptor);
                nature.setSQLName(manyKeys);
                nature.setManyKey(manyKeys);
            }
        }
    }

    private static boolean createFMLazy(JPAFieldNature jpaNature) {
        if (jpaNature.isRelationLazyFetch()) {
            return true;
        }
        return FetchType.LAZY.equals((Object)jpaNature.getBasicFetch());
    }

    private static String[] createManyKey(String fieldName, JPAFieldNature jpaNature, ClassDescriptor fieldClassDescriptor, ClassDescriptorImpl parentClassDescriptor) {
        if (InfoToDescriptorConverter.isXToOne(jpaNature)) {
            return InfoToDescriptorConverter.createSQLName(fieldName, jpaNature, fieldClassDescriptor);
        }
        if (jpaNature.isOneToMany()) {
            String[] sqlManyKey = new String[]{jpaNature.getJoinColumnName()};
            if ((sqlManyKey[0] == null || sqlManyKey[0].trim().length() == 0) && jpaNature.getRelationMappedBy() != null) {
                sqlManyKey[0] = jpaNature.getRelationMappedBy() + "_" + parentClassDescriptor.getIdentity().getFieldName();
            }
            return sqlManyKey;
        }
        if (jpaNature.isManyToMany()) {
            String[] sqlManyKey = new String[]{jpaNature.getJoinTableJoinColumns()[0].name()};
            if (sqlManyKey[0] == null || sqlManyKey[0].trim().length() == 0) {
                throw new IllegalStateException("Could not find JoinColumn definition on M:N relation! This must be defined on either sides of the relation!");
            }
            return sqlManyKey;
        }
        return null;
    }

    private static String[] createSQLName(String fieldName, JPAFieldNature jpaNature, ClassDescriptor fieldClassDescriptor) {
        String[] sqlName = new String[1];
        if (!InfoToDescriptorConverter.hasFieldRelation(jpaNature)) {
            sqlName[0] = jpaNature.getColumnName();
            if (sqlName[0] == null || sqlName[0].trim().length() == 0) {
                sqlName[0] = fieldName;
            }
        } else if (InfoToDescriptorConverter.isXToOne(jpaNature)) {
            sqlName[0] = jpaNature.getJoinColumnName();
            if (sqlName[0] == null || sqlName[0].trim().length() == 0) {
                sqlName[0] = fieldName + "_" + fieldClassDescriptor.getIdentity().getFieldName();
            }
        } else {
            sqlName = null;
        }
        return sqlName;
    }

    private static boolean isXToOne(JPAFieldNature jpaNature) {
        return jpaNature.isOneToOne() || jpaNature.isManyToOne();
    }

    private static boolean hasFieldRelation(JPAFieldNature jpaNature) {
        return jpaNature.isOneToOne() || jpaNature.isManyToOne() || jpaNature.isOneToMany() || jpaNature.isManyToMany();
    }
}

