/*
 * Decompiled with CFR 0.152.
 */
package org.castor.cpa.jpa.info;

import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.persistence.Entity;
import javax.persistence.EntityListeners;
import javax.persistence.ExcludeDefaultListeners;
import javax.persistence.ExcludeSuperclassListeners;
import javax.persistence.PostLoad;
import javax.persistence.PostPersist;
import javax.persistence.PostRemove;
import javax.persistence.PostUpdate;
import javax.persistence.PrePersist;
import javax.persistence.PreRemove;
import javax.persistence.PreUpdate;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.exolab.castor.jdo.Database;
import org.exolab.castor.mapping.AccessMode;
import org.exolab.castor.persist.spi.CallbackInterceptor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JPACallbackHandler
implements CallbackInterceptor {
    private static final Log LOG = LogFactory.getLog(JPACallbackHandler.class);
    private final List<Object> _objectsToInvokeCallbacksOn = new ArrayList<Object>();
    private final Map<String, Object> _overriddenCallbacks = new HashMap<String, Object>();
    private boolean _excludeSuperclassListeners = false;

    @Override
    public Class<?> loaded(Object object, AccessMode accessMode) throws Exception {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"Calling `loaded`.");
        }
        this.handleCallbacksFor(PostLoad.class, object);
        return object.getClass();
    }

    @Override
    public void modifying(Object object) throws Exception {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"Calling `modifying`.");
        }
        this.handleCallbacksFor(PreUpdate.class, object);
    }

    @Override
    public void storing(Object object, boolean modified) throws Exception {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"Calling `storing`.");
        }
        if (modified) {
            this.handleCallbacksFor(PostUpdate.class, object);
        }
    }

    @Override
    public void creating(Object object, Database db) throws Exception {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"Calling `creating`.");
        }
        this.handleCallbacksFor(PrePersist.class, object);
    }

    @Override
    public void created(Object object) throws Exception {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"Calling `created`.");
        }
        this.handleCallbacksFor(PostPersist.class, object);
    }

    @Override
    public void removing(Object object) throws Exception {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"Calling `removing`.");
        }
        this.handleCallbacksFor(PreRemove.class, object);
    }

    @Override
    public void removed(Object object) throws Exception {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"Calling `removed`.");
        }
        this.handleCallbacksFor(PostRemove.class, object);
    }

    @Override
    public void releasing(Object object, boolean committed) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"Calling `releasing`.");
        }
    }

    @Override
    public void using(Object object, Database db) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"Calling `using`.");
        }
    }

    @Override
    public void updated(Object object) throws Exception {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"Calling `updated`.");
        }
    }

    private <A extends Annotation> void handleCallbacksFor(Class<A> annotationClass, Object object) throws InvocationTargetException, IllegalAccessException, InstantiationException, NoSuchMethodException {
        this._objectsToInvokeCallbacksOn.clear();
        this._overriddenCallbacks.clear();
        this._excludeSuperclassListeners = false;
        this.walkCallbacksHierarchyFor(annotationClass, object);
        if (this._objectsToInvokeCallbacksOn.size() > 1) {
            this.handleOverriddenCallbacksFor(annotationClass, this._objectsToInvokeCallbacksOn.get(this._objectsToInvokeCallbacksOn.size() - 1));
        }
        for (Object object2 : this._objectsToInvokeCallbacksOn) {
            this.invokeCallbacksFor(annotationClass, object2);
        }
        for (Map.Entry entry : this._overriddenCallbacks.entrySet()) {
            this.invokeCallback(entry.getValue().getClass().getDeclaredMethod((String)entry.getKey(), new Class[0]), entry.getValue());
        }
    }

    private <A extends Annotation> void walkCallbacksHierarchyFor(Class<A> annotationClass, Object object) throws InvocationTargetException, IllegalAccessException, InstantiationException {
        Class<?> klass = object.getClass();
        if (klass.isAnnotationPresent(Entity.class)) {
            Class<?> superclass = klass.getSuperclass();
            if (superclass != Object.class) {
                this.walkCallbacksHierarchyFor(annotationClass, superclass.newInstance());
            }
            if (!this._excludeSuperclassListeners) {
                this.invokeListenerCallbacksFor(annotationClass, klass);
            }
            if (klass.isAnnotationPresent(ExcludeSuperclassListeners.class)) {
                this._excludeSuperclassListeners = true;
            }
            this._objectsToInvokeCallbacksOn.add(object);
        }
    }

    private <A extends Annotation> void invokeListenerCallbacksFor(Class<A> annotationClass, Class<?> klass) throws InvocationTargetException, IllegalAccessException, InstantiationException {
        EntityListeners entityListeners;
        if (!klass.isAnnotationPresent(ExcludeDefaultListeners.class) && (entityListeners = klass.getAnnotation(EntityListeners.class)) != null) {
            Class[] listeners;
            for (Class listener : listeners = entityListeners.value()) {
                this.invokeCallbacksFor(annotationClass, listener.newInstance());
            }
        }
    }

    private <A extends Annotation> void handleOverriddenCallbacksFor(Class<A> annotationClass, Object object) throws InvocationTargetException, IllegalAccessException {
        Class<?> klass = object.getClass();
        for (Class<?> superclass = klass.getSuperclass(); superclass != Object.class; superclass = superclass.getSuperclass()) {
            for (Method method : klass.getDeclaredMethods()) {
                if (!method.isAnnotationPresent(annotationClass)) continue;
                String methodName = method.getName();
                try {
                    Method overridden = superclass.getDeclaredMethod(methodName, new Class[0]);
                    if (!overridden.isAnnotationPresent(annotationClass)) continue;
                    this._overriddenCallbacks.put(methodName, object);
                }
                catch (NoSuchMethodException e) {
                    if (!LOG.isDebugEnabled()) continue;
                    LOG.debug((Object)String.format("CB method `%s` is not overridden in `%s`.", method.getName(), superclass.getSimpleName()));
                }
            }
        }
    }

    private <A extends Annotation> void invokeCallbacksFor(Class<A> annotationClass, Object object) throws InvocationTargetException, IllegalAccessException {
        Method[] declaredMethods;
        Class<?> klass = object.getClass();
        for (Method method : declaredMethods = klass.getDeclaredMethods()) {
            if (!method.isAnnotationPresent(annotationClass) || this._overriddenCallbacks.containsKey(method.getName())) continue;
            this.invokeCallback(method, object);
        }
    }

    private void invokeCallback(Method method, Object object) throws InvocationTargetException, IllegalAccessException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)String.format("Invoking CB method `%s` on `%s`.", method.getName(), object.getClass().getSimpleName()));
        }
        method.setAccessible(true);
        method.invoke(object, new Object[0]);
    }
}

