/*
 * Decompiled with CFR 0.152.
 */
package org.castor.cpa.jpa.processors;

import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.WildcardType;
import org.castor.core.annotationprocessing.AnnotationTargetException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ReflectionsHelper {
    private ReflectionsHelper() {
    }

    /*
     * Enabled aggressive block sorting
     */
    public static Class<?> getCollectionType(AnnotatedElement target, boolean jpaTypesOnly) throws AnnotationTargetException {
        Class collectionType = null;
        Type fieldType = target instanceof Field ? ((Field)target).getGenericType() : ((Method)target).getGenericReturnType();
        if (fieldType instanceof ParameterizedType) {
            Type rawType = ((ParameterizedType)fieldType).getRawType();
            if (!(rawType instanceof Class)) {
                String message = "Can not infer raw type of generic type definition for field " + ((Member)((Object)target)).getName() + ". Raw type is not a Class object.";
                throw new AnnotationTargetException(message);
            }
            collectionType = (Class)rawType;
        } else if (fieldType instanceof Class) {
            collectionType = (Class)fieldType;
        }
        String collectionTypeName = collectionType.getSimpleName();
        if (!(!jpaTypesOnly || collectionTypeName.equals("Collection") || collectionTypeName.equals("Map") || collectionTypeName.equals("List") || collectionTypeName.equals("Set"))) {
            throw new AnnotationTargetException(collectionTypeName + " is not supported by JPA 1.0! Only Collection, Set, " + "List or Map are allowed types of OneToMany properties!");
        }
        return collectionType;
    }

    public static Class<?> getTargetEntityFromGenerics(AnnotatedElement target) throws AnnotationTargetException {
        Type targetType;
        Type fieldType = null;
        if (target instanceof Field) {
            fieldType = ((Field)target).getGenericType();
        } else if (target instanceof Method) {
            fieldType = ((Method)target).getGenericReturnType();
        } else {
            throw new IllegalArgumentException("Can only read generic definitions from Methods or Fields.");
        }
        Class targetEntity = null;
        if (fieldType instanceof ParameterizedType) {
            Type[] actualTypeArguments = ((ParameterizedType)fieldType).getActualTypeArguments();
            targetType = actualTypeArguments[0] instanceof WildcardType ? ((WildcardType)actualTypeArguments[0]).getUpperBounds()[0] : actualTypeArguments[0];
            if (!(targetType instanceof Class)) {
                String message = "Can not infer target entity for ManyToOne relation on " + ((Member)((Object)target)).getName() + " - use simplier generics or specify targetEntity!";
                throw new AnnotationTargetException(message);
            }
        } else {
            return null;
        }
        targetEntity = (Class)targetType;
        return targetEntity;
    }

    public static String getFieldnameFromGetter(Method getter) {
        String[] getterPrefixes = new String[]{"get", "is"};
        String methodName = getter.getName();
        String fieldName = null;
        for (String prefix : getterPrefixes) {
            if (!methodName.startsWith(prefix)) continue;
            fieldName = methodName.substring(prefix.length());
        }
        if (fieldName == null) {
            return null;
        }
        fieldName = fieldName.substring(0, 1).toLowerCase() + fieldName.substring(1);
        return fieldName;
    }

    public static Method getSetterMethodFromGetter(Method getter) throws SecurityException, NoSuchMethodException {
        String[] prefixes;
        if (!ReflectionsHelper.isGetter(getter)) {
            throw new IllegalArgumentException("Method is not a getter method!");
        }
        for (String prefix : prefixes = new String[]{"get", "is"}) {
            if (!getter.getName().startsWith(prefix)) continue;
            String name = getter.getName().substring(prefix.length());
            String setterName = "set" + name;
            return getter.getDeclaringClass().getDeclaredMethod(setterName, getter.getReturnType());
        }
        throw new IllegalArgumentException("Method name does not start with 'get' or 'is'!");
    }

    public static boolean isGetter(Method method) {
        return method.getName().startsWith("get") || method.getName().startsWith("is");
    }
}

