/*
 * Decompiled with CFR 0.152.
 */
package org.castor.cpa.jpa.processors.classprocessors;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import javax.persistence.Entity;
import javax.persistence.SequenceGenerator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.castor.core.annotationprocessing.AnnotationTargetException;
import org.castor.core.nature.BaseNature;
import org.castor.cpa.jpa.info.GeneratorNameAlreadyUsedException;
import org.castor.cpa.jpa.info.JPAKeyGeneratorManager;
import org.castor.cpa.jpa.info.JPASequenceGeneratorDescriptor;
import org.castor.cpa.jpa.processors.BaseJPAAnnotationProcessor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JPASequenceGeneratorClassProcessor
extends BaseJPAAnnotationProcessor {
    private static final Log LOG = LogFactory.getLog(JPASequenceGeneratorClassProcessor.class);

    public final <I extends BaseNature, A extends Annotation> boolean processAnnotation(I info, A annotation, AnnotatedElement target) throws AnnotationTargetException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Processing annotation " + ((Object)annotation).toString()));
        }
        if (!this.verifyArguments(annotation, target)) {
            return false;
        }
        boolean processingResult = this.processGeneratorDefinition(annotation);
        return processingResult;
    }

    private <A> boolean verifyArguments(A annotation, AnnotatedElement target) {
        return annotation instanceof SequenceGenerator && target.isAnnotationPresent(SequenceGenerator.class) && target.isAnnotationPresent(Entity.class);
    }

    private <A> boolean processGeneratorDefinition(A annotation) {
        SequenceGenerator sequenceGenerator = (SequenceGenerator)annotation;
        JPAKeyGeneratorManager manager = JPAKeyGeneratorManager.getInstance();
        JPASequenceGeneratorDescriptor descriptor = JPASequenceGeneratorDescriptor.extract(sequenceGenerator);
        try {
            manager.add(sequenceGenerator.name(), descriptor);
        }
        catch (GeneratorNameAlreadyUsedException e) {
            return false;
        }
        return true;
    }

    public final Class<? extends Annotation> forAnnotationClass() {
        return SequenceGenerator.class;
    }
}

