/*
 * Decompiled with CFR 0.152.
 */
package org.castor.cpa.jpa.processors.fieldprocessors;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import javax.persistence.FetchType;
import javax.persistence.ManyToOne;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.castor.core.nature.BaseNature;
import org.castor.cpa.jpa.natures.JPAFieldNature;
import org.castor.cpa.jpa.processors.BaseJPAAnnotationProcessor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JPAManyToOneProcessor
extends BaseJPAAnnotationProcessor {
    private static Log _log = LogFactory.getFactory().getInstance(JPAManyToOneProcessor.class);

    public Class<? extends Annotation> forAnnotationClass() {
        return ManyToOne.class;
    }

    public <I extends BaseNature, A extends Annotation> boolean processAnnotation(I info, A annotation, AnnotatedElement target) {
        if (info instanceof JPAFieldNature && annotation instanceof ManyToOne && (target instanceof Method || target instanceof Field)) {
            _log.debug((Object)("processing field annotation " + ((Object)annotation).toString()));
            ManyToOne manyToOne = (ManyToOne)annotation;
            JPAFieldNature jpaFieldNature = (JPAFieldNature)info;
            jpaFieldNature.setManyToOne(true);
            Class<?> targetEntity = null;
            targetEntity = Void.TYPE.equals(manyToOne.targetEntity()) ? (target instanceof Field ? ((Field)target).getType() : ((Method)target).getReturnType()) : manyToOne.targetEntity();
            jpaFieldNature.setRelationTargetEntity(targetEntity);
            if (manyToOne.cascade().length > 0) {
                jpaFieldNature.setCascadeTypes(manyToOne.cascade());
            }
            jpaFieldNature.setRelationLazyFetch(false);
            if (manyToOne.fetch() == FetchType.LAZY) {
                jpaFieldNature.setRelationLazyFetch(true);
            }
            if (!manyToOne.optional()) {
                _log.warn((Object)"Checking of null values is not supported by Castor - the database has to check for null values!");
            }
            jpaFieldNature.setRelationOptional(manyToOne.optional());
            return true;
        }
        return false;
    }
}

