/*
 * Decompiled with CFR 0.152.
 */
package org.castor.cpa.jpa.processors.fieldprocessors;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import javax.persistence.FetchType;
import javax.persistence.OneToOne;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.castor.core.nature.BaseNature;
import org.castor.cpa.jpa.natures.JPAFieldNature;
import org.castor.cpa.jpa.processors.BaseJPAAnnotationProcessor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JPAOneToOneProcessor
extends BaseJPAAnnotationProcessor {
    private static Log _log = LogFactory.getFactory().getInstance(JPAOneToOneProcessor.class);

    public Class<? extends Annotation> forAnnotationClass() {
        return OneToOne.class;
    }

    public <I extends BaseNature, A extends Annotation> boolean processAnnotation(I info, A annotation, AnnotatedElement target) {
        if (info instanceof JPAFieldNature && annotation instanceof OneToOne && (target instanceof Method || target instanceof Field)) {
            _log.debug((Object)("processing field annotation " + ((Object)annotation).toString()));
            OneToOne oneToOne = (OneToOne)annotation;
            JPAFieldNature jpaFieldNature = (JPAFieldNature)info;
            jpaFieldNature.setOneToOne(true);
            Class<?> targetEntity = null;
            targetEntity = Void.TYPE.equals(oneToOne.targetEntity()) ? (target instanceof Field ? ((Field)target).getType() : ((Method)target).getReturnType()) : oneToOne.targetEntity();
            jpaFieldNature.setRelationTargetEntity(targetEntity);
            if (oneToOne.cascade().length > 0) {
                jpaFieldNature.setCascadeTypes(oneToOne.cascade());
            }
            jpaFieldNature.setRelationLazyFetch(false);
            if (oneToOne.fetch() == FetchType.LAZY) {
                jpaFieldNature.setRelationLazyFetch(true);
            }
            if (!oneToOne.optional()) {
                _log.warn((Object)"Checking of null values is not supported by Castor - the database has to check for null values!");
            }
            jpaFieldNature.setRelationOptional(oneToOne.optional());
            if (oneToOne.mappedBy().length() != 0) {
                _log.error((Object)"Castor does not support inverse OneToOne relations!");
            }
            return true;
        }
        return false;
    }
}

