/*
 * Decompiled with CFR 0.152.
 */
package org.castor.cpa.jpa.processors.fieldprocessors;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import javax.persistence.Version;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.castor.core.annotationprocessing.AnnotationTargetException;
import org.castor.core.nature.BaseNature;
import org.castor.cpa.jpa.info.JPAVersionManager;
import org.castor.cpa.jpa.info.MultipleVersionFieldDefinitionException;
import org.castor.cpa.jpa.processors.BaseJPAAnnotationProcessor;
import org.castor.cpa.jpa.processors.ReflectionsHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JPAVersionProcessor
extends BaseJPAAnnotationProcessor {
    private static final Log LOG = LogFactory.getLog(JPAVersionProcessor.class);

    public <I extends BaseNature, A extends Annotation> boolean processAnnotation(I info, A annotation, AnnotatedElement target) throws AnnotationTargetException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Processing annotation " + ((Object)annotation).toString()));
        }
        if (!this.verifyArguments(annotation, target)) {
            return false;
        }
        return this.processGeneratorDefinition(annotation, target);
    }

    private <A> boolean verifyArguments(A annotation, AnnotatedElement target) {
        return annotation instanceof Version && target.isAnnotationPresent(Version.class);
    }

    private <A> boolean processGeneratorDefinition(A annotation, AnnotatedElement target) {
        Method method = (Method)target;
        Class<?> declaringClass = method.getDeclaringClass();
        JPAVersionManager manager = JPAVersionManager.getInstance();
        try {
            manager.add(declaringClass, ReflectionsHelper.getFieldnameFromGetter(method));
        }
        catch (MultipleVersionFieldDefinitionException e) {
            return false;
        }
        return true;
    }

    public Class<? extends Annotation> forAnnotationClass() {
        return Version.class;
    }
}

