/*
 * Decompiled with CFR 0.152.
 */
package org.castor.cpa.persistence.convertor;

import java.text.DecimalFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.castor.cpa.persistence.convertor.AbstractDateTypeConvertor;

public final class DoubleToDate
extends AbstractDateTypeConvertor {
    private static final String DECIMAL_PATTERN = "#################0";
    private static final DecimalFormat DECIMAL_FORMAT = new DecimalFormat("#################0");
    private SimpleDateFormat _customDateFormat;

    private static DecimalFormat getDecimalFormat() {
        return (DecimalFormat)DECIMAL_FORMAT.clone();
    }

    public DoubleToDate() {
        super(Double.class, Date.class);
        this.parameterize(null);
    }

    public void parameterize(String parameter) {
        this._customDateFormat = DoubleToDate.getDefaultDateFormat();
        this._customDateFormat.applyPattern(DoubleToDate.getFullDatePattern(parameter));
    }

    private SimpleDateFormat getCustomDateFormat() {
        return (SimpleDateFormat)this._customDateFormat.clone();
    }

    public Object convert(Object object) {
        try {
            return this.getCustomDateFormat().parse(DoubleToDate.getDecimalFormat().format(object).trim());
        }
        catch (ParseException ex) {
            throw new IllegalArgumentException(ex.toString());
        }
    }
}

