/*
 * Decompiled with CFR 0.152.
 */
package org.castor.cpa.persistence.sql.connection;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import org.castor.cpa.persistence.sql.connection.CallableStatementProxy;
import org.castor.cpa.persistence.sql.connection.ConnectionProxy;
import org.castor.cpa.persistence.sql.connection.PreparedStatementProxy;

public final class ConnectionProxyFactory {
    public static Connection newConnectionProxy(Connection connection, String calledBy) {
        ClassLoader loader = connection.getClass().getClassLoader();
        Class[] interfaces = new Class[]{Connection.class};
        ConnectionProxy handler = new ConnectionProxy(connection, calledBy);
        return (Connection)Proxy.newProxyInstance(loader, interfaces, (InvocationHandler)handler);
    }

    protected static PreparedStatement newPreparedStatementProxy(PreparedStatement statement, String sql) {
        ClassLoader loader = statement.getClass().getClassLoader();
        Class[] interfaces = new Class[]{PreparedStatement.class};
        PreparedStatementProxy handler = new PreparedStatementProxy(statement, sql);
        return (PreparedStatement)Proxy.newProxyInstance(loader, interfaces, (InvocationHandler)handler);
    }

    protected static CallableStatement newCallableStatementProxy(CallableStatement statement, String sql) {
        ClassLoader loader = statement.getClass().getClassLoader();
        Class[] interfaces = new Class[]{CallableStatement.class};
        CallableStatementProxy handler = new CallableStatementProxy(statement, sql);
        return (CallableStatement)Proxy.newProxyInstance(loader, interfaces, (InvocationHandler)handler);
    }

    private ConnectionProxyFactory() {
    }
}

